;-------------------------------------------------------------------
; PAUSEPOP.ASM -- Notifies that detached OS/2 program is terminated
;                 (c) 1988, Ziff Communications Co.
;                 PC Magazine * Charles Petzold, 3/88
;-------------------------------------------------------------------

               .286

               INCLUDE OS2.INC

               DOSSEG
               .MODEL    SMALL
               .STACK    4096

                                   ;--------------------------
               .DATA               ; Initialized Data Segment
                                   ;--------------------------

               db   "PAUSEPOP (c) 1988, Ziff Communications Co. "
               db   "PC Magazine ", 254," Charles Petzold, 6/88"

PopupFlag      dw   VP_WAIT OR VP_TRANSPARENT

PauseMsg       db   201, 78 dup (205), 187
               db   186, 78 dup (" "), 186
               db   186, " PAUSEPOP: "
InsertMsg      db        67 dup (" "), 186
               db   186, 78 dup (" "), 186
               db   199, 78 dup (196), 182
               db   186, " Press Enter to continue.", 53 dup (" "), 186
               db   200, 78 dup (205), 188

Attribute1     db   1Fh
Attribute2     db   70h

vioci          VIOCURSORINFO <0, 0, 0, -1>
kbci           KBDKEYINFO <>

                                   ;--------------
               .CODE               ; Code Segment
                                   ;--------------

;---------------------------------------
; Parse command line to get text string
;---------------------------------------

Entry:         Mov  ES, AX                   ; Environment selector

SkipProgName:  Mov  AL, ES:[BX]              ; Pull a command line byte
               Inc  BX
               Or   AL, AL                   ; Check if it's zero
               Jnz  SkipProgName             ; If not, continue

SkipSpaces:    Mov  AL, ES:[BX]              ; Get a byte
               Inc  BX                       ; Kick up the pointer
               Or   AL, AL                   ; See if end of parameter
               Jz   FinishMsg                ; If so, store CX

               Cmp  AL, ' '                  ; See if it's a space
               Jz   SkipSpaces               ; If so, try another

               Mov  CX, 66                   ; Max number of characters
               Mov  DI, Offset InsertMsg     ; Destination of message

Transfer:      Mov  [DI], AL                 ; Store byte in message
               Inc  DI                       ; Increment pointer

               Mov  AL, ES:[BX]              ; Get next byte
               Inc  BX                       ; Kick up source pointer
               Or   AL, AL                   ; See if its zero
               Loopnz Transfer               ; Continue if not zero

FinishMsg:

;-------------------------------------------------------------------
; Pop up on clear screen (always 80 by 25) and display text strings
;-------------------------------------------------------------------

               @VioPopup PopupFlag, 0        ; Try pop up transparently

               Or   AX, AX                   ; Check error code
               Jz   PoppedUp                 ; Continue if no error

               Mov  [PopupFlag], VP_WAIT OR VP_OPAQUE

               @VioPopup PopupFlag, 0        ; Pop up opaquely

PoppedUp:      Mov  CX, 7                    ; Number of lines
               Sub  DX, DX                   ; Row number
               Sub  SI, SI                   ; Offset in PauseMsg

LineLoop:      @VioWrtCharStrAtt PauseMsg[SI], 80, DX, 0, Attribute1, 0

               Inc  DX                       ; Next row
               Add  SI, 80                   ; Next line in message
               Loop LineLoop

               @VioWrtNAttr Attribute2, 24, 5, 2, 0

               @VioSetCurType vioci, 0       ; Hide cursor

               @DosBeep 256, 250             ; Alert user

;---------------------------------------
; Wait for keystroke and then terminate
;---------------------------------------

               @KbdFlushBuffer 0             ; Flush keyboard buffer

CheckKey:      @KbdCharIn kbci, IO_WAIT, 0   ; Wait for keystroke

               Cmp  [kbci.kbci_chChar], 13   ; Check if Enter
               Jnz  CheckKey                 ; If not, get another key

               @VioEndPopUp 0                ; End the popup

               @DosExit EXIT_PROCESS, 0      ; Exit program

               END  Entry
