/*
    QFN.C   Qualify Filename

    (C) 1988 Ziff Davis Communications
    Ray Duncan, April 1988
*/

#include <stdio.h>
#include <string.h>
#include <dos.h>

union REGS regs;

static void setdrv(int);            /* function prototypes */
static void setpath(char *);
static int getdrv(void);
static void getpath(char *);

static char qbuff[80];              /* for qualified filename */

char *qfn(char *p)
{   
    char tbuff[80];                 /* target directory */
    char cpath[80];                 /* path at entry */
    int cdrive;                     /* drive at entry */
    char *q;                        /* scratch pointer */
    unsigned i;                     /* scratch index */

    cdrive = getdrv();              /* get current drive */

    getpath(&cpath[1]);             /* get current directory */
    cpath[0] = '\\';                /* and prepend backslash */

                                    /* any drive specified? */
    if((strlen(p) >= 2) && (p[1] == ':'))
    {   
        i = (p[0] | 0x20) - 'a';    /* yes, convert ASCII drive 
                                       to binary drive code */

        setdrv(i);                  /* switch to new drive */

        if(getdrv() != i)           /* if drive doesn't exist */
            return(NULL);           /* return an error */

        getpath(&cpath[1]);         /* get current directory
                                       of new drive */

        p += 2;                     /* bump ptr past drive */
    }   

    strcpy(tbuff, p);               /* copy target pathname 
                                       to local buffer */

    q = strrchr(tbuff, '\\');       /* look for last backslash */

    if (q != NULL)                  /* any path specified? */
    {   
        *q = 0;                     /* yes, make path ASCIIZ */

        if(q == tbuff)              /* select directory */
             setpath("\\");         /* target is root */
        else setpath(tbuff);        /* target is not root */

        if(regs.x.cflag)            /* exit if directory */
        {                           /* does not exist */
            setpath(cpath);         /* restore original path */
            setdrv(cdrive);         /* restore original drive */
            return(NULL);
        }
        
        q += 1;                     /* point to filename */
    }
    else q = tbuff;                 /* if no path specified,
                                       point to filename */

                                    /* now drive and/or path
                                       are selected, build
                                       qualified filename */

    qbuff[0] = getdrv() + 'a';      /* get target drive and
                                       convert to ASCII */

    qbuff[1] = ':';                 /* add drive delimiter */
    qbuff[2] = '\\';                /* and root backslash */

    getpath(&qbuff[3]);             /* get target directory */
    
    i = strlen(qbuff);              /* length of drive+path */

    if(i != 3) qbuff[i++] = '\\';   /* if not root add a
                                       trailing backslash */

    strcpy(qbuff+i, q);             /* copy in filename */  

    setpath(cpath);                 /* restore original path */
    setdrv(cdrive);                 /* restore original drive */

    return(strlwr(qbuff));          /* fold pathname to lower 
                                       case, return pointer */
}


/*
    Set current drive using MS-DOS Int 21H Function 0EH
*/
static void setdrv(int drive)
{
    regs.h.ah = 0x0e;
    regs.h.dl = drive;
    int86(0x21, &regs, &regs);
}


/*
    Set current path using MS-DOS Int 21H Function 3BH
*/
static void setpath(char *p)
{
    regs.h.ah = 0x3b;
    regs.x.dx = (unsigned) p;
    int86(0x21, &regs, &regs);
}


/*
    Get current drive using MS-DOS Int 21H Function 19H
*/
static int getdrv(void)
{
    regs.h.ah = 0x19;
    int86(0x21, &regs, &regs);
    return(regs.h.al);
}


/*
    Get current path using MS-DOS Int 21H Function 47H
*/
static void getpath(char *p)
{
    regs.h.ah = 0x47;       
    regs.h.dl = 0;
    regs.x.si = (unsigned) p;
    int86(0x21, &regs, &regs);
}
