#include "stdio.h"

#define L_GETEAR 6             /* bytes in binary E/N address */
#define L_EA     (2 * (L_GETEAR + 1)) /* size of ASCII E/N address */
#define IE_GP    8            /* xmit, station addr PROM pointer */
#define IE_SA    12           /* station address PROM window */
#define EA_BASE  0x300        /* Ethernet adapter base address */

main()
{
   int i, byte, base = EA_BASE;   /* 3C501 adapter I/O base address */

   for (i=0; i<L_GETEAR; i++) {
      outport (base + IE_GP, i);        /* point to E/N address byte */
      byte = inportb (base + IE_SA);    /* fetch address byte */
      printf ("%02x", byte & 0xff);
      }
   printf ("\n");
}
