
/* merge.c
 * DESCRIPTION: merges a 'c' source file with an asm file
 */

#include <stdio.h>

#define LINEBUFFER 200                     /* length of input line */
#define NAMESIZE 80                        /* DOS file/path length */

FILE *p_to_c, *p_to_asm, *p_to_mer;        /* declare file pointers */
char line_buffer[LINEBUFFER];              /* line buffer */
                                           /* file name buffers */
char file_c[NAMESIZE], file_asm[NAMESIZE], file_mer[NAMESIZE];

main(argc,argv)
int argc;
char *argv[];
{
   int line_count, run_count = 0;

   if (argc != 2)
       help_me();                  /* print the usage message */

   strcpy(file_c,argv[1]);         /* setup the .C filename */
   strcat(file_c,".c");
   
   if(!(p_to_c = fopen(file_c,"r")))       /* open the .C file */
       file_error(file_c);

   strcpy(file_asm,argv[1]);           /* setup the .ASM filename */
   strcat(file_asm,".asm");

   if(!(p_to_asm = fopen(file_asm,"r")))   /* open the .ASM file */
       file_error(file_asm);

   strcpy(file_mer,argv[1]);           /* setup the .MER filename  */
   strcat(file_mer,".mer");
   
   if(!(p_to_mer = fopen(file_mer,"w")))   /* open the .MER file */
       file_error(file_mer);

                           /* read each line of the .ASM file */
   while (fgets(line_buffer,LINEBUFFER,p_to_asm) )
   {
       if(strncmp(line_buffer,"; Line",6))/* if "; Line" not found */
       {
           fputs(line_buffer,p_to_mer);    /* write it to merge file */
           continue;                   /* get next line */
       }
                                   /* "; Line" was found */
       line_count = atoi( &line_buffer[7] );   /* generate a line count */

       if(run_count < line_count)      /* if backlog in .C file */
           for( ; run_count < line_count; run_count++)
               write_merge_line();     /* write the lines and catch up */
       else
       {
           write_merge_line();         /* write corresponding C line */
           run_count++;
       }
   }
   fclose(p_to_c);                 /* close all files */
   fclose(p_to_asm);
   fclose(p_to_mer);
}

/* write_merge_line()
 *  reads a line from the C source, and writes it out preceded by
 *  a ';'
 */
write_merge_line()
{
   fgets(line_buffer,LINEBUFFER,p_to_c);   /* get .C file line */
   fputs("; ",p_to_mer);                   /* write ';' to merge file */
   fputs(line_buffer,p_to_mer);            /* put .C line after it */
}

/* help_me
 * DESCRIPTION: prints out the title and usage
 */

help_me()
{
   printf("MERGE: a program to merge a 'c' source file and an ASM file\n");
   printf("USAGE: merge filename \n");
   printf("where filename is the name of the files to merge\n");
   printf("Do not type in the period or extension.\n");
   exit(0);
}

/* file_error
 * DESCRIPTION: prints out error message and name of the
 *               file that could not be opened
 */

file_error(name)
char *name;
{
   printf("MERGE: ERROR IN OPENING FILE: %s \n",name);
   exit(0);
}

