        name    TRYLCVT
        title   TRYLCVT --- LCVT demonstration
        page    55,132

;
; TRYLCVT.ASM --- an interactive demonstration of
;                 the LCVT formatting routine
;
; To exit from the program, push <Enter>
; alone at the "Enter a number" prompt.
;
; Ray Duncan, December 1987
;

cr      equ     0dh
lf      equ     0ah


DGROUP  group   _DATA


_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:_DATA

        extrn   ATOL:near               ; ASCII to long integer
        extrn   LCVT:near               ; format decimal long int.
        extrn   HTOL:near               ; hex ASCII to long int.

main    proc    near

        mov     ax,_DATA                ; make our data segment
        mov     ds,ax                   ; addressable...
        mov     es,ax
        
        mov     dx,offset signon        ; display sign-on message
        mov     cx,so_len
        call    pmsg

main1:  mov     dx,offset prompt1       ; get number to convert
        mov     cx,p1_len
        call    getnum
        cmp     byte ptr inbuff,cr      ; was anything entered?
        jne     main2                   ; yes, proceed

        mov     ax,4c00h                ; no, exit to MS-DOS
        int     21h

main2:  mov     fval,ax                 ; yes, save the number
        mov     fval+2,dx

        mov     dx,offset prompt2       ; get output width
        mov     cx,p2_len
        call    getnum
        or      al,al                   ; make sure width nonzero
        jz      main1                   ; jump, width was zero
        mov     fwidth,al               ; else save width

        mov     dx,offset prompt3       ; get decimal places
        mov     cx,p3_len
        call    getnum
        mov     fdecpl,al               ; and save it

        mov     dx,offset prompt4       ; get conversion flags
        mov     cx,p4_len
        call    getnum
        mov     si,offset inbuff        ; ignore decimal value,
        call    htol                    ; convert input as hex,
        mov     flags,al                ; save conversion flags

        test    al,10h                  ; special pad character?
        jz      main3                   ; no, jump

        mov     dx,offset prompt5       ; get pad character
        mov     cx,p5_len
        call    pmsg                    ; display prompt
        mov     ah,1                    ; func. 1 = char. input
        int     21h                     ; transfer to MS-DOS
        mov     fpad,al                 ; save pad character
        cmp     al,' '                  ; was it a control. char?
        jae     main3                   ; no, proceed
        mov     fpad,' '                ; yes, use a blank instead

main3:  mov     dx,offset display       ; display "You entered: "
        mov     cx,d_len                ; to the user...
        call    pmsg

                                        ; load registers and call
                                        ; LCVT formatting routine...
        mov     dx,fval+2               ; 32-bit number to convert
        mov     ax,fval
        mov     bh,fdecpl               ; number of decimal places
        mov     bl,fwidth               ; output field width
        mov     ch,flags                ; conversion flags
        mov     cl,fpad                 ; pad character
        mov     si,offset outbuff       ; DS:SI -> output buffer
        call    lcvt                    ; now format the number
                                        ; returns DS:SI = output
                                        ; field, AX = length,
                                        ; Carry = success/error

        mov     cx,ax                   ; CX = string length
        mov     dx,si                   ; DS:DX = string address 
        call    pmsg                    ; display formatted string

        jmp     main1                   ; do it again...

main    endp


pmsg    proc    near                    ; display message on stdout
                                        ; call with 
                                        ; DS:DX = message address
                                        ; CX    = message length

        mov     bx,1                    ; handle 1 = standard output
        mov     ah,40h                  ; function 40h = write
        int     21h                     ; transfer to MS-DOS
        ret                             ; return to caller

pmsg    endp


getnum  proc    near                    ; display prompt, get input,
                                        ; and convert to binary
                                        ; call with
                                        ; DS:DX = prompt address
                                        ; CX    = prompt length
                                        ; returns
                                        ; DX:AX = value entered

        call    pmsg                    ; display the prompt

        mov     dx,offset inbuff        ; read keyboard entry
        mov     cx,80                   ; from the user...
        mov     bx,0                    ; handle 0 = standard input
        mov     ah,3fh                  ; funct. 3FH = read
        int     21h                     ; transfer to MS-DOS

        mov     si,offset inbuff        ; convert convert user's 
        call    atol                    ; input to binary in DX:AX

        ret                             ; return to caller

getnum  endp


_TEXT   ends


_DATA   segment word public 'DATA'

signon  db      cr,lf,'LCVT Demonstration Program'
so_len  equ     $-signon

prompt1 db      cr,lf,lf,lf
        db      'Enter a number:       '
p1_len  equ     $-prompt1

prompt2 db      cr,lf
        db      'Enter output width:   '
p2_len  equ     $-prompt2
                                                   
prompt3 db      cr,lf
        db      'Enter decimal places: '
p3_len  equ     $-prompt3

prompt4 db      cr,lf
        db      'Enter flags (hex):    '
p4_len  equ     $-prompt4

prompt5 db      cr,lf
        db      'Enter pad character:  '
p5_len  equ     $-prompt5

display db      cr,lf,lf
        db      'You entered:          '
d_len   equ     $-display

fval    dw      0,0                     ; value to be formatted 
flags   db      0                       ; conversion flags
fwidth  db      0                       ; width of output field
fdecpl  db      0                       ; decimal places
fpad    db      0                       ; padding char.

inbuff  db      80 dup (?)              ; keyboard input buffer

outbuff db      80 dup (?)              ; output formatting buffer

_DATA   ends


STACK   segment para stack 'STACK'
        
        db      128 dup (?)

STACK   ends

        end     main

