//-------------------------------------------------------------------
// FTR.C - A video demonstration program
//
// Copyright 1993 Douglas Boling
//-------------------------------------------------------------------

#include <bios.h>
#include <graph.h>

void DrawShip (int);
void EraseShip (int);
void GetVideoBuff (void);

unsigned int usVSeg, usVOff;

main () {
   unsigned far * lptr;
   int     i, j, k, m;
   
   _setvideomode (_TEXTC80);               // Set video mode
   _clearscreen (_GCLEARSCREEN);           // Clear screen
   
   GetVideoBuff();
   // Display fighter and loop
   k = 0;
   for (i = 0; i < 25; i += 4) {
      for (j = i * 2; j < 150 - (i * 2); j += 2) {
         EraseShip(k);
         k = j + (i * 160);
         DrawShip (k);
         for (m = 0; m < 32384; m++);
      }    
      for (j = 150 - (i * 2); j > (i * 2); j -= 2) {
         EraseShip(k);
         k = j + ((i + 2) * 160);
         DrawShip (k);
         for (m = 0; m < 32384; m++);
      }
   }
   return 0;
}
//
// Determine video buffer location
//
void GetVideoBuff (void) {
   lptr = 0x400063;                        // Get video segment
   if ((*lptr && 0x400) == 0) 
      usVSeg = 0xb000;
   else   
      usVSeg = 0xb800; 

   lptr = 0x40004e;                        // Get video buff offset
   usVOff = *lptr;
   return;
}
//
// Draw spaceship using text characters
//
void DrawShip (int sOffset) {
   char far *lpBuff;

   lpBuff = (((long) usVSeg) << 16) | sOffset;
   *lpBuff = 199;
   lpBuff += 2;
   *lpBuff = 79;
   lpBuff += 2;
   *lpBuff = 182;
   return;
}
//
// Erase space ship using blanks
//
void EraseShip (int sOffset) {
   char _far *lpBuff;
   
   lpBuff = (((long) usVSeg) << 16) | sOffset;
   *lpBuff = 32;
   lpBuff +=2;
   *lpBuff = 32;
   lpBuff +=2;
   *lpBuff = 32;
   return;
}
