//========================================================================
// 
//  RClick.c -- A popup menu program
//
//  Copyright (c) Douglas Boling, 1993
//
//  For better readability, set tab stops to every 3 characters.
//
//========================================================================
#define  WINVER      0x0300

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "rclick.h"
#include "rchook.h"
 
//------------------------------------------------------------------------
//Function prototypes
//------------------------------------------------------------------------
int	PASCAL 		WinMain (HANDLE, HANDLE, LPSTR, int);
long	FAR PASCAL	WndProc (HWND, WORD, WORD, LONG);


char     szStr[64];
char		szTemp[20];

char		szAppName[] = "RClick";
char		szProfileName[] = "RCLICK.INI";
HANDLE  	hInst;
HWND		hwndTarg;
HOOKSTAT	hsStatus;
int		xPos, yPos;

//=======================================================================
//
// Program Entry Point (WinMain)
//
//=======================================================================
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
	            LPSTR lpszCmdParam, int nCmdShow) {

   HWND			hwnd;
	HANDLE		hAccel;
   MSG			msg;
   WNDCLASS		wndclass;
   int			i, sCount;

	if (hPrevInstance) 
	   return 0;
	   
   wndclass.style          = CS_HREDRAW | CS_VREDRAW;
   wndclass.lpfnWndProc    = WndProc;
   wndclass.cbClsExtra     = 0;
   wndclass.cbWndExtra     = DLGWINDOWEXTRA;
   wndclass.hInstance      = hInstance;
   wndclass.hIcon          = LoadIcon (hInstance, szAppName);
   wndclass.hCursor        = LoadCursor (NULL, IDC_ARROW);
   wndclass.hbrBackground  = COLOR_WINDOW + 1;
   wndclass.lpszMenuName   = 0;
   wndclass.lpszClassName  = szAppName;
   RegisterClass (&wndclass);

   hwnd = CreateDialog (hInstance, szAppName, 0, NULL);
	nCmdShow |= SW_MINIMIZE;

	ShowWindow (hwnd, nCmdShow);
	hAccel = LoadAccelerators (hInstance, szAppName);
	
	sCount = GetPrivateProfileInt (szAppName, "Count", 0, szProfileName);
	for (i = 0; i < sCount; i++) {
	   itoa (i, szTemp, 10);
	   GetPrivateProfileString ("NoPopProgs", szTemp, "None", szStr, 
		                         sizeof (szStr), szProfileName);
		if (strcmp (szStr, "None") != 0)		                         
			SetNoPop ((LPSTR) szStr);
	}	
	if (GetPrivateProfileInt (szAppName, "Enabled", 1, szProfileName))
		hsStatus.bEnabled = TRUE;
	else
		hsStatus.bEnabled = FALSE;
	   
	hsStatus.hwndMyWin = hwnd;
	SetStatus (&hsStatus);

	while (GetMessage (&msg, NULL, 0, 0)) {
	   TranslateMessage (&msg);
	   DispatchMessage (&msg);
	}
	//Disable tracking
	
   return msg.wParam;
}

//========================================================================
//
// Routines used by WndProc
//
//========================================================================
//------------------------------------------------------------------------
// Set Enable Text
//------------------------------------------------------------------------
VOID SetButtons (HWND hwnd, BOOL bEnable) {

	if (bEnable) {
		SetWindowText (hwnd, "RClick - Enabled");
		SetDlgItemText (hwnd, IDD_ENABLE, "Disable");
	} else {
		SetWindowText (hwnd, "Rclick - Disabled");
		SetDlgItemText (hwnd, IDD_ENABLE, "Enable");
	}
   if (SendDlgItemMessage (hwnd, IDD_NOPOPLIST, LB_GETCURSEL, 0, 0L) == LB_ERR)
		EnableWindow (GetDlgItem (hwnd, IDD_REMOVE), FALSE);
	else
		EnableWindow (GetDlgItem (hwnd, IDD_REMOVE), TRUE);
	
	return;
}

//------------------------------------------------------------------------
//
// About box dialog procedure
//
//------------------------------------------------------------------------
BOOL FAR PASCAL AboutDlgProc (HWND hwnd, WORD message, WORD wParam, 
                               LONG lParam) {
	RECT	rect;
	
	switch (message) {
		case WM_INITDIALOG:
			GetWindowRect  (hwnd, &rect);
			xPos = max (0, xPos - (rect.right - rect.left)/2);
			yPos = max (0, yPos - (rect.bottom - rect.top)/2);
			SetWindowPos (hwnd, 0, xPos, yPos, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
		
			return TRUE;
			
		case WM_COMMAND:
			switch (wParam) {

				case IDOK:
					EndDialog (hwnd, 1);
					return TRUE;
			}
			break;

		case WM_CLOSE:
			EndDialog (hwnd, 0);
			return TRUE;
	}
	return FALSE;	
}

//------------------------------------------------------------------------
// Config box dialog procedure
//------------------------------------------------------------------------
BOOL FAR PASCAL ConfigDlgProc (HWND hwnd, WORD message, WORD wParam, 
                                LONG lParam) {
	char		szText[128];
	RECT		rect;
	HOOKSTAT	hsHook;
	                                 
	switch (message) {
		case WM_INITDIALOG:
			GetWindowRect  (hwnd, &rect);
			xPos = max (0, xPos - (rect.right - rect.left)/2);
			yPos = max (0, yPos - (rect.bottom - rect.top)/2);
			SetWindowPos (hwnd, 0, xPos, yPos, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
		
			GetWindowText (hwndTarg, szStr, sizeof szStr);
			strcpy (szText, "Window Title:\t");
			strcat (szText, szStr);
			SetDlgItemText (hwnd, IDD_WINTITLE, szText);

			GetModuleFileName (GetWindowWord (hwndTarg, GWW_HINSTANCE),
			                   szStr, sizeof (szStr));
						                   
			strcpy (szText, "Program Name:\t");
			strcat (szText, strrchr(szStr, '\\')+1);
			SetDlgItemText (hwnd, IDD_PROGNAME, szText);
			break;			
			
		case WM_COMMAND:
			GetStatus (&hsHook);
			switch (wParam) {
		      //
		      // Button controls
		      //	
				case IDD_DELBYTITLE:
					GetModuleFileName (GetWindowWord (hwndTarg, GWW_HINSTANCE),
					                   szStr, sizeof (szStr));
					SetNoPop ((LPSTR) strrchr(szStr, '\\')+1);
					EndDialog (hwnd, 1);
					return TRUE;
				
				case IDD_DISABLERB:
					if (hsHook.bEnabled) 
					   hsHook.bEnabled = FALSE;
					else
					   hsHook.bEnabled = TRUE;
					SetStatus (&hsHook);
					EndDialog (hwnd, 1);
					return TRUE;
				
				case IDCANCEL:
					EndDialog (hwnd, 1);
					return TRUE;
			}
			break;

		case WM_CLOSE:
			EndDialog (hwnd, 0);
			return TRUE;
	}
	return FALSE;	
}
//========================================================================
//
// Main Window Procedure.
//
//========================================================================
long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam) {

	FARPROC	lpfnDlgFn;
	HOOKSTAT	hsHook;
	RECT		rect;
	int		i;

   switch (message) {
	
      case WM_CREATE:
			hInst = ((LPCREATESTRUCT) lParam)->hInstance;
			return 0;

		case WM_SIZE:
			if (wParam == SIZE_RESTORED) {
				GetStatus (&hsHook);
				SendDlgItemMessage (hwnd, IDD_NOPOPLIST, LB_RESETCONTENT, 0, 0L);
				for (i = 0; i < hsHook.sNoPopCnt; i++) {
				   GetNoPop (i, (LPSTR) szStr);
					SendDlgItemMessage (hwnd, IDD_NOPOPLIST, LB_ADDSTRING, 0, 
					                    (LPARAM)(LPSTR) szStr);
				}
				SetButtons (hwnd, hsHook.bEnabled);
			}	
			break;

		case RBM_SHOWCONFIGDLG:
			hwndTarg = (HWND) wParam;
			xPos = LOWORD (GetMessagePos());
			yPos = HIWORD (GetMessagePos());
			
			lpfnDlgFn = MakeProcInstance (ConfigDlgProc, hInst);
			DialogBox (hInst, "Config", hwnd, lpfnDlgFn);
			FreeProcInstance (lpfnDlgFn);

			GetStatus (&hsHook);
			SendDlgItemMessage (hwnd, IDD_NOPOPLIST, LB_RESETCONTENT, 0, 0L);
			for (i = 0; i < hsHook.sNoPopCnt; i++) {
			   GetNoPop (i, (LPSTR) szStr);
				SendDlgItemMessage (hwnd, IDD_NOPOPLIST, LB_ADDSTRING, 0, 
				                    (LPARAM)(LPSTR) szStr);
			}
			SetButtons (hwnd, hsHook.bEnabled);
			return 0;
		
		case RBM_SHOWABOUTDLG:
			xPos = LOWORD (GetMessagePos());
			yPos = HIWORD (GetMessagePos());
			
			lpfnDlgFn = MakeProcInstance (AboutDlgProc, hInst);
			DialogBox (hInst, "About", hwnd, lpfnDlgFn);
			FreeProcInstance (lpfnDlgFn);
			return 0;
		
		case WM_COMMAND:

			switch (wParam) {
            //
            // Listbox control
            //
		      case IDD_NOPOPLIST:
		      	if (HIWORD (lParam) == LBN_SELCHANGE) {
						EnableWindow (GetDlgItem (hwnd, IDD_REMOVE), TRUE);
						SetButtons (hwnd, hsHook.bEnabled);
		      	}   
		      	break;
		      //
		      // Button controls
		      //	
				case IDD_REMOVE:
		      	if (HIWORD (lParam) == BN_CLICKED) {
				   	i = (int) SendDlgItemMessage (hwnd, IDD_NOPOPLIST, 
				   	                              LB_GETCURSEL, 0, 0L);
						if (i != LB_ERR) {
				   		SendDlgItemMessage (hwnd, IDD_NOPOPLIST, LB_GETTEXT, 
				   		                    i, (LPARAM) (LPSTR) szStr);
					   	SendDlgItemMessage (hwnd, IDD_NOPOPLIST, 
					   	                    LB_DELETESTRING, i, 0L);
							RemoveNoPop ((LPSTR) szStr);
						}
					}	
					break;

				case IDD_ABOUT:
		      	if (HIWORD (lParam) == BN_CLICKED) {
						GetWindowRect (hwnd, &rect);
						xPos = rect.left + (rect.right - rect.left)/2;
						yPos = rect.top + (rect.bottom - rect.top)/2;

						lpfnDlgFn = MakeProcInstance (AboutDlgProc, hInst);
						DialogBox (hInst, "About", hwnd, lpfnDlgFn);
						FreeProcInstance (lpfnDlgFn);
					}	
					break;

				case IDD_ENABLE:
		      	if (HIWORD (lParam) == BN_CLICKED) {
						GetStatus (&hsHook);
						if (hsHook.bEnabled) 
						   hsHook.bEnabled = FALSE;
						else
						   hsHook.bEnabled = TRUE;
						SetButtons (hwnd, hsHook.bEnabled);
						SetStatus (&hsHook);
					}	
					break;

				case IDD_EXIT:				
		      	if (HIWORD (lParam) == BN_CLICKED) 
		   		   SendMessage (hwnd, WM_CLOSE, 0, 0);
					break;
			}
			break;

		case WM_DESTROY:
			GetStatus (&hsHook);
			itoa (hsHook.sNoPopCnt, szStr, 10);
			WritePrivateProfileString (szAppName, "Count", szStr, szProfileName);
			
			for (i = 0; i < hsHook.sNoPopCnt; i++) {
			   GetNoPop (i, (LPSTR) szStr);
				itoa (i, szTemp, 10);
				WritePrivateProfileString ("NoPopProgs", szTemp, szStr, szProfileName);
			}
			if (GetPrivateProfileInt (szAppName, "Enabled", 1, szProfileName))
			if (hsStatus.bEnabled)
				WritePrivateProfileString (szAppName, "Enabled", "1", szProfileName);
			else
				WritePrivateProfileString (szAppName, "Enabled", "0", szProfileName);

			PostQuitMessage (0);
			return 0;
	}
	return DefWindowProc (hwnd, message, wParam, lParam);
}

