UNIT NewObjByType;
{.$define ObjectProfessional}

{$ifNdef WINDOWS}
  {$ifNdef VER60}
    {$ifNdef VER55}
      !CRASH! This unit requires Turbo Pascal
       Version 5.5 or 6.0 or Windows
    {$endif}
  {$endif}
{$else}
  {$ifNdef VER10}
    !! This unit requires Turbo Pascal Windows Version 1.0
  {$endif}
{$endif}

{$ifdef VER60}
  {$define SYMBOLIC_ASM}
{$endif}
{$ifdef WINDOWS}
  {$define SYMBOLIC_ASM}
{$endif}

(**) INTERFACE (**)

USES
{$ifdef WINDOWS}
  WObjects;       { Needed to get definition of object type TObject }
{$endif}
{$ifdef VER55}
  OPRoot;         { Needed to get definition of object type Root }
  {$define ROOT}
{$endif}
{$ifdef VER60}
  {$ifdef ObjectProfessional}
  OPRoot;         { Needed to get definition of object type Root }
    {$define ROOT}
  {$else}
  Objects;        { Needed to get definition of object type TObject }
  {$endif}
{$endif}

FUNCTION NewByType(VMT      : Pointer;    { Returned by TypeOf   }
                   ConsAddr : Pointer;    { @MyConstructor       }
                   var Data)              { Data for constructor }
{$ifdef ROOT}
                   : RootPtr;  { Returns new obj. pointer  }
{$else}
                   : PObject;  { Returns new obj. pointer  }
{$endif}

(**) IMPLEMENTATION (**)

  FUNCTION pNewByType(VMTOfs   : Word;   { Only the VMT's DS offset}
                      ConsAddr : Pointer;{ Pass through parameter  }
                      var Data)          { Pass through parameter  }
  {$ifdef ROOT}
                     : RootPtr;  { Returns new obj. pointer  }
  {$else}
                     : PObject;  { Returns new obj. pointer  }
  {$endif}
  BEGIN
  {$ifdef SYMBOLIC_ASM}
    ASM
      Push word [Data+2]          { Push address of untyped        }
      Push word [Data]            { var parameter Data             }
      Push VMTOfs                 { Push value of VMT offset in DS }
      Xor  AX,AX                  { Get ready for a nil 'Self'     }
      Push AX                     { parameter so constructor will  }
      Push AX                     { allocate a new instance        }
      Call [ConsAddr]             { call the constructor           }
      Mov  word [BP-4],AX         { transfer the function return   }
      Mov  word [BP-2],DX         { to place Turbo expects it.     }
    END;
  {$else}
    Inline(
      $FF/$76/<Data+2/            { Push word [Data+2]             }
      $FF/$76/<Data/              { Push word [Data]               }
      $FF/$76/<VMTOfs/            { Push VmtOfs                    }
      $31/$C0/                    { Xor  AX,AX                     }
      $50/                        { Push AX                        }
      $50/                        { Push AX                        }
      $FF/$5E/<ConsAddr/          { Call [ConsAddr]                }
      $89/$46/$FC/                { Mov  word [BP-4],AX            }
      $89/$56/$FE);               { Mov  word [BP-2],DX            }
  {$endif}
  END; { pNewByType }

  FUNCTION NewByType(VMT      : Pointer;    { Returned by TypeOf   }
                     ConsAddr : Pointer;    { @MyConstructor       }
                     var Data)              { Data for constructor }
  {$ifdef ROOT}
                     : RootPtr;  { Returns new obj. pointer  }
  {$else}
                     : PObject;  { Returns new obj. pointer  }
  {$endif}
  TYPE
    PointerRecord = RECORD
      Offset,
      Segment : Word;
    END; { PointerRecord}
  BEGIN
    NewByType := pNewByType(PointerRecord(VMT).Offset,
                            ConsAddr,
                            Data);
  END; { NewByType }

END. { NewObjByType }
