DEFINT A-Z
DECLARE SUB Menu (Row, Column, Option$(), HotKey$, Escape, Selection)

CONST TRUE = -1
CONST FG = 7, BG = 1, HiLightFG = 1, HiLightBG = 3, HotLetter = 12

DIM Main$(1 TO 10)
FOR X = 1 TO 10
  READ Main$(X)
NEXT

DATA Bill Machrone, John C. Dvorak, Jim Seymour, -, Utilities
DATA Environments, Power programming, Languages, -, Quit

Selection = 3                   'highlight choice 3 initially
CLS
CALL Menu(6, 30, Main$(), "BJI-++++-Q", LastKey, Selection)
COLOR 7, 0

LOCATE 20, 1: PRINT "Your selection was:"; Selection
PRINT "The last key pressed was ASCII"; LastKey
IF LastKey = 27 THEN PRINT "You pressed the Escape key"

SUB Menu (Row, Column, Option$(), HotKey$, Last, Selection) STATIC

  Letter = 0
  IF LEN(HotKey$) THEN Hot = TRUE
  HotKey$ = UCASE$(HotKey$)

  LMax = 0                              'Max length of options
  NumOpts = UBOUND(Option$)             'Number of options
  IF Selection = 0 OR Selection > NumOpts THEN Selection = 1
   
  FOR A = 1 TO NumOpts                  'Determine longest item
    B = LEN(Option$(A))
    IF B > LMax THEN LMax = B
  NEXT
  LMax = LMax + 2                       'Add two for surrounding spaces

  FOR A = 1 TO NumOpts                  'Display the choices
    COLOR FG, BG
    F = Row + A - 1
    LOCATE F, Column
    IF Option$(A) = "-" THEN
      PRINT STRING$(LMax, 196)
    ELSE
      PRINT " "; Option$(A); TAB(Column + LMax);
      IF Hot THEN
        A$ = MID$(HotKey$, A, 1)
        B = INSTR(UCASE$(Option$(A)), A$)
        IF B THEN
          COLOR HotLetter, BG
          LOCATE F, Column + B
          PRINT MID$(Option$(A), B, 1)
        END IF
      END IF
    END IF
  NEXT

  DO
    COLOR HiLightFG, HiLightBG          'Display the current item
    LOCATE Row + Selection - 1, Column
    PRINT " "; Option$(Selection); TAB(Column + LMax);
    IF Hot THEN
      A$ = MID$(HotKey$, Selection, 1)
      B = INSTR(UCASE$(Option$(Selection)), A$)
      IF B THEN
        COLOR HotLetter, HiLightBG
        LOCATE Row + Selection - 1, Column + B
        PRINT MID$(Option$(Selection), B, 1)
      END IF
      IF Letter THEN EXIT DO
      DO
        DO
          T$ = INKEY$
        LOOP UNTIL LEN(T$)
        IF ASC(T$) = 0 THEN             'Extended key
          T = -ASC(RIGHT$(T$, 1))
        ELSE                            'Regular key
          T = ASC(T$)
        END IF
        Last = T
        IF T = 13 OR T = 27 THEN EXIT SUB
     
        S = (T = 13) OR (T = 27)                'Enter or Escape
        S = S OR (T = -72) OR (T = -80)         'Up or Down
        S = S OR (T = -71) OR (T = -79)         'Home or End
        IF T > 0 AND T <> 45 AND T <> 43 THEN   'Discard plus and minus
          Letter = INSTR(HotKey$, UCASE$(T$))
        END IF
        IF Hot THEN
           IF MID$(HotKey$, Selection, 1) = "+" AND T = 13 THEN S = 0
        END IF
      LOOP UNTIL S OR Letter
    END IF

    COLOR FG, BG
    LOCATE Row + Selection - 1, Column
    PRINT " "; Option$(Selection); TAB(Column + LMax);
    IF Hot THEN
      A$ = MID$(HotKey$, Selection, 1)
      B = INSTR(UCASE$(Option$(Selection)), A$)
      IF B THEN
        COLOR HotLetter, BG
        LOCATE Row + Selection - 1, Column + B
        PRINT MID$(Option$(Selection), B, 1)
      END IF
    END IF

    SELECT CASE T
      CASE -71                          'Home
        Selection = 1
      CASE -79                          'End
        Selection = NumOpts
      CASE -72
        Selection = Selection - 1       'Up arrow
        IF Selection = 0 THEN Selection = NumOpts
        IF MID$(Option$(Selection), 2, 1) = "-" THEN
          Selection = Selection - 1
        END IF
      CASE -80                          'Down arrow
        Selection = Selection + 1
        IF Selection > NumOpts THEN Selection = 1
        IF Option$(Selection) = "-" THEN
          Selection = Selection + 1
        END IF
      CASE ELSE
        Selection = Letter
    END SELECT
  LOOP

END SUB

