;**********************************************************************
; CURDR.ASM         Get Current Drive Letter              dBASE .BIN
;
; Author..: Sal Ricciardi
;
; Create with:   TASM curdrive  (Borland Turbo Assembler 2.5)
;                TLINK curdrive
;                EXE2BIN curdrive
;                DEL CURDR.OBJ
;                DEL CURDR.MAP
;                DEL CURDR.EXE
;
; Usage:  (dBASE III Plus, FoxBASE+, dBASE IV)
;
; .cdrive = ' '
; .LOAD CURDR
; .CALL CURDR WITH cdrive          && Don't forget the parameter
; .RELEASE MODULE CURDR
;
;**********************************************************************
              .MODEL SMALL
              .CODE
curdr         PROC  FAR                         ;entry point
              push  ax                          ;save registers
              mov   ax,ds                       ;try to check for
              or    ax,bx                       ;missing parm
              jz    @@1                         ;jmp if ds==0
              mov   ah,19h                      ;get current drive
              int   21h                         ;dos interrupt
              add   al,'A'                      ;convert number to letter
              mov   BYTE PTR ds:[bx],al         ;store in parameter
@@1:          pop   ax                          ;restore register
              ret                               ;return to caller
curdr         ENDP
              END   curdr
