;****************************************************************************
; NUMFILES reports the number of SFT entries created to record the state
; of open files, and thus the setting of FILES= in CONFIG.SYS.  To create
; NUMFILES.COM from NUMFILES.ASM, type
;
;       MASM NUMFILES;
;       LINK NUMFILES;
;       EXE2BIN NUMFILES NUMFILES.COM
;
; NUMFILES 1.0 Copyright (c) 1991 Jeff Prosise
; First published in PC Magazine, November 12, 1991
;****************************************************************************
 
code            segment
                assume  cs:code,ds:code
                org     100h
begin:          jmp     short main
 
msg             db      "FILES=$"
crlf            db      13,10,"$"
 
;****************************************************************************
; Procedure MAIN
;****************************************************************************
 
main            proc    near
                xor     cx,cx                   ;Zero SFT entry count
                mov     ah,52h                  ;Get address of DOS's List
                int     21h                     ;  of Lists
                mov     di,es:[bx+4]            ;Place address of first SFT
                mov     es,es:[bx+6]            ;  header in ES:DI
;
; Walk the chain of SFT headers counting the number of entries in each block.
;
mloop:          add     cx,es:[di+4]            ;Add number of SFT entries
                                                ;  in this block
                mov     bx,es:[di]              ;Place address of next SFT
                mov     es,es:[di+2]            ;  header in ES:DI and loop
                mov     di,bx                   ;  if the offset address
                cmp     di,0FFFFh               ;  isn't equal to FFFFh
                jne     mloop
;
; Display SFT count and exit.
;
                mov     ah,09h                  ;Output "FILES="
                mov     dx,offset msg
                int     21h
                mov     ax,cx                   ;Transfer count to AX
                call    bin2asc                 ;Print it
                mov     ah,09h                  ;Output a carriage return/
                mov     dx,offset crlf          ;  line feed pair
                int     21h
                mov     ax,4C00h                ;Exit with ERRORLEVEL=0
                int     21h
main            endp
 
;****************************************************************************
; BIN2ASC converts a binary value in AX to ASCII form and displays it.
;****************************************************************************
 
bin2asc         proc    near
                mov     bx,10                   ;Initialize divisor word and
                xor     cx,cx                   ;  digit counter
b2a1:           inc     cx                      ;Increment digit count
                xor     dx,dx                   ;Divide by 10
                div     bx
                push    dx                      ;Save remainder on stack
                or      ax,ax                   ;Loop until quotient is zero
                jnz     b2a1
b2a2:           pop     dx                      ;Retrieve a digit from stack
                add     dl,30h                  ;Convert it to ASCII
                mov     ah,2                    ;Display it
                int     21h
                loop    b2a2                    ;Loop until done
                ret
bin2asc         endp
 
code            ends
                end     begin
