/* 
DPMIINFO.C -- display DPMI information under Windows

Copyright (c) 1991 Ziff Communications Co.
    PC Magazine * Andrew Schulman
        
Borland C++ 2.0:
    bcc -W -2 dpmiinfo.c printf.c dpmi.c
    rc dpmiinfo.exe
        
Microsoft C 6.0:
    cl -c -AS -G2sw -Oais -Zpe dpmiinfo.c printf.c dpmi.c
    link /align:16 dpmiinfo printf dpmi,dpmiinfo,,/nod slibcew libw,wi|n.def
    rc dpmiinfo.exe
*/

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <dos.h>
#include <windows.h>
#include "printf.h"
#include "dpmi.h"

#define FAIL(s) MessageBox(NULL, s, "DPMI Information", MB_OK)

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpszCmdLine, int nCmdShow)
{
    unsigned long win_flags;
    unsigned flags;
    unsigned maj, min;
    unsigned proc;
    
    if (! ((win_flags = GetWinFlags()) & WF_PMODE))
        return FAIL("This program requires Windows "
                    "Standard or Enhanced mode");
    
    if (! dpmi_present())
        return FAIL("DPMI not present");

    dpmi_version(&maj, &min, &flags, &proc);
    
    open_display("DPMI Information");
    
    if (win_flags & WF_STANDARD)
        printf("DPMI %x.%x\n", maj, min); // silly bug in Standard mode
    else
        printf("DPMI %d.%d\n", maj, min);

    printf("Windows %s mode running on an 80%d86\n",
        (win_flags & WF_ENHANCED) ? "Enhanced" : 
        (win_flags & WF_STANDARD) ? "Standard" : "Not Another?!",
        proc); // processor: 2=286, 3=386, 4=486
            
    printf("%d-based DPMI implementation\n",
        (flags & 1) ? 386 : 286);
    printf("Interrupts reflected to %s mode\n",
        (flags & 2) ? "real" : "V86");
    printf("%s virtual memory\n",
        (flags & 4) ? "Supports" : "No");
    
    show_display();
    return 0;
}
