
**************************************************************
*   Program:  POPREPT.PRG
*    System:  Example, Dynamic Definition of Report Groupings
*
*
*  Function:  Reptgroup()
* Rept Form:  Salesrpt.FRX
*      Data:  SALES.DBF (struct & index keys below)
**************************************************************

* Structure for database: H:\SALES.DBF
* Number of data records:      11
* Date of last update   : 12/10/90
* Field  Field Name  Type       Width    Dec
*     1  ORDER_NO    Character      8
*     2  DIVISION    Character     10
*     3  REGION      Character      2
*     4  ORDER_DATE  Date           8
*     5  QUANTITY    Numeric       10
*     6  PRODUCT     Character     10
* ** Total **                      49

CLEAR ALL
CLOSE ALL
SET SAFETY OFF
SET TALK OFF

* Open the database and associated index files, ordinarily:
* USE sales INDEX svolume, sregion, sdivisn, sproduct

* In this example we'll create the index files now:

USE sales
INDEX ON STR(quantity,10,0)+DTOS(order_date) TO svolume
INDEX ON region+DTOS(order_date) TO sregion
INDEX ON division TO sdivisn
INDEX ON product+order_no+STR(quantity,10,0) TO sproduct

SET INDEX TO svolume, sregion, sdivisn, sproduct

* Define the popup:

DEFINE POPUP reports FROM 1,20 SHADOW
DEFINE BAR 1 OF reports PROMPT " Sales By \<Volume "
DEFINE BAR 2 OF reports PROMPT " Sales By \<Region "
DEFINE BAR 3 OF reports PROMPT " Sales By \<Division "
DEFINE BAR 4 OF reports PROMPT " Sales By \<Product "

*  Note that the BARs are defined in the
*  SAME ORDER as the index files were opened!

* Complete your POPUP definition with this command:

 ON SELECTION POPUP Reports DEACTIVATE POPUP

*  Now, here's the routine that calls the REPORT FORM:

DO WHILE .T.

   *  First, get the user's selection:
   ACTIVATE POPUP REPORTS

   IF BAR() = 0 .OR. LASTKEY() = 27
      * we didn't get a selection; ESC or right or
      * left arrow was pressed
      EXIT
   ENDIF

   SET ORDER TO BAR()
   * now we've got our grouping order

   * create a title
   mtitle = "This report shows "+ALLTRIM(PROMPT())+"."

   * construct the group expression
   mgroup = LEFT(KEY(BAR()), AT("+",KEY(BAR()),1)-1)

   IF LEN(mgroup) = 0
       * if there wasn't an appropriate "+" in the
       * index expression
       mgroup = KEY(BAR())
   ENDIF

   REPORT FORM salesrpt && with whatever clauses you need

ENDDO
RELEASE POPUPS
RELEASE ALL
CLOSE ALL
RETURN

**************************************************************

FUNCTION Reptgroup
PARAMETERS getgroup
RETURN &getgroup


