        name    ltoa
        title   LTOA - long integer to ASCII
        page    55,132

;
; LTOA.ASM --- Convert long integer to ASCII
;
; Copyright (c) 1987 Ziff Communications Co.
; Ray Duncan
;
; Call with:    DX:AX = 32-bit integer
;               DS:SI = buffer to receive string,
;                       must be at least 11 bytes long
;               CX    = radix
;
; Returns:      DS:SI = address of converted string
;               AX    = length of string
; 
; Since test for value = zero is made after a digit
; has been stored, the resulting string will always
; contain at least one significant digit.

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT

        public  ltoa            ; make LTOA available to Linker

ltoa    proc    near            ; convert long int to ASCII.

        add     si,11           ; advance to end of buffer
        push    si              ; and save that address.
        or      dx,dx           ; test sign of 32 bit value,
        pushf                   ; and save sign on stack.
        jns     ltoa1           ; jump if value was positive.
        not     dx              ; it was negative, take 2's 
        not     ax              ; complement of the value. 
        add     ax,1
        adc     dx,0

ltoa1:                          ; divide value by radix to extract
                                ; next digit for forming string.
        call    divide          ; no, divide by radix.
        add     bl,'0'          ; convert remainder to ASCII digit
        cmp     bl,'9'          ; in case converting to hex ASCII,
        jle     ltoa2           ; jump if in range 0-9,
        add     bl,'A'-'9'-1    ; correct digit if in range A-F.

ltoa2:  dec     si              ; back up through buffer
        mov     [si],bl         ; store this character into string.
        mov     bx,ax           ; is value = zero yet?
        or      bx,dx
        jnz     ltoa1           ; no, convert another digit.

        popf                    ; was original value negative?
        jns     ltoa3           ; no, jump

        dec     si              ; yes,store sign into output string.
        mov     byte ptr [si],'-'

ltoa3:  pop     ax              ; calculate length of string
        sub     ax,si
        ret                     ; back to caller.

ltoa    endp


; General purpose 32 bit by 16 bit unsigned divide.
; This routine must be used instead of the machine's 
; usual unsigned divide for cases where the quotient 
; may overflow 16 bits (for example, 100,000 / 2 ).  
; If called with a zero divisor, this routine returns the 
; dividend unchanged and gives no warning.
;
; Call with:    DX:AX = 32 bit dividend
;               CX    = divisor
;
; Returns:      DX:AX = quotient
;               BX    = remainder
;               CX    = divisor (unchanged)
;

divide  proc    near            ; Divide DX:AX by CX

        jcxz    div1            ; exit if divide by zero
        push    ax              ; 0:dividend_hi/divisor
        mov     ax,dx
        xor     dx,dx
        div     cx
        mov     bx,ax           ; BX = quotient1
        pop     ax              ; remainder1:dividend_lo/divisor
        div     cx
        xchg    bx,dx           ; DX:AX = quotient1:quotient2

div1:   ret                     ; BX = remainder2

divide  endp

_TEXT   ends

        end


