/*
 *  nb.c --
 *      Bug free host to network and network to host data conversion.
 *
 *  Author:
 *      Thanks to David Peterson
 */

#include "types.h"
#include "in.h"

int ntohs(x)
	int x;
{
    /* unsigned short word2 ;
    unsigned short word3 ;

    word2 = ((x >> 8) & 0xff);
    word3 = ((x) & 0xff);
    x = (word2) | (word3 << 8); */
    return (x);
}

/*
 *  long dntohl(long var) --
 *      32 bit network to host byte ordering
 */
long dntohl (var)
	long var ;
{
    unsigned short word0 ;
    unsigned short word1 ;
    unsigned short word2 ;
    unsigned short word3 ;

    word0 = ((var >> 16) & 0xffff) ;
    word1 = (var & 0xffff) ;
    word2 = ((word1 >> 8) & 0xff);
    word3 = ((word1) & 0xff);
    word1 = (word2) | (word3 << 8);
    word2 = ((word0 >> 8) & 0xff);
    word3 = ((word0) & 0xff);
    word0 = (word2) | (word3 << 8);

    var = 0 ;
    var |= word1 ;
    var <<= 16 ;
    var |= word0 ; 
    /* printf("dntohl var = %ld\n", var) ;   */
    return (var) ;
}

/*
 *  long dhtonl(long var) --
 *      32 bit host to network byte odering
 */
long dhtonl (var)
	long var ;
{
    unsigned short word0 ;
    unsigned short word1 ;
    unsigned short word2 ;
    unsigned short word3 ;

    word0 = ((var >> 16) & 0xffff) ;
    word1 = (var & 0xffff) ;
    word2 = ((word1 >> 8) & 0xff);
    word3 = ((word1) & 0xff);
    word1 = (word2) | (word3 << 8);
    word2 = ((word0 >> 8) & 0xff);
    word3 = ((word0) & 0xff);
    word0 = (word2) | (word3 << 8);

    var = 0 ;
    var |= word1 ;
    var <<= 16 ;
    var |= word0 ; 
    /* printf("dhtonl var = %ld\n", var) ;   */
    return (var) ;
}
