/****************************************************************************
*   Function:    int sockrn(int fd, char *bufptr, int toread)               *
*   Operation:   to read n bytes from socket fd into bufptr                 *
*   Returns:     the number of bytes read, or -1 for error                  *
*   Parameters:  fd, socket file descriptor                                 *
*                bufptr, address of character array to read into            *
*                toread, the actual number of bytes to read into bufptr     *
****************************************************************************/
#include "socko.h"

#include <stdio.h>

#ifdef UNIX
# include <sys/types.h>
#else
# include <tklib.h>
#endif

#include <sys/socket.h>

#ifdef UNIX
# include <sys/time.h>
# include <errno.h>
extern int errno;
#else
# include <io.h>
# include <sys/nfs_time.h>
# include <tk_errno.h>
#endif

struct timeval wait_time;
fd_set rwfds;

int sockrn(fd, bufptr, toread)
  register int fd;
  register char *bufptr;
  register int toread;
{
  int nread;
  int total = 0;
  while (toread > 0) { 
    nread = recv(fd, bufptr, toread, 0);
    if (nread > 0) {
      bufptr += nread;
      total += nread;
      toread -= nread;
    }
    else if (nread < 0) {
#ifndef SYSV
      if (errno == EWOULDBLOCK) {
#endif

#ifdef SEQ
      if (errno == EWOULDBLOCK) {
#endif

        FD_ZERO(&rwfds);
        FD_SET(fd, &rwfds); 
        wait_time.tv_sec = 25;
        wait_time.tv_usec = 0;
        if ((select(32, &rwfds, (fd_set*) 0, (fd_set *) 0, &wait_time)) < 1)        
          return(-1);
#ifndef SYSV
      } else
        return(-1);
#endif

#ifdef SEQ
      } else
        return(-1);
#endif

    } else
      return(-1);
  }
  *bufptr = 0;
  return (total);
}
