;-----------------------------------------------------------------------
; KEYWORD.RS - Robocomm 4.x script to upload a keyword file to Qmail 4
;.......................................................................
; Author:   Dan Parsons
; Version:  1.0
; Date:     04/27/92
;
; Notes:    This script expects to find a KEYWORD file in the configured
;           REP dir with the name <BBSID>.KEY.  For example, on Group
;           One BBS, the script would look for GROUPONE.KEY in the
;           configured REP file directory.
;
;           Make sure this script is executed BEFORE any Download Mail
;           operations are performed
;
;-----------------------------------------------------------------------
TITLE "Upload Keyword File to Qmail 4 Door"
ENDPARAMS

    IF NOT EXIST "%REPDIR%%ID%.KEY" GOTO NOKEY

    VENUE MAIL
    SEND "K|"
    WAITFOR "%ID%.KEY"
    UPLOAD "%REPDIR%%ID%.KEY" USING "%BBS21%"

    ; If we used an external protocol, we may need to "bump" the BBS to get
    ; back a prompt containing the Qmail door main command prompt.
    SEND "|"

    ; We need to wait for the main command prompt so the next agenda
    ; item's command character ("U" or "D") will not be lost during
    ; keyword processing.
    WAITFOR "%BBS40%"

EXIT 0

:NOKEY
    MESSAGE "No %REPDIR%%ID%.KEY file to upload"
EXIT 0
