/****************************************************************************/
/*   FILE JMODEM_C.C                                                        */
/*   Created 11-JAN-1990                   Richard B. Johnson               */
/*                                         405 Broughton Drive              */
/*                                         Beverly, Massachusetts 01915     */
/*                                         BBS (508) 922-3166               */
/*                                                                          */
/*   File I/O                                                               */
/*   file_io();                                                             */
/*   All of the file I/O is called from this one block to ease portability  */
/*                                                                          */
/****************************************************************************/
#define FILE_IO                          /* For variable length param list  */
#include <stdio.h>                       /* Used for FILE                   */
#include <dos.h>                         /* Used for file-size              */
#include <io.h>                          /* Ysed for Unix / DOS type files  */
#include <fcntl.h>                       /* Used for O_BINARY, etc          */
#include <string.h>                      /* Used for _strchr(), etc         */
#include "jmodem.h"                      /* Used for JMODEM primatives      */
#if !defined (TURBOC)
    #include <sys\types.h>               /* Used to make <sys\stat.h> work  */
#endif
#include <sys\stat.h>                    /* Used for Unix style file I/O    */
#if defined (TURBOC)
    #include <dir.h>                     /* struct for ffblk                */
    #define find_t ffblk
    #define _A_NORMAL 0
#endif

#define FCREATE ( O_CREAT | O_BINARY | O_RDWR)   /* Create new file         */
#define FACCESS ( S_IWRITE | S_IREAD )           /* File access mode        */
#define FOPENRD ( O_RDONLY | O_BINARY)           /* Open for read only      */
#define FAIL -1                                  /* Open close create fail  */
byte old[]=".OLD";                               /* For renaming files      */

/****************************************************************************/
word file_io(word command,                       /* Read/write/open, etc.   */
                register short *handle,          /* File handle             */
                register byte *buffer,           /* Working buffer pointer  */
                word len)                        /* Bytes to read/write     */
{
    struct find_t o_file;                        /* To get file size        */
    byte temp[65];                               /* To rename a file        */
    byte *dot;                                   /* Find the "."            */
    switch (command)                             /* GOTO in disguise        */
    {
/****************************************************************************/
/*      Open the file for read. If the open fails, return non-zero.         */
/****************************************************************************/
        case OPEN_READ:
        {
            syst.s_txt = buffer;
            screen (SCR_FIL,&syst);
            if ( (*handle = open(buffer,FOPENRD) ) != FAIL )
            {
#if defined (TURBOC)
                findfirst(buffer,&o_file,_A_NORMAL);
                syst.s_byt = o_file.ff_fsize;
#else
                _dos_findfirst(buffer,_A_NORMAL, &o_file);
                syst.s_byt = o_file.size;        /* Show file size          */
#endif
                screen (SCR_FOK,&syst);          /* Show success            */
                return JM_NRM;
            }
        screen (SCR_FNF);                        /* Show failure            */
        return JM_FNF;
        }
/****************************************************************************/
/*         Create a new file. If the file already exists, rename it.        */
/****************************************************************************/
       case CREATE:
        {
            syst.s_txt = buffer;                 /* Buffer has filename     */
            screen (SCR_FIL,&syst);              /* Write "opening file"    */
            if ( (*handle = open  (              /* See if it exists        */
                            buffer ,             /* Filename                */
                            FOPENRD )            /* Open for read only      */
                            ) != FAIL )
            {                                    /* If file already exists  */
                close (*handle);                 /* Close the open file     */
                strcpy (temp,buffer);            /* Copy the file name      */
                dot = strchr (temp, '.');        /* Find "." in string      */
                if (dot)                         /* If there was a dot      */
                    strcpy (dot, old);           /* Substitute ".OLD"       */
                else
                    strcat (temp, old);          /* Append "filename.OLD"   */
                syst.s_txt = temp;
                if ( rename(buffer,temp) )       /* Try to rename the file  */
                {
                    screen (SCR_FCR,&syst);      /* Tell user can't rename  */
                    return JM_REN;               /* Quit                    */
                }
                screen (SCR_FRN,&syst);          /* Tell user we renamed    */
            }
            if  ( (*handle = open (              /* Open (create) new file  */
                             buffer ,            /* File name in buffer     */
                             FCREATE ,           /* Create new file         */
                             FACCESS )           /* Define access mode      */
                             ) != FAIL)          /* If successfull          */
            {
                screen (SCR_FOK,(SYS *) 0x0000); /* Show success            */
                return JM_NRM;
            }
            screen (SCR_FCR);                    /* Show failure            */
            return JM_CRE;
        }
/****************************************************************************/
/*        Write 'len' bytes to the file. Return the actual bytes written    */
/****************************************************************************/
        case WRITE:
        {
        return ( write ( *handle, buffer, len) );
        }
/****************************************************************************/
/*        Read 'len' bytes from the file. Return the actual bytes read.     */
/****************************************************************************/
        case READ:
        {
        return ( read ( *handle, buffer, len) );
        }
/****************************************************************************/
/*        Close the file. Return any error-code (ignored).                  */
/****************************************************************************/
        case CLOSE:
        {
        return (close (*handle));
        }
/****************************************************************************/
/*        Delete the file named in 'buffer'. Return any error code.         */
/****************************************************************************/
        case DELETE:
        {
        return (remove (buffer));
        }
    }
    return JM_ABT;                                          /* Bad function */
}
/****************************************************************************/
/************************ E N D  O F  M O D U L E  **************************/
