	SET TTHRU OFF		; Must be 1st line to suppress typethrough
	LEGEND "BBS Maintenance ver 1.0"
;****	TRACE ON		; Debugging
;
; ----- COM-AND BBS file maintenance script
;	Commenced: 11/90 R.McG
; -----------------------------------------------------------------------
;	Purpose:
;	   The script, named BBSETUP.CMD, is executed to setup the BBS
;	script (version 1.1).  Setup 1) identifies the port and modem
;	control values, 2) identifies (and creates) the subdirs to be
;	used.  This script, BBMAINT.CMD is used to update relevant files.
; -----------------------------------------------------------------------
;	NOTE: This script expects to find a file named BBSDAT on 1) the
;	current subdirectory, 2) The COM-AND= environment var specified
;	subdirectory, or 3) the subdirectory where THIS script resides.
;	If this file is found, it will be overwritten subsequently.  If
;	NOT found, BBSDAT will be created on the subdir where COM-AND=
;	points.  S29 is used to keep the file name (subroutine INIT).
; -----------------------------------------------------------------------
;	NOTE: This script expects to find subroutine scripts named:
;	BBMAINT1 through BBMAINT4 on the same subdir as this script!
; -----------------------------------------------------------------------
;	Usage:
;	   N99 -> Text attribute value
;	   N98 -> Mainline cursor position
;	   N97 -> Mainline cursor position
; -----------------------------------------------------------------------
;
;	Establish a DWINDOW, and change the text display to window default.
;	.. Save the previous text display attribute, for restoration later.
;
	DWIND 1,2 22,78 	; Establish scrolling region
	N99 = "_TEXT"           ; Save original text attr
	SET TEXT "_DEFA"        ; Set text attr
;
;	Perform tasks
;
	GOSUB Init		; Setup initial values
	GOSUB Files		; Paint main screen
;
;	Exit the script
;
Escape:
Exit:
	SET TEXT N99		; Reset text attr finally
	DWINDOW CLEAR		; Clear any scrolling region
	CLEAR			; Clear entire text window
	EXIT
; -----------------------------------------------------------------------
; ----- Subroutine: Init ->  Set initial values from BBSDAT
;	.. NOTE: S29 returns the file name to use for writes to BBSDAT
;
Init:
	S20 = "_PARM"(11:14)*","*"_PARM"(0:3) ; Port(4),speed(4)
	S21 = "ATE0Q0V1X1S0=2 S7=30 S9=10^M"  ; Standard MINIT for BBS
	S22 = "\BBS"            ; Set to our subdirectory
	S23 = "\BBS\FILES"      ; Set subdir for files
	S24 = "\BBS\MAIL"       ; Set subdir for mail
	S25 = "\BBS\BULLETIN"   ; Set subdir for bulletins
;
;	Replace above values from BBSDAT, if that script exists
;
	S29 = ""                ; Make value null
	IF ISSC "BBSDAT"        ; If file exists on dft subdir or COM-AND=
	   FCALL "BBSDAT"       ; .. execute it
	ELSE
	   S10 = "_SCRIPT"      ; Get current script fname
	   GOSUB Parse_Fname	; Extract drive:Subdir from name
	   S10 = S10*"\BBSDAT"  ; Make new name
	   IF ISSC S10		; Invoke it if its THERE
	      FCALL S10 	; Invoke it
	      S29 = S10 	; Save for later
	      ENDIF
	   ENDIF
	RETURN			; Done init
; -----------------------------------------------------------------------
;	Subroutine: Parse drive:subdirectory from file name
;
;	S10 passes fully qualified name S10 returns drive:subdirectory
;					S11 returns file name
;	N10,N11 are scratch values
; -----------------------------------------------------------------------
;
Parse_Fname:
	LENGTH S10 N10			; Find length of string
	FOR N11 = (N10-1),0,-1		; Scan backwards through string
	    IF STRCMP S10(N11:N11) ":" or STRCMP S10(N11:N11) "\" GOTO PAFN100
	    ENDFOR
	S11 = S10			; No drive or path
	S10 = ""                        ; Return null drive:path spec
	RETURN
;
;	Extract drive and path from name; N11 points to ":" or "\"
;
PAFN100:
	S11 = S10(N11+1:N10)		; Extract name portion
	IF STRCMP S10(N11:N11) "\" DEC N11
	S10 = S10(0:N11)		; Save ":", remove last "\"
	RETURN
; -----------------------------------------------------------------------
; ----- Error:	Open a window, display a message, and wait for keypress
;	S0 passes the error message
;
Error:
	WOPEN 10,10,12,70 (cont) Err_Esc
	ATSAY 10,12 (cont) " Error "
	ATSAY 11,12 (cont) S0(0:55); Max msg width 55 chars
	ATSAY 12,26 (cont) " Press any key to continue "
	;
	;    Wait a keypress
	;
	KEYGET S0		; Wait for any key
	WCLOSE
Err_Esc:
	RETURN
; -----------------------------------------------------------------------
; ----- Subroutine: Files ->  Update BBS files
;
Files:
	WOPEN 0,0 23,79 (defa) Main_Esc
	ATSAY 0,2 (defa)   " BBS Files "
	ATSAY 23,25 (defa) " Press ESC to cancel BBMAINT "
;
;	Fill in the current window
;
File100:
	CLEAR
	LOCATE 2,2
	MESS " 1) Update BBS User file"
	MESS " 2) Update BBS File directory"
	MESS " 3) Update BBS Mail listing"
	MESS " 4) Update BBS Bulletin listing"

	IF ISSCRIPT "BBSetup" MESS " 5) Setup the BBS (default values)"
	IF ISSCRIPT "BBS"     MESS " 6) Invoke the BBS"

	MESS " "
	MESS " User file       is: "*S22*"\BBS-User"
	MESS " Files directory is: "*S23*"\BBS-File"
	MESS " Mail listing    is: "*S24*"\BBS-Mail"
	MESS " Bulletin list   is: "*S25*"\BBS-Bull"
	MESS " "
	MESS " "
	MESS "Note: Alt-Q to edit a file"
	MESS "      Alt-F for a directory search"
	MESS "      Alt-F10 to shell to DOS"
	MESS " "
	MESS " "
	MESS "Select item (carriage return = previous): "
	CURSOR N98 N97		; Read current cursor
;
;	Wait for a keypress
;
FILE200:
	LOCATE N98 N97		; Position cursor
	KEYGET S0		; Wait for it
	SWITCH S0		; Act according to keyget
	  CASE "1"
	       S0 = "BBMAINT1"  ; Invoke subsidiary - userids
	       GOSUB FCALL	; Try to FCALL it
	       GOTO FILE200
	       ENDCASE
	  CASE "2"
	       S0 = "BBMAINT2"  ; Invoke subsidiary - files
	       GOSUB FCALL	; Try to FCALL it
	       GOTO FILE200
	       ENDCASE
	  CASE "3"
	       S0 = "BBMAINT4"  ; Invoke subsidiary - mail
	       GOSUB FCALL	; Try to FCALL it
	       GOTO FILE200
	       ENDCASE
	  CASE "4"
	       S0 = "BBMAINT3"  ; Invoke subsidiary - bulletin
	       GOSUB FCALL	; Try to FCALL it
	       GOTO FILE200
	       ENDCASE
	  CASE "5"
	       IF ISSCRIPT "BBSetup"
		  S0 =	"BBSetup" ; Setup name
		  GOTO Execute	; Execute the script
		  ENDIF
	       ENDCASE
	  CASE "6"
	       IF ISSCRIPT "BBS"
		  S0 =	"BBS"   ; Setup name
		  GOTO Execute	; Execute the script
		  ENDIF
	       ENDCASE
	  CASE "0d"             ; c/r alone is exit
	       WCLOSE		; Close window...
	       RETURN		; Leave Main routine
	       ENDCASE
	  CASE "_NULL"          ; ESC -> Null
	       WCLOSE		; Close window...
	       RETURN		; Leave Main routine
	       ENDCASE
	  CASE "2100"           ; Alt-F
	       MANUAL "0x2100"  ; Perform Dir cmd
	       ENDCASE
	  CASE "1000"           ; Alt-Q
	       MANUAL "0x1000"  ; Edit a file
	       ENDCASE
	  CASE "7100"           ; Alt-F10
	       SHELL
	       DWINDOW 1,2,22,78; Reset dwindow after shell
	       LEGEND "_LEGEND" ; Redo the legend
	       ENDCASE
	  DEFAULT		; None of the above
	       SOUND 100,100	; Bronx cheer
	       ENDCASE
	  ENDSWITCH
	GOTO File200		; Repaint screen and ask again
;
;	Escape during main
;
Main_Esc:
	S0 = ""                 ; Blank entry
	RETURN			; And execute it
; -----------------------------------------------------------------------
; ----- EXECUTE: Close any open windows, reset defaults, and EXECUTE
;	a script (name passed in S0)
;
Execute:
	IF NOT ISSCRIPT S0 GOTO FILE100 ; Ignore nonexistant script
	WCLOSE			; Close open window
	SET TEXT N99		; Reset text attr finally
	DWINDOW CLEAR		; Clear any scrolling region
	CLEAR			; Clear entire text window
	EXECUTE S0		; Chain to the new script
; -----------------------------------------------------------------------
; ----- FCALL:	Open a script given a file name.  The script may be on
;	the current subdir, the COM-AND=subdir, OR on the same path as
;	this script itself.  S0 passes an UNqualified script name.
;
FCALL:
	IF NOT ISSCRIPT S0	; If basic fname d.n.e as a script
	   S10 = "_SCRIPT"      ; get out OWN script file name fully qual
	   GOSUB Parse_Fname	; Parse out path
	   S0 = S10&"\"*S0      ; Make new script file name
	   ENDIF

	IF ISSCRIPT S0		; If result exists...
	   FCALL S0		; Invoke subsidiary file
	   RETURN		; and return to caller
	   ENDIF
;
;	Issue an error msg
;
	WOPEN 10,10,13,70 (cont) FCALEsc
	ATSAY 10,12 (cont) " BBMAINT "
	ATSAY 11,12 (cont) " The script: "*S0
	ATSAY 12,12 (cont) " cannot be found. "
	ATSAY 13,26 (cont) " Press any key to continue "
	;
	;    Wait a keypress
	;
	KEYGET S0		; Wait for any key
	WCLOSE
FCALEsc:
	RETURN
