; ----- Strip: Massage a COM-AND script
;
;	Lines are left justified, and comments are removed.
;
;	Warning: If a line length exceeds 80 cols,
;	no adjustment is made to the line.
;
;	R.McG; 4/89, Chicago
; ----------------------------------------------------------------
;
; ----- Ask for an input file name
;
   CLEAR			; Clear the screen
   LEGEND " Stripper ver 1.1 "  ; Version #
   WOPEN 10 10 13 70 (blue red) ; Draw a box
   ATSAY 10 12 (blue yellow) " Script stripper "
   ATSAY 11 12 (blue yellow) "Enter the file to be Stripped: "
   ATGET 12 12 (blue white) 58 S0 ; Read file name (58 chars)
   WCLOSE

   FOPENI S0 TEXT		; Try to open file
   IF NOT SUCCESS		; If file not open
      MESSAGE "*** File not found ***^M^J"
      EXIT			; Display error message and exit
      ENDIF
;
; ----- Ask for the output file
;
OutputName:
   WOPEN 10 10 13 70 (blue red) ; Draw a box
   ATSAY 10 12 (blue yellow) " Scripted stripper "
   ATSAY 11 12 (blue yellow) "Enter the output file name: "
   ATGET 12 12 (blue white) 58 S0 ; Read file name (58 chars)
   WCLOSE

   IF ISFILE S0 		; Test for preexisting file
      WOPEN 10 10 13 70 (blue red) ; Draw a box
      ATSAY 10 12 (blue yellow) " Scripted stripper "
      ATSAY 11 12 (blue yellow) "The output file exists!"
      ATSAY 12 12 (blue yellow) "Do you wish to purge the file? "
      LOCATE 12,68
      KEYGET S1
      WCLOSE
      IF not FIND S1 "Y"
	 GOTO OutputName
	 ENDIF
      ENDIF
;
;	Open the given file
;
   FOPENO S0 TEXT		; Try to open file
   IF NOT SUCCESS		; If file not open
      MESSAGE "*** Error opening output file ***^M^J"
      GOTO OutputName		; Display error message and exit
      ENDIF
;
;	Initialize
;
   CLEAR			; Clear the screen (again)
   INIT N0 0			; Reset line counter
   LEGEND " Script stripper processing"
   SET FLAG(0) OFF		; Line longer than 80
   GOTO Loop			; And start
;
; ----- End of file
;
Endfile:
   WRITE "^Z"                   ; Add ASCII file stopper
   FCLOSEO			; Close output file
   MESSAGE "^M^J*** End of file ***^M^J"
   EXIT 			; And we're done
;
; ----- Read a line
;
Loop:
   READ S0 80 N1		; Read a line
   IF EOF GOTO EndFile		; Test for EOF
   IF FLAG(0) GOTO Continue	; Throw away long line continuations
   IF EQ N1 80 GOTO LongLine
   LJ S0			; Left justify
;
;	Blank lines must thrown away
;
   IF NULL S0 or ZERO N1	; Test for a null line
      GOTO Loop 		; .. at top of screen
      ENDIF
;
;	Top of forms and other comment lines are thrown away
;
   IF STRCMP S0(0:0) "^L" or STRCMP S0(0:0) "*" or STRCMP S0(0:0) ";"
      GOTO Loop 		; .. at top of screen
      ENDIF
;
;	Skip scan if there is no comment on the line
;
   IF NOT FIND S0 ";" N1        ; And keep pos of potential comment
      GOTO Finish
      ENDIF
   FIND S0(0:N1) "`"" N2        ; Look for quoted field b4 comment
   IF EQ N2 -1
      S0 = S0(0:N1-1)		; Truncate right here
      GOTO Finish
      ENDIF
   GOTO Test			; Test for ';' inside of quotes
;
;	Delete trailing blanks
;
Finish:
   S0 = S0&""
;
;	Write the line.  Note the special care taken to see that ^M in the input
;	.. isn't made into a <cr>, "!" isn't made into a <cr> and so on.
;
WriteLn:
   LENGTH S0 N1 		; Set new length
   IF GT N1 40
      S1 = S0(0:39)
      S0 = S0(40:N1-1)
      LENGTH S0 N0		; Send the 1st half
      PRESERVE S1
      LENGTH S1 N1
      WRITE S1 N1
      MESSAGE S1		; Display line to screen

      PRESERVE S0
      LENGTH S0 N0
      WRITE S0 N0
      CURSOR N10,N11		; Read current cursor
      ATSAY N10,N11 (text) S0	; Display line to screen
   ELSE
      PRESERVE S0
      LENGTH S0 N0
      WRITE S0 N0
      MESSAGE S0		; Display line
      ENDIF
   IF NOT FLAG(1)		; If not a long line, or end of long line
      WRITE "!"                 ; Add a cr/lf
      ENDIF
   GOTO Loop
;
; ----- Test for a ':' within a quoted field; N2 = position of 2nd """
;	Initialize for testing
;
Test:
   N0 = N2-1			; -1 as we'll INC first
   LENGTH S0 N1
;
;	Scan the line for a comment (allowing for quoted strings)
;
Test100:
   INC N0
   IF STRCMP S0(N0:N0) "`""
      DO
	 INC N0
	 IF STRCMP S0(N0:N0) "``"
	    N0 = N0+2
	    ENDIF
	 UNTIL STRCMP S0(N0:N0) "`"" or GE N0 N1
      INC N0
      ENDIF
   IF (NOT STRCMP S0(N0:N0) ";") and LT N0 N1
      GOTO Test100
      ENDIF
   S0 = S0(0:N0-1)
   GOTO Finish
;
; ----- A line was read 80 chars long.	Flag (0) is set to provide for
;	.. continuations of the line.
;
Continue:
   S1 = "Loop"                  ; Set branch label
   IF FLAG(1) S1 = "FINISH"     ; .. according to flag(1)
   IF LT N1 80			; If short line
      SET FLAG(0) OFF		; .. reset ptrs
      SET FLAG(1) OFF
      ENDIF
   GOTO S1			; Throw away what was read
;
; ----- Line read was 80 chars exactly.  Test for a comment in the line
;	.. anyway.  If found, we'll copy just the instruction and throw
;	.. away the remainder of the comment.
;
LongLine:
   IF NULL S0			; Test for 80 chars of blanks
      GOTO Loop 		; .. at top of screen
      ENDIF
   SET FLAG(0) ON		; Flag long line condition
;
;	Top of forms and other comment lines are thrown away
;	.. If we find a comment here, FLAG(0) set causes the
;	.. remainder of the line to be passed to "CONTINUE"
;
   S1 = S0
   LJ S1			; Left justify what we have anyway
   LENGTH S1 N1 		; Recompute length
   IF STRCMP S1(0:0) "^L" or STRCMP S1(0:0) "*" or STRCMP S1(0:0) ";"
      GOTO Loop 		; .. at top of screen
      ENDIF
;
;	Test for comment on the line
;
   IF NOT FIND S1 ";" N1        ; And keep pos of potential comment
      GOTO LL200		; SKip if no possible comment
      ENDIF
   FIND S1(0:N1) "`"" N2        ; Look for quoted field b4 comment
   IF EQ N2 -1
      S0 = S1(0:N1-1)		; Truncate right here
      GOTO Finish		; .. and throw away remainder
      ENDIF
   N0 = N2-1
;
;	Scan the line for a comment (allowing for quoted strings)
;
LL100:
   LENGTH S1 N1
   INC N0
   IF STRCMP S1(N0:N0) "`""
      DO
	 INC N0
	 IF STRCMP S1(N0:N0) "``"
	    N0 = N0+2
	    ENDIF
	 UNTIL STRCMP S1(N0:N0) "`"" or GE N0 N1
      INC N0
      ENDIF
   IF (NOT STRCMP S1(N0:N0) ";") and LT N0 N1
      GOTO LL100
      ENDIF
   IF GE N0 N1			; If we get to end of line without being
      GOTO LL200		; .. sure, write the whole line
      ENDIF
   S0 = S1(0:N0-1)		; We can remove the comment
   GOTO Finish			; ...
;
;	Line contains nothing like a comment
;
LL200:
   SOUND 440,200
   MESS "^M^J***** Warning - Line greater than 80 *****^M^J"
   SET FLAG(1) ON		; Indicate a keeper
   GOTO WriteLn 		; Don't delete trailing blanks - may be important
