	LEGEND "MkLogon ver 1.1"        ; 20 chars long
;
; ----- MkLogon: Create logon scripts for COM-AND
;
;	R.McG; 7/89, Chicago
;	      10/92, updated for BIX, MCI etc
; ----------------------------------------------------------------
; Usages:
;	  S19 -----> Legend line
;	  S18 -----> File name preamble for destination file
;	  S17 -----> Carries the system ID
;	  S16 -----> Carries the system password
;	  S15 -----> System name
; -----------------------------------------------------------------------
;
;	Initialization
;
	S19 = "_LEGEND"                 ; Set initial legend
	GOTO START			; And continue
;
;	Escape - Clear all windows, and exit
;
Escape:
	WCLOSE ALL		     ; Close all open windows
	EXIT			     ; End script
;
;	Draw the menu
;
Start:
	WOPEN 0,10, 9,70 (default) Escape
	ATSAY 0,12  (Default) " MkLogon "
	ATSAY 1,12  (Default) "1) Create new BIX logon"
	ATSAY 2,12  (Default) "2) Create new CIS logon"
	ATSAY 3,12  (Default) "3) Create new Delphi logon"
	ATSAY 4,12  (Default) "4) Create new GEnie logon"
	ATSAY 5,12  (Default) "5) Create new MCI logon"
	ATSAY 6,12  (Default) "6) Create new UNISON logon"

	ATSAY 9,28  (Default) " Press ESC to terminate "
;
;	Wait for a keypress
;
Main:
	KEYGET S1			; Read a single key
	SWITCH S1
	   CASE "1"                     ; BIX
	      S18 = "BIX"
	      S15 = "BIX"
	      ENDCASE
	   CASE "2"                     ; CIS
	      S18 = "CIS"
	      S15 = "CompuServe"
	      ENDCASE
	   CASE "3"                     ; Delphi
	      S18 = "DEL"
	      S15 = "Delphi"
	      ENDCASE
	   CASE "4"                     ; GEnie
	      S18 = "GEN"
	      S15 = "GEnie"
	      ENDCASE
	   CASE "5"                     ; MCI
	      S18 = "MCI"
	      S15 = "MCI"
	      ENDCASE
	   CASE "6"                     ; UNISON
	      S18 = "UNI"
	      S15 = "Unison"
	      ENDCASE

	   DEFAULT
	      SOUND 100,100		 ; Signal displeasure
	      GOTO Main 		 ; Try again
	      ENDCASE
	ENDSWITCH
;
;	Prompt for an ID
;
	GOSUB Get_ID			; Request an ID
	IF FAILED GOTO Main		; Test return status
	S17 = S0			; Save ID

	GOSUB Get_Psw			; Request a Psw
	IF FAILED GOTO Main		; Test return status
	S16 = S0			; Save PSW
;
;	Review the ID and password
;
	PRESERVE S17			; Preserve for display/write
	PRESERVE S16			; Preserve for display/write
	GOSUB Review			; Review ID and psw
	IF FAILED GOTO Main		; Test return status
;
;	Create an unencrypted logon file
;
	S10 = S18&"LOGON.CMD"
	FOPENO S10 TEXT 		; Purge file if it exists
	IF FAILED
	   S19 = "Error opening "*S10
	   GOTO Error			; Exit if error
	   ENDIF
	IF STRCMP S18 "GEN"             ; Special case for GEnie
	   S0 = "TRANSMIT `""*S17&","*S16*"!!`"!"
	   LENGTH S0 N0
	   WRITE S0 N0			; Write a single line
	ELSE				; Everyone else
	   S0 = "TRANSMIT `""*S17*"!!`"!"
	   WRITE S0			; Write a single line
	   S0 = "WAITFOR `"password`"!"
	   WRITE S0			; Write a single line
	   S0 = "TRANSMIT `""*S16*"!!`"!"
	   WRITE S0			; Write a single line
	   ENDIF
	S0 = "IF FCALLED!"
	WRITE S0			; Write a single line
	S0 = "   FRET!"
	WRITE S0			; Write a single line
	S0 = "   ENDIF!"
	WRITE S0			; Write a single line
	FCLOSEO 			; CLose the output file
;
;	Finally, ask if the file is to be encrypted
;
	GOSUB Get_Encrypt		; Ask for encryption
	IF FAILED GOTO Main		; Failure here
;
;	Encrypt the file
;
	S11 = S18&"LOGON.ENF"
	ENCRYPT S10,S11,S0 SIMPLE	; Input, output, password, method
	IF FAILED
	   S19 = "Encryption failed on "*S11
	   GOTO Error			; Exit if error
	   ENDIF
	DELETE S10			; Delete unencrypted file
	GOTO Main			; And continue
;
; ----- Subroutine: Open a window and ask for an ID
;	SUCCESS/Failed returned to indicate ESCape
;	S0 returns the ID
;
Get_ID:
	WOPEN 10 10 13 70 (Default) TOP_ESC
	ATSAY 10 ,12 (default)	" MkLogon ID "
	ATSAY 11 ,11 (default)	" Please specify the ID for "*S15
	ATSAY 13  30 (default) " Press ESC to exit "
	ATGET 12, 12 (default) 54 S0
	WCLOSE
	;
	;	If null response, return failed
	;
End_Get:
	SET SUCCESS ON			; Default return
	LJ S0				; Left justify
	IF NULL S0 SET SUCCESS OFF
	RETURN
	;
	;	ESC hit during topic entry
	;
TOP_ESC:
	S0 = ""                         ; Make a null return
	RETURN
;
; ----- Subroutine: Open a window and ask for a password
;	SUCCESS/Failed returned to indicate ESCape
;	S0 returns the password
;
Get_Psw:
	WOPEN 10 10 13 70 (Default) TOP_ESC
	ATSAY 10 ,12 (default)	" MkLogon Password "
	ATSAY 11 ,11 (default)	" Please specify the password for "*S15
	ATSAY 13  30 (default) " Press ESC to exit "
	ATGET 12, 12 (default) 54 S0
	WCLOSE
	;
	;	If null response, return failed
	;
	GOTO End_Get			; Exit, setting SUCCESS/FAILURE
;
; ----- Subroutine: Review ID and password
;	SUCCESS/Failed returned to indicate ESCape
;
Review:
	WOPEN 10 10  16 70 (Default) TOP_ESC
	ATSAY 10 ,12 (default)	" MkLogon Review "
	ATSAY 11 ,12 (default)	" System:   "*S15
	ATSAY 12 ,12 (default)	" ID:       "*S17
	ATSAY 13 ,12 (default)	" Password: "*S16
	ATSAY 15 ,12 (default)	" Is this correct? (y/n): "
	ATSAY 16  30 (default) " Press ESC to cancel "
	ATGET 15, 37 (default) 1  S0
	WCLOSE
	;
	;	Interpret the response
	;
	IF NULL S0 or FIND S0 "Y"
	   SET SUCCESS ON
	ELSE
	   IF FIND S0 "N"
	      SET SUCCESS OFF
	   ELSE
	      SOUND 100,100
	      GOTO Review
	      ENDIF
	   ENDIF
	RETURN
;
; ----- Subroutine: Ask for encryption
;	SUCCESS/Failed returned to indicate encryption y/n
;	IF SUCCESS, S0 returns the password
;
Get_Encrypt:
	WOPEN 10 10  16 70 (Default) TOP_ESC
	ATSAY 10 ,12 (default)	" MkLogon Encrypt "
	ATSAY 11 ,12 (default)	"If you wish to have the logon file encrypted, enter the"
	ATSAY 12 ,12 (default)	"password here.  If you encrypt the file, you must have"
	ATSAY 13 ,12 (default)	"the password everytime you wish to logon."
	ATSAY 15 ,12 (default)	"Encryption password: "
	ATSAY 16  37 (default) " Press ESC to skip "
	ATGET 15, 32 (default) 32 S0
	WCLOSE
	;
	;	Interpret the response
	;
	IF NULL S0
	   SET SUCCESS OFF
	ELSE
	   SET SUCCESS ON
	   ENDIF
	RETURN
;
; ----- Fatal error.  Open a window, display a message, and exit
;	.. Note that this procedure terminates the script
;
;	S19 passes the error message
;
Error:
	WOPEN 10,10,12,70 (contrast) Err_Esc
	ATSAY 10,12 (contrast) " Error "
	ATSAY 11,12 (contrast) S19(0:55); Max msg width 55 chars
	ATSAY 12,26 (contrast) " Press any key to continue "
	;
	;    Wait a keypress
	;
	KEYGET S0			; Wait for any key
Err_Esc:
	WCLOSE
	EXIT
