program JorDemo;

{ --------------------------------------------------------------------------
                                  JORDEMO.PAS

     ---> A  sample that shows how to use the JORDAN unit to calculate
          the Jordan canonical form of a matrix and its basis.

          (C) 1990, 1992 by Lenimar N. Andrade (CCENDM03@BRUFPB.BITNET)

  -------------------------------------------------------------------------- }

{$E+,N+}

{$M 65520, 0, 655200}

uses
  Equation, Matrices, BasFPTC, LinAlg, Jordan, Crt;

var
  mat, basis, JordanForm: matrix;
  p: polynomial;
  w: eigenvalues;
  HappenedError, FoundBasis: boolean;
  min: minimal;
  diagonal: DiagBlocks;
  i, j, xpos, ypos: byte;

begin
  Writeln;
  Writeln('CALCUTATING JORDAN CANONICAL FORM OF A MATRIX');
  Writeln;
  Write('Which is matrix''s order? ');
  Readln(mat.m);
  mat.n := mat.m;

  Writeln;
  Writeln('Enter the elements of matrix M:');
  Writeln;
  for i := 1 to mat.m do
  begin
    Write('Row ', i, ' : ');
    for j := 1 to mat.n do
      Read(mat.a[i, j])
  end;

  Writeln;
  xpos := WhereX; ypos := WhereY;
  Write('Calculating the characteristic polynomial...');
  CharPoly(mat, p);
  GoToXY(xpos, ypos); ClrEol;
  Write('Calculating the eigenvalues...');
  CalcEigenvalues(p, w);
  GoToXY(xpos, ypos); ClrEol;
  Write('Calculating the minimal polynomial...');
  MinPoly(mat, w, min);
  GoToXY(xpos, ypos); ClrEol;
  Write('Calculating Jordan form...');
  CalculatesJordanForm(mat, w, min, HappenedError, diagonal);
  GoToXY(xpos, ypos); ClrEol;
  Write('Formating Jordan matrix...');
  FormatsJordanMatrix(diagonal, JordanForm, mat.m, w, min);
  GoToXY(xpos, ypos); ClrEol;
  Write('Calculating the Jordan basis...');
  FoundBasis := false;
  if (w.QuantComplex = 0) then
    CalculatesJordanBasis(mat, diagonal, min, basis, FoundBasis);

  if HappenedError then
  begin
    GoToXY(xpos, ypos); ClrEol;
    Writeln('*** ERROR: It wasn''t possible find M''s Jordan form ***');
    Halt;
  end;
  GoToXY(xpos, ypos); ClrEol;
  Writeln('Jordan canonical form of M:');
  Writeln;
  for i := 1 to mat.m do
  begin
    for j := 1 to mat.n do
      Write(JordanForm.a[i, j] :8:2);
    Writeln;
  end;

  if not FoundBasis then
  begin
    Writeln;
    Writeln('*** I can''t find the Jordan basis in this case ***');
    Halt;
  end;
  Writeln;
  Writeln('Basis related to Jordan form of M:');
  Writeln;
  for i := 1 to mat.m do
  begin
    Write('(');
    for j := 1 to mat.n do
    begin
      Write(basis.a[i, j] :8:2);
      if (j < mat.n) then Write(', ');
    end;
    Writeln(' )');
  end;

end.
