
{ --------------------------------------------------------------------------
                                  SYSDEMO.PAS

    ---> A sample that shows how to use the MATRICES unit to solve linear
         systems.

         (C) 1990, 1992 by Lenimar N. Andrade (CCENDM03@BRUFPB.BITNET)

  -------------------------------------------------------------------------- }

program SysDemo;

{$E+,N+}

{$M 65520, 0, 655200}

uses
  Matrices, BasFPTC;

var
  mat: matrix;
  solution: answer;
  i, j, variables: byte;

begin
  Writeln;
  Writeln('RESOLUTION OF LINEAR SYSTEMS');
  Writeln;
  Write('How many equations does the system have? ');
  Readln(mat.m);
  Write('How many variables does the system have? ');
  Readln(variables);
  mat.n := variables + 1;

  Writeln;
  Writeln('Enter the elements of complete system''s matrix:');
  Writeln;
  for i := 1 to mat.m do
  begin
    Write('Row ', i, ' : ');
    for j := 1 to mat.n do
      Read(mat.a[i, j])
  end;

  SolveSystem(mat, solution);

  Writeln;

  { Case 1: system without solution }
  if solution.impossible then
  begin
    Writeln('Impossible system.');
    Halt
  end;

  { Case 2: system with more equations than variables }
  if solution.ManyEq then
  begin
    Writeln('Warning: some equations were not considered.');
    Writeln;
  end;

  { Case 3: determined system }
  if solution.DetSyst then
  begin
    Writeln('Unique solution:');
    Writeln;
    Write('     (');
    for i := 1 to mat.n - 1 do
      Write(solution.ParticularSolution[i]:8:2);
    Writeln(' )');
    Halt;
  end;

  { Case 4: undetermined system }
  Writeln('Particular solution:');
  Writeln;
  Write('     (');
  for i := 1 to mat.n -1 do
    Write(solution.ParticularSolution[i]:8:2);
  Writeln(' )');
  Writeln;
  Writeln('Any other solution will be a sum of the particular solution and');
  Writeln('a linear combination of the vectors bellow:');
  Writeln;
  for i := 1 to solution.x.m do
  begin
    Write('     ( ');
    for j := 1 to solution.x.n do
      Write(solution.x.a[i, j]:8:2);
    Writeln(' )');
  end;

end.
