;Toad Hall's NETTIME v1.1			27 August 1991
;
;Usage:  NETTIME d:
;  where "d:" is a network drive on a remote file server.
;
;NETTIME then sets your local system to the server's system time.
;

CSEG	SEGMENT	PUBLIC PARA 'CSEG'
	ASSUME	CS:CSEG,DS:CSEG,ES:CSEG

CR	EQU	0DH
LF	EQU	0AH

	org	80H
cmdlen	db	?
	db	?
cmd_word dw	?		;first 2 chars on cmdline

	org	100H

NetTime	PROC	NEAR
	mov	ax,cmd_word		;first 2 chars on cmdline ('F:')
	cmp	ah,':'			;it had better be a drive parm
	jnz	Usage			;dummy
	and	al,0DFH			;uppercase
	cmp	al,'C'			;'C'..'Z' are acceptable
	jb	Usage
	cmp	al,'Z'
	jbe	Parm_Ok			;ok

Usage:	mov	dx,offset usage$	;'Usage: ...'
	mov	al,0FH			;ERRORLEVEL 15, 'Invalid drive spec'
	jmp	Msg_Term		;display, die

Parm_Ok:
	mov	fpath,al		;stuff drive char in path name

	mov	dx,offset fpath		;DS:DX -> path name
	xor	cx,cx			;normal file attrib
	mov	ah,5AH			;create temp file
	int	21H
	jnc	Create_Ok		;fine
	 mov	dx,offset create$	;'Create failed'
	 jmp	Msg_Term		;display, die

Create_Ok:

;We have to close the temp file
;or it won't get posted with a date/time.

	mov	bx,ax			;temp file handle into bx
	mov	ah,3EH			;close that file
	int	21H
	jc	Close_Fail		;failed (shared code)

;DX points to new temp filename.

;We have to open that temp file
;before we can read its date/time.

	mov	ax,3D00H		;Open an existing file
	int	21H			;(that same temp file)
	jnc	Open_Ok			;fine
	 mov	dx,offset open$		;'Open failed'
	 jmp	short Msg_Term		;display, die

Open_Ok:
	mov	bx,ax			;handle into BX
	mov	ax,5700H		;Read file date/time
	int	21H			;date in DX, time in CX

;CX = hour * 2048 + minute * 32 + second /2
;DX = (year - 1980) * 512 + month * 32 + day

	push	dx			;save file date a sec

;First set system time per file time:

	mov	ax,cx			;time
	call	GetTime			;convert into CX and DX
	mov	ah,2DH			;set time
	int	21H

	pop	ax			;file date
	call	GetDate			;convert into CX and DX
	mov	ah,2BH			;set date
	int	21H

	mov	ah,3EH			;close the open file
	int	21H
	jnc	Close_Ok
Close_Fail:
	 mov	dx,offset close$	;'Close failed'
	 jmp	short Msg_Term		;display, die

Close_Ok:
	mov	dx,offset fpath		;temp file path/name
	mov	ah,41H			;delete file
	int	21H
	jnc	Delete_Ok		;fine
	 mov	dx,offset delete$	;'Delete failed
	 jmp	short Msg_Term		;display, die

Delete_Ok:
	mov	dx,offset done$	;'Complete'
	
;Arrive here with msg offset in DX,
;ERRORLEVEL in AL.
Msg_Term:
	push	ax		;save ERRORLEVEL in AL

	cmp	dx,offset create$	;not a real error?
	jb	Msg_Term1		;yep (usage or complete)

	push	dx			;save specific error msg
	mov	dx,offset temp$		;'Network temp file '
	mov	ah,9			;display msg
	int	21H
	pop	dx			;specific error msg
	mov	ah,9			;display msg
	int	21H
	mov	dx,offset failed$	;' failed',CR,LF

Msg_Term1:
	mov	ah,9			;display final msg
	int	21H
	pop	ax			;restore ERRORLEVEL

	mov	ah,4CH			;terminate process
	int	21H

NetTime	ENDP

copyright db	'Copyright (c) 1991 David P Kirschbaum',CR,LF
	  db	'All rights reserved',CR,LF,0

usage$	db	"Toad Hall's NETTIME",CR,LF
	db	'Usage:  NETTIME d:',CR,LF
	db	'where "d:" is a network drive on a remote file server',CR,LF
	db	"NETTIME then sets your local system to the server's time.",CR,LF
	db	'Commercial license required for distribution.'
	db	CR,LF,'$'

done$	db	'System time updated.',CR,LF,'$'

temp$	db	'Network temp file $'
create$	db	'create$'
open$	db	'open$'
close$	db	'close$'
delete$	db	'delete$'
failed$	db	' failed.',CR,LF,'$'


; Format the date

;Enter with packed date in AX.
;Return CX and DX loaded with date
;per Svc 2BH requirements
;CX = year (1980-2099)
;DH = month
;DL = day

Date	Record	Yr:7,Mo:4,Dy:5		;Packed	date

GetDate	PROC	NEAR
	push	bx			;save BX

	mov	bx,ax			;Save date
	and	AX,Mask	Yr		;Get year part
	mov	CL,Yr			;Bits to shift
	shr	ax,cl			;year
	add	ax,1980			;add in the '1980'		v1.1
	push	ax			;save it on the stack a sec

	mov	ax,bx			;Get the date back
	and	AX,Mask	Mo		;Get month part
	mov	CL,Mo			;Bits to shift
	shr	ax,cl			;month
	mov	dh,al			;DH needs month

	mov	ax,bx			;Get the date back
	and	AX,Mask	Dy		;Get day part
	mov	CL,Dy			;Bits to shift
	shr	ax,cl			;day
	mov	dl,al			;DL needs day
	pop	cx			;CX needs year

	pop	bx			;restore
	ret
GetDate	ENDP

;	Format the time

;Enter with packed time in AX.
;Return CX and DX per DOS Svc 2DH requirements
;CL=minutes
;CH=hours
;DL=hundredths of seconds
;DH=seconds

Time	Record	Hour:5,Min:6,Sec:5	;Packed	time

GetTime	PROC	NEAR
	push	bx			;save a tick
	mov	bx,ax			;BX holds packed time

	and	AX,Mask	Hour		;Get hour part
	mov	CL,Hour			;Bits to shift
	shr	AX,CL
	mov	dh,al			;save it in DH

	mov	ax,bx			;Get the time back
	and	AX,Mask	Min		;Get min part
	mov	CL,Min			;Bits to shift
	shr	ax,cl
	mov	dl,al			;save it
	mov	ax,bx			;get the time back
	and	ax,Mask Sec		;get seconds part

	mov	cx,dx			;CX needs hours/minutes
	xor	dx,dx			;no hundredths of seconds avail
	mov	dh,al			;DH needs seconds

	pop	bx			;restore
	ret
GetTime	ENDP

fpath	db	'%:\',0		;file path for temp file (root)
	db	12 dup(0)	;room for appended temp filename

CSEG	ENDS
	END	NetTime
