.\" Originally by Jeff Kellem
.\"
.TH ARCHIE 1 "20 November 1991" "Archie (Prospero)"
.SH NAME
archie \- query the Archie anonymous FTP databases using Prospero
.SH SYNOPSIS
.in +\w'\fBarchie \fR'u
.ti -\w'\fBarchie \fR'u
.B archie\
\ [\ \fB\-cers\fR\ ]\
\ [\ \fB\-l\fR\ ]\ [\ \fB\-t\fR\ ]\
\ [\ \fB\-m#\fR\ ]\ [\ \fB\-N#\fR\ ]\
\ [\ \fB\-h\fR\ \fIhost\fR\ ]\ [\ \fB\-L\fR\ ]\ \fIstring\fR
.SH DESCRIPTION
.B archie
queries an archie anonymous FTP database looking for the specified
.I string
using the
.B Prospero
protocol.  This client is based on
.B Prospero
version Beta.4.2 and is provided to encourage non-interactive use of
the Archie servers (and subsequently better performance on both
sides).

The general method of use is of the form

.RS
%
.B archie string
.RE
.PP

This will go to the archie server and ask it to look for all known
systems that have a file named `string' in their FTP area.  \fBarchie\fP
will wait, and print out any matches.

For example,

.RS
%
.B archie emacs
.RE
.PP

will find all anonymous FTP sites in the archie database that have files
named
.B emacs
somewhere in their FTP area.  (This particular query would probably
return a lot of directories.)  If you want a list of every filename
that contains \fBemacs\fR \fIanywhere\fR in it, you'd use

.RS
%
.B archie -c emacs
.RE
.PP

Regular expressions, such as

.RS
%
.B archie -r '[xX][lL]isp'
.RE
.PP

may also be used for searches.  (See the manual of a reasonably good
editor, like GNU Emacs or vi, for more information on using regular
expressions.)

.SH OPTIONS
The options currently available to this
.B archie
client are:

.PD 0
.TP 12
.BR \-c
Search substrings paying attention to upper & lower case.
.TP
.BR \-e
Exact string match.  (This is the default.)
.TP
.BR \-r
Search using a regular expression.
.TP
.BR \-s
Search substrings ignoring the case of the letters.
.TP
.BR \-l
Output results in a form suitable for parsing by programs.
.TP
.BR \-t
Sort the results inverted by date.
.TP
.BI \-m#
Specifies the maximum number of hits (matches) to return (default of 
\fB95\fR).
.TP
.BI \-N#
Sets the \fIniceness\fR of a query; by default, it's set to 0.
Without an argument, \fB\-N\fR defaults to \fB35765\fR.  If you use
\fB\-N\fR with an argument between 0 and 35765, it'll adjust itself
accordingly.  (\fBNote\fR: VMS users will have to put quotes around
this argument, and \fB\-L\fR, like ``\fB\-N45\fR''; VMS will otherwise convert
it to lowercase.)
.TP
.BI \-h\ \fIhost\fR
Tells the client to query the Archie server named \fIhost\fR.
.TP
.BI \-L
Lists the Archie servers known to the program when it was compiled.
.TP
.BI \-H\ \fIconfigfile\fR
(DOS ONLY) Tells Archie where to find the config.tel file, if not in the
current directory, and not set in the DOS environment variable \fBCONFIGTEL\fR.

.PP

.SS Quick Hits
You'll often find yourself making fast and furious queries for
multiple things that all look similar (e.g. `telnet', `net', etc).  If
you get into the habit of using the
.BR \-c
option when performing these kinds of searches, they'll often prove
more fruitful than if you relied upon the default of
.BR \-e .

.SS Notes
The three search-modifying arguments (\fB\-c\fR, \fB\-r\fB, and \fB\-s\fR)
are all mutually exclusive; only the last one counts.  If you specify
\fB\-e\fR with any of \fB\-c\fR, \fB\-r\fB, or \fB\-s\fR,
the server will first check for an exact match, then fall back to the
case-sensitive, case-insensitive, or regular expression search.  This is
so if there are matches that are particularly obvious, it will take a
minimal amount of time to satisfy your request.

If you list a single `\-' by itself, any further arguments will be
taken as part of the search string.  This is intended to enable
searching for strings that begin with a `\-'; for example:

.RS
%
.B archie \-s \- \-old
.RE

will search for all filenames that contain the string `\-old' in them.

.SH RESPONSE
Archie servers are set up to respond to a number of requests in a
queued fashion.  That is, smaller requests get served much more
quickly than do large requests.  As a result, the more often you query
the Archie server, or the larger your requests, the longer the queue
will become, resulting in a longer waiting period for everyone's
requests.  Please be frugal when possible, for your benefit as well as
for the other users.

.SH QUERY PRIORITY
Please use the \fB\-N\fR option whenever you don't demand immediacy, or
when you're requesting things that could generate large responses.
Even when using the nice option, you should still try to avoid big
jobs during busy periods.  Here is a list of what we consider to be
nice values that accurately reflect the priority of a job to the server.

.RS
.TP 20
.B Normal
0
.TP
.B Nice
500
.TP
.B Nicer
1000
.TP
.B Very Nice
5000
.TP
.B Extremely Nice
10000
.TP
.B Nicest
32765
.RE

The last priority, \fBNicest\fR, would be used when a job should wait until
the queue is essentially empty before running.  You should pick one of
these values to use, possibly modifying it slightly depending on where
you think your priority should land.  For example, 32760 would mean
wait until the queue is empty, but jump ahead of other jobs that have
selected \fBNicest\fR.

There are certain types of things that we suggest using \fBNicest\fR
for, irregardless.  In particular, any searches for which you would
have a hard time justifying the use of anything but extra resources.
(We all know what those searches would be for.)

.SH SEE ALSO
For more information on regular expressions, see the manual pages on:

.BR regex (3) ,
.BR ed (1)

Also read the file \fBarchie/whatis\fR on \fBarchie.mcgill.ca\fR for a
detailed paper on Archie as a whole.

.SH AUTHORS
The 
.B archie
service was conceived and implemented by Alan Emtage (\fBbajan@cs.mcgill.ca\fR),
Peter Deutsch (\fBpeterd@cs.mcgill.ca\fR), and Bill Heelan
(\fBwheelan@cs.mcgill.ca\fR).  The entire Internet is in their debt.

The \fBProspero\fR system was created by Clifford Neuman
(\fBbcn@isi.edu\fR); write to \fBinfo\-prospero@isi.edu\fR for more
information on the protocol and its use.

This stripped client was put together by Brendan Kehoe
(\fBbrendan@cs.widener.edu\fR), with modifications by
Clifford Neuman and George Ferguson (\fBferguson@cs.rochester.edu\fR).

.SH BUGS
There are none; only a few unexpected features.

