title Password Locked System Program.
page 60,120			; page length = 60
				; page width  = 120
;
;	This program lock a system to protect open network connections.
;
;	LOCK : Copyright (c) 1989 by John Wolchak.  
;	This program is released into the Public Domain.
;
;	John Wolchak.
;	56 Physics Building
;	University of Saskatchewan.
;	Saskatoon, Saskatchewan
;	Canada     S7K 0W0
;	Phone: (306) 966-4852
;	NetNorth (BITNET): Wolchak@Sask
;	Inter_Network: Wolchak@Admin.Usask.Ca
;
;	To assemble:
;	masm lock,,,
;	link lock,,,
;	exe2bin lock.exe lock.com
;
code segment
assume cs:code,ds:code
org 100h

start:		jmp beginning
;
;		Data Area
;
exit_code	db	02h		; Help message displayed.
v_error		db	13,10,"Password verification failed",13,10,"$"
u_prompt	db	13,10,13,10,"Unlock Password> $"
l_prompt	db	13,10,"Lock Password> $"
v_prompt	db	13,10,"Verification> $"
s_pass		dw	00h		; Size of password.
d_pass		db	80 dup(0)	; Original Password.
v_pass		db	80 dup(0)	; Verification Password.
dos_maj		db	00h		; DOS major version.
dos_min		db	00h		; DOS minor version.
author		db	"Lock by Password System Program.",13,10
		db	"V1.0 (c) 23-Nov-1989 by John Wolchak.",13,10
		db	13,10
help		db	"Usage:		LOCK",13,10,9,9
		db	13,10
		db	"Example:	lock ",13,10,9,9
		db	"Lock Password> ",13,10,9,9
		db	"Verification> ",13,10,9,9
		db	13,10,9,9
		db	"Unlock Password> ",13,10
		db	"$"
;
;		Code Area
;
Beginning:
		mov si, 80h		; Offset of command line.
		lodsb			; Get a byte.
		cmp al, 00h		; Is there any data.
		jz get_ver		; Yes. Jump.
		cmp al, 0dh		; Is there any data.
		jz get_ver		; Yes. Jump.
dis_help:
		mov dx, offset author	; Help message.
		mov ah, 09h		; Display it.
		int 21h
		mov exit_code, 00h	; Command, help issued.
		jmp nor_term		; Exit.

get_ver:	
		mov ah, 30h		; Get DOS version number.
		int 21h

		mov dos_maj, al		; Save major version.
		mov dos_min, ah		; Save minor version.

		cmp ah, 01h
		jnz cont
		mov exit_code, 01h	; No MS-DOS version 1.x.
		jmp nor_term		; Exit.

cont:
		lodsb			; Get a byte.
		cmp al, " "		; Is it leading blank.
		jz cont			; Yes.  Loop.
		cmp al, 09h		; Is it leading tab.
		jz cont			; Yes.  Loop.
		cmp al, 0dh		; Is it a carriage return.
		jnz dis_help		; Yes. dis_help.

again:
;		Get the lock password.
		mov ax, offset d_pass	; Where we will store
		mov di, ax		;   the password.
		mov bx, 00h		; Password size.

;		Display the prompt.
		mov dx, offset l_prompt	; lock password prompt.
		mov ah, 09h		; Display it.
		int 21h

;		Direct Charater Input without echo.
l_loop:		mov ah, 07h		; Read a character.
		int 21h			; Get it.

;		Get the password,
;		and convert to upper case.
		cmp al, " "		; Is it a blank.
		jz l_loop		; Yes.  Loop.
		cmp al, 09h		; Is it a tab.
		jz l_loop		; Yes.  Loop.
		cmp al, 0dh		; Is it the end.
		jz l_got		; Yes. We got it.
		cmp al, "z"		; Is
		jg l_not		;   it
		cmp al, "a"		;     lower
		jb l_not		;       case?
		sub al, 20h		; Make it upper case.
l_not:
		inc bx			; Count the characters.
		stosb			; Save the byte.
		cmp bx, 80h		; Too long.
		jz again		; Yes. Try again.
		jmp l_loop

l_got:
		cmp bx, 00h		; Do we have data.
		jnz l_cont		; No quit.
		mov exit_code, 02h	; Program abort.
		jmp nor_term

l_cont:
		mov s_pass, bx		; Save the size.
		mov ax, offset v_pass	; Where we will store
		mov di, ax		;   the password.
		mov bx, 00h		; Password size.

;		Display the prompt.
		mov dx, offset v_prompt	; Verify password prompt.
		mov ah, 09h		; Display it.
		int 21h

;		Direct Charater Input without echo.
v_loop:		mov ah, 07h		; Read a character.
		int 21h			; Get it.

;		Get the password,
;		and convert to upper case.
		cmp al, " "		; Is it a blank.
		jz v_loop		; Yes.  Loop.
		cmp al, 09h		; Is it a tab.
		jz v_loop		; Yes.  Loop.
		cmp al, 0dh		; Is it the end.
		jz v_got		; Yes. We got it.
		cmp al, "z"		; Is
		jg v_not		;   it
		cmp al, "a"		;     lower
		jb v_not		;       case?
		sub al, 20h		; Make it upper case.
v_not:
		inc bx			; Count the characters.
		stosb			; Save the byte.
		cmp bx, 80h		; Too long.
		jz ver_err		; Yes. Try again.
		jmp v_loop

v_got:
		cmp s_pass, bx		; Is it the wrong size?
		jnz ver_err		; Yes try it again.

		mov di, offset v_pass	; Set destination.
		mov si, offset d_pass	; Set Source.
		mov cx, s_pass
		rep cmpsb		; Does it verify.
		jz unl_pass		; Yes. Jump out.

;		Display error message.
ver_err:
		mov dx, offset v_error	; Error message.
		mov ah, 09h		; Display it.
		int 21h
		jmp again
		
;		Unlock password.
unl_pass:
		mov ax, offset v_pass	; Where we will store
		mov di, ax		;   the password.
		mov bx, 00h		; Password size.

;		Display the prompt.
		mov dx, offset u_prompt	; Unlock password prompt.
		mov ah, 09h		; Display it.
		int 21h

;		Direct Charater Input without echo.
u_loop:		mov ah, 07h		; Read a character.
		int 21h			; Get it.

;		Get the password,
;		and convert to upper case.
		cmp al, " "		; Is it a blank.
		jz u_loop		; Yes.  Loop.
		cmp al, 09h		; Is it a tab.
		jz u_loop		; Yes.  Loop.
		cmp al, 0dh		; Is it the end.
		jz u_got		; Yes. We got it.
		cmp al, "z"		; Is
		jg u_not		;   it
		cmp al, "a"		;     lower
		jb u_not		;       case?
		sub al, 20h		; Make it upper case.
u_not:
		inc bx			; Count the characters.
		stosb			; Save the byte.
		cmp bx, 80h		; Too long.
		jz unl_pass		; Yes. Try again.
		jmp u_loop

u_got:
		cmp s_pass, bx		; Is it the wrong size?
		jnz unl_pass		; Yes try it again.

		mov di, offset v_pass	; Set destination.
		mov si, offset d_pass	; Set Source.
		mov cx, s_pass
		rep cmpsb		; Does it verify.
		jz next			; Yes. Jump out.

		jmp unl_pass
		
next:

;		Exit the program.
nor_term:
		mov al, cs:[exit_code]	; Set termination code.
		mov ah, 4ch		; Termination.
		int 21h

code ends
     end start
