/*
 *  Basic types
 */

typedef	unsigned long	dword;
typedef	unsigned int	word;
typedef	unsigned char	byte;
typedef	unsigned int	field;

typedef	struct
	{
	word	bp;
	word	di;
	word	si;
	word	ds;
	word	es;
	word	dx;
	word	cx;
	word	bx;
	word	ax;
	word	ip;
	word	cs;
	word	fl;
	}	IntrWordRegsType;

typedef	struct
	{
	word	filler[5];
	byte	dl;
	byte	dh;
	byte	cl;
	byte	ch;
	byte	bl;
	byte	bh;
	byte	al;
	byte	ah;
	}	IntrByteRegsType;

typedef	union
	{
	IntrWordRegsType	w;
	IntrByteRegsType	b;
	}	IntrRegsType;

enum
	{
	FL_CARRY		=	0x0001,
	FL_PARITY		=	0x0004,
	FL_AUXILIARY	=	0x0010,
	FL_ZERO			=	0x0040,
	FL_SIGN			=	0x0080,
	FL_OVERFLOW		=	0x0800
	};

typedef	enum
	{
	FALSE,
	TRUE
	} BOOLEAN;

#define	ErrInt		0x80000000L

typedef	void interrupt	(*InterruptPtrType)(void);

#define SECONDS		18

/*
 *  PSP layout
 */

typedef struct
	{
	word		PSP_Int20;
	word		PSP_MemSize;
	byte		PSP_fill1;
	byte		PSP_Call21[5];
	dword		PSP_TerminateVector;
	dword		PSP_BreakVector;
	dword		PSP_ErrorVector;
	byte		PSP_fill2[22];
	word		PSP_Environment;
	byte		PSP_fill3[34];
	byte		PSP_Int21Retf[3];
	word		PSP_fill4;
	byte		PSP_FCB1Extn[7];
	byte		PSP_FCB1[9];
	byte		PSP_FCB2Extn[7];
	byte		PSP_FCB2[9];
	byte		PSP_ParamLen;
	byte		PSP_Params[127];
	byte		PSP_DTA[128];
	}	PSP_Type, *PSP_Ptr;