/* Check to see if the current time is within a given 'window' */

/* Written by Bernie Roehl, May 1990 */

/* Exits with 1 if in window, 0 if not, 2 or more if error encountered */

#include <stdio.h>
#include <dos.h>

char *progname = "INWINDOW";

void main(int argc, char *argv[])
	{
	struct time dostime;
	int lh, ll, hh, hl, lowtime, hightime, now;
	if (argc != 2) {
		printf("%s: correct usage is 'INWINDOW hh:mm-hh:mm'\n", progname);
		exit(2);
		}
	if (sscanf(argv[1], "%d:%d-%d:%d", &lh, &ll, &hh, &hl) != 4) {
		printf("%s: invalid syntax in time range... should be hh:mm-hh:mm\n", progname);
		exit(3);
		}
	lowtime = lh * 100 + ll;
	hightime = hh * 100 + hl;
	gettime(&dostime);
	now = dostime.ti_hour * 100 + dostime.ti_min;
	if (lowtime < hightime) {  /* doesn't cross midnight */
		if (now < lowtime || now >= hightime)
			exit(0);
		}
	else {
		if (now < lowtime && now >= hightime)
			exit(0);
		}
	exit(1);
	}
