procedure full_window;
begin
  window(1,1,80,25);
end;

procedure transmit_color;
begin
  textcolor(f_clr[0]);
  textbackground(b_clr[0]);
end;

procedure receive_color;
begin
  textcolor(f_clr[1]);
  textbackground(b_clr[1]);
end;

procedure status_color;
begin
  textcolor(f_clr[2]);
  textbackground(b_clr[2]);
end;

procedure prompt_color;
begin
  textcolor(f_clr[3]);
  textbackground(b_clr[3]);
end;

procedure aux_color;
begin
  textcolor(f_clr[4]);
  textbackground(b_clr[4]);
end;

procedure help_color;
begin
  textcolor(f_clr[5]);
  textbackground(b_clr[5]);
end;

procedure check_video;
var regs : registers;
begin
  regs.AX := $0F00;
  Intr($10, regs);
  case regs.AL of
    2,3 : video := Addr(color_screen);
      7 : video := Addr(mono_screen);
  end;
end;

procedure save_screen;
begin
  FillPage(@Image);
end;

procedure restore_screen;
begin
  DisplayPage(@Image);
  receive_color;
  window(1,1,80,25);
  gotoxy(xin,yin);
end;

procedure save_entry_screen;
begin
  curs_x := whereX;
  curs_y := whereY;
  FillPage(@Screen1);
end;

procedure restore_entry_screen;
begin
  DisplayPage(@Screen1);
  window(1,1,80,25);
  gotoxy(curs_x,curs_y);
end;

