/****************************************************************************
*
*							 SuperVGA Test Kit
*
*                   Copyright (C) 1993 Kendall Bennett.
*							All rights reserved.
*
* Filename:		$RCSfile: svga16.h $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	IBM PC (MS DOS)
*
* Description:	Header file for the small 16 color SuperVGA test library.
*				This library provides a simplified interface to the
*				SuperVGA routines in the test kit to be called from C.
*
*				NOTE: This library only works in the large model.
*
* $Id: svga16.h 1.1 1993/03/03 10:27:48 kjb Exp $
*
* Revision History:
* -----------------
*
* $Log: svga16.h $
* Revision 1.1  1993/03/03  10:27:48  kjb
* Initial revision
*
****************************************************************************/

#ifndef	__SVGA16_H
#define	__SVGA16_H

#ifndef	__DRIVERS_H
#include "drivers.h"
#endif

/*--------------------------- Global Variables ----------------------------*/

extern	int		maxx,maxy;			/* Maximum coordinate values		*/
extern	int		maxpage;			/* Maximum video page number		*/
extern	int		bytesperline;		/* Bytes in a logical scanline		*/
extern	bool	twobanks;			/* True if separate banks available	*/
extern	bool	extendedflipping;	/* True if extended page flipping	*/
extern	bool	_VESAFirst;			/* Check for VESA SuperVGA's first	*/
extern	bool	_ignoreSVGA;		/* Ignore SuperVGA adapters			*/
extern	int		*modeList;			/* List of available video modes	*/

/*------------------------- Function Prototypes ---------------------------*/

#ifdef	__cplusplus
extern "C" {			/* Use "C" linkage when in C++ mode	*/
#endif

/* In svga16c.c */

void initSuperVGA(int *driver,int *chipID,int *memory,int *dac);
bool setSuperVGAMode(int mode);
void line(int x1,int y1,int x2,int y2,int color);

/* In svga16.asm */

void restoreMode(void);
void putPixel(int x,int y,int color);
void clear(void);
void setActivePage(int page);
void setVisualPage(int page);
void setBank(int bank);
void setReadBank(int bank);

#ifdef	__cplusplus
}						/* End of "C" linkage for C++	*/
#endif

#endif	/* __SVGA16_H */
