/****************************************************************************
*
*						MegaGraph Graphics Library
*
*                   Copyright (C) 1993 Kendall Bennett.
*							All rights reserved.
*
* Filename:		$RCSfile: names.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	IBM PC (MS DOS)
*
* Description:	Module for determining the names of specific video
*				drivers and modes.
*
* $Id: names.c 1.1 1993/03/03 10:47:24 kjb Exp $
*
* Revision History:
* -----------------
*
* $Log: names.c $
* Revision 1.1  1993/03/03  10:47:24  kjb
* Initial revision
*
****************************************************************************/

#include "drivers.h"

/*------------------------- Implementation --------------------------------*/

#include "modes.inc"			/* Symbolic video mode and driver names	*/

PUBLIC char *MGL_modeName(int mode)
/****************************************************************************
*
* Function:		MGL_modeName
* Parameters:	mode	- Mode number to retrieve name for
* Returns:		Pointer to the string for the mode
*
* Description:	Obtains a string describing the video mode 'mode' supported
*				by the currently active video configuration.
*
****************************************************************************/
{
	if (0 <= mode && mode <= grMAXMODE)
		return modeNames[mode];
	else
		return "Invalid graphics mode";
}

PUBLIC char *MGL_driverName(int driver)
/****************************************************************************
*
* Function:		MGL_driverName
* Parameters:	driver	- Driver number to retrieve name for
* Returns:		Pointer to the string describing the driver
*
* Description:	Obtains a string describing the device driver given it's
*				number.
*
****************************************************************************/
{
	if (grDETECT <= driver && driver < grUSER)
		return driverNames[driver];
	else
		return "User graphics driver";
}

PUBLIC char *MGL_dacName(int dac)
/****************************************************************************
*
* Function:		MGL_dacName
* Parameters:	dac		- Video DAC id
* Returns:		Pointer to the string describing the DAC
*
****************************************************************************/
{
	if (0 <= dac && dac <= 3)
		return dacNames[dac];
	else
		return "Unknown DAC";
}

PUBLIC char *MGL_chipsetName(int driver,int chipset)
/****************************************************************************
*
* Function:		MGL_chipsetName
* Parameters:	driver	- Driver id
*				chipset	- Chipset id
* Returns:		Pointer to the string describing the chipset
*
****************************************************************************/
{
	if ((__FIRST_SVGA+1) <= driver && driver <= __LAST_SVGA) {
		if (chipsetNames[driver - __FIRST_SVGA - 1] == NULL)
			return NULL;
		else
			return chipsetNames[driver - __FIRST_SVGA - 1][chipset];
		}
	else
		return "Invalid driver!";
}
