
{**************************************************************************
 TITLE    : DISPLAY
 VERSION  : 2.1
 FUNCITON : Displays a data file by the GRAFED procedure.
 INPUTS   :
 OUTPUTS  : Graphics display of xy data.
 NOTES    :
 AUTHOR   : Roger Carlson (based upon that of M. Riebe and R. Carlson
            written for the IBM CS9000 computer)  5/29/90
 CHANGES  : 6/2/90 (RJC,1.1) - Verison 1.1 of GRAFED.
            6/3/90 (RJC,1.2) - Version 1.2 of GRAFED.
            6/9/90 (RJC,1.3) - Version 1.3 of GRAFED.  Prevented genera-
              tion of test data file if it already exists.
            6/12/90 (RJC,1.4) - Version 1.4 of GRAFED.
            8/18/90 (RJC,1.5) - Version 1.5 of GRAFED.
            3/23/91 (RJC,1.6) - Version 1.6 of GRAFED.
            3/28/91 (RJC,1.7) - Version 1.7 of GRAFED.
            5/2/91  (RJC,1.8) - Version 1.8 of GRAFED.
            5/4/91  (RJC,1.9) - Version 1.9 of GRAFED.
            5/9/91  (RJC,2.0) - Version 2.0 of GRAFED.
            5/23/91 (RJC,2.1) - Version 2.1 of GRAFED.
*************************************************************************}

{$I-}  {disable IO checking}
{$M 16384,0,70000}

PROGRAM DISPLAY;

USES GRAFED, {version 2.1}
     IOFUNCS,{version 1.5}
     CRT;

CONST VERSION=2.1;

VAR
  DATA     : DARRAY;    {first index =1 is x, 2 is y}
  FILENAME : STR20;     {name of the data file}
  J        : INTEGER;   {loop variable}
  NUMPTS   : INTEGER;   {number of points in data array}
  RECEIVED : BOOLEAN;   {flags successfull reading of data}
  X,Y      : REAL;      {temporary x and y values}
  XINC,YINC: REAL;      {x and y axis margin}
  XMIN,XMAX: REAL;      {min and max of x data}
  YMIN,YMAX: REAL;      {min and max of y data}

PROCEDURE GEN_DATA(VAR DATA:DARRAY; VAR NUMPTS:INTEGER;
                   VAR RECEIVED:BOOLEAN);
VAR I:INTEGER;
    OUTFILE:TEXT;
BEGIN
  ASSIGN(OUTFILE,'TEST.DAT'); REWRITE(OUTFILE);
  NUMPTS:=101;
  FOR I:=1 TO NUMPTS DO BEGIN
    DATA[1,I]:=(I-1)*2*3.14/NUMPTS; DATA[2,I]:=1000000*SIN(DATA[1,I]);
    DATA[1,I]:=DATA[1,I]*10000;
    WRITELN(OUTFILE,DATA[1,I],' ',DATA[2,I]);
  END; {FOR}
  CLOSE(OUTFILE);
  RECEIVED:=TRUE;
END; {GET_DATA}

PROCEDURE GET_DATA(VAR DATA:DARRAY; VAR NUMPTS:INTEGER; VAR FILENAME:STR20;
                   VAR RECEIVED:BOOLEAN);
VAR
  ERR      : INTEGER;   {error flag}
  INFILE   : TEXT;      {input file}
  QUIT     : BOOLEAN;   {flag to abort procedure}
BEGIN
  REPEAT {until RECEIVED of QUIT}
    RECEIVED:=FALSE;
    WRITELN;
    WRITE('Name of the data file (carriage return to quit): ');
      READLN(FILENAME);
    IF FILENAME='' THEN QUIT:=TRUE
    ELSE BEGIN
      QUIT:=FALSE;
      IF NOT EXISTS(FILENAME) THEN BEGIN
        BEEP(200); WRITELN('No such file!');
        END; {IF}
      END; {ELSE}
    IF NOT(QUIT) AND EXISTS(FILENAME) THEN BEGIN
      NUMPTS:=0;
      ASSIGN(INFILE,FILENAME); ERR:=IORESULT; RESET(INFILE);
      IF ERR<>0 THEN BEGIN
        CLOSE(INFILE);
        WRITELN('IO error number ',ERR);
        END {IF}
      ELSE BEGIN
        WHILE NOT(EOF(INFILE)) AND (ERR=0) AND (NUMPTS<MAXPTS) DO BEGIN
          NUMPTS:=NUMPTS+1;
          READLN(INFILE,DATA[1,NUMPTS],DATA[2,NUMPTS]); ERR:=IORESULT;
          IF (NUMPTS MOD 10) = 0 THEN WRITE('*');
        END; {WHILE}
        WRITELN;
        IF (NUMPTS=MAXPTS) AND NOT(EOF(INFILE)) THEN BEGIN
          BEEP(200);
          WRITELN('Too many data points!  Only the first ',MAXPTS,
                  ' will be displayed.');
          WRITE('Hit <ENTER> to continue.'); READLN;
          END; {IF}
        CLOSE(INFILE);
        IF ERR<>0 THEN BEGIN
          BEEP(200);
          WRITELN('Input file has wrong format!'); NUMPTS:=0;
          END; {IF}
        END; {ELSE}
      IF NUMPTS>0 THEN RECEIVED:=TRUE;
      END; {IF}
  UNTIL RECEIVED OR QUIT;
END; {GET_DATA}

BEGIN
  CLRSCR;
  WRITELN('Program DISPLAY - Version',VERSION:4:1);
  WRITELN('Complements of Roger J. Carlson and Michael T. Riebe.');
  WRITELN;
  WRITELN('This program reads a text file of up to ',MAXPTS,' xy data');
  WRITELN('points and displays that data graphically on most PCs.');
  WRITELN;
  WRITELN('Bytes of memory available: ',MEMAVAIL);
  IF NOT EXISTS('TEST.DAT') THEN GEN_DATA(DATA,NUMPTS,RECEIVED);
  REPEAT
    GET_DATA(DATA,NUMPTS,FILENAME,RECEIVED);
    IF RECEIVED THEN BEGIN
      YMAX:=DATA[2,1]; YMIN:=DATA[2,1];
      XMIN:=DATA[1,1]; XMAX:=DATA[1,NUMPTS];
      FOR J:=1 TO NUMPTS DO BEGIN
        Y:=DATA[2,J]; X:=DATA[1,J];
        IF Y>YMAX THEN YMAX:=Y; IF Y<YMIN THEN YMIN:=Y;
        IF X>XMAX THEN XMAX:=X; IF X<XMIN THEN XMIN:=X;
        END; {IF}
      YINC:=(YMAX-YMIN)/20; IF YINC=0 THEN YINC:=1;
      YMAX:=YMAX+YINC;      YMIN:=YMIN-YINC;
      XINC:=(XMAX-XMIN)/40; IF XINC=0 THEN XINC:=1;
      XMIN:=XMIN-XINC;      XMAX:=XMAX+XINC;
      GRAF(DATA,FILENAME,XMIN,XMAX,YMIN,YMAX,NUMPTS);
      CLRSCR;
      END; {IF}
  UNTIL RECEIVED=FALSE;
  CLRSCR;
END.