

libpnm(3)                  Unix Programmer's Manual                  libpnm(3)


NAME
     libpnm - functions to support portable anymap programs

SYNOPSIS

     #include <pnm.h>
     cc ... libpnm.a libppm.a libpgm.a libpbm.a


DESCRIPTION

     TYPES AND CONSTANTS

     typedef ... xel;
     typedef ... xelval;
     #define PNM_MAXMAXVAL ...
     extern xelval pnm_pbmmaxval;

     Each xel contains three xelvals, each of which should  contain  only  the
     values  between  0  and  PNM_MAXMAXVAL.  pnm_pbmmaxval is the maxval used
                                 -               -
     when a PNM program reads a PBM file.  Normally it is 1; however, for some
     programs, a larger value gives better results.

     XEL MANIPULATIONS

     xelval PNM_GET1( xel x )

     This macro extracts a single value from an xel, when you know it's from a
     PBM  or PGM file.  When it's from a PPM file, use PPM_GETR(), PPM_GETG(),
                                                          -           -
     and PPM_GETB().
            -

     void PNM_ASSIGN1( xel x, xelval v )

     This macro assigns a single value to an xel, when you know  it's  from  a
     PBM or PGM file.  When it's from a PPM file, use PPM_ASSIGN().
                                                         -

     int PNM_EQUAL( xel x, xel y )

     This macro checks two xels for equality.

     int PNM_FORMAT_TYPE( int format )
            -      -

     For distinguishing different file types.

     INITIALIZATION

     void pnm_init( int* argcP, char* argv[] )

     All PNM programs must call this routine.

     MEMORY MANAGEMENT

     xel** pnm_allocarray( int cols, int rows )

     Allocate an array of xels.



                                                                             1



libpnm(3)                  Unix Programmer's Manual                  libpnm(3)


     xel* pnm_allocrow( int cols )
             -

     Allocate a row of the given number of xels.

     void pnm_freearray( xel** xels, int rows )
             -

     Free the array  allocated  with  pnm_allocarray()  containing  the  given
                                         -
     number of rows.

     void pnm_freerow( xel* xelrow )

     Free a row of xels.

     READING FILES

     void pnm_readpnminit( FILE* fp, int* colsP, int* rowsP, xelval*  maxvalP,
     int* formatP )

     Read the header from a PNM file, filling in the rows,  cols,  maxval  and
     format variables.

     void pnm_readpnmrow( FILE* fp, xel* xelrow, int cols, xelval maxval,  int
             -
     format )

     Read a row of xels into the xelrow array.  Format, cols, and maxval  were
     filled in by pnm_readpnminit().
                     -

     xel** pnm_readpnm( FILE* fp, int* colsP,  int*  rowsP,  xelval*  maxvalP,
     int* formatP )

     Read an entire anymap file into memory, returning the allocated array and
     filling  in  the rows, cols, maxval, and format variables.  This function
     combines  pnm_readpnminit(),   pnm_allocarray()   and   pnm_readpnmrow().
                  -                    -                        -
     Unlike  the  equivalent  functions  in  PBM, PGM, and PPM, it returns the
     format so you can tell what type the file is.

     WRITING FILES

     void pnm_writepnminit( FILE* fp, int cols, int rows, xelval  maxval,  int
     format, int forceplain )

     Write the header for a  portable  anymap  file.   Unlike  the  equivalent
     functions in PBM, PGM, and PPM, you have to specify the output type.  The
     forceplain flag forces a plain-format file to be written, as opposed to a
     raw-format one.

     void pnm_writepnmrow( FILE* fp, xel* xelrow, int cols, xelval maxval, int
             -
     format, int forceplain )

     Write a row from a portable anymap.

     void pnm_writepnm( FILE* fp, xel**  xels,  int  cols,  int  rows,  xelval
             -
     maxval, int format, int forceplain )

     Write the header and all data  for  a  portable  anymap.   This  function
     combines pnm_writepnminit() and pnm_writepnmrow().
                 -                      -


                                                                             2



libpnm(3)                  Unix Programmer's Manual                  libpnm(3)


     FORMAT PROMOTION

     void pnm_promoteformatrow( xel* xelrow,  int  cols,  xelval  maxval,  int
     format, xelval newmaxval, int newformat )

     Promote a row of xels from one maxval and format to a new set.  Used when
     combining  multiple anymaps of different types - just take the max of the
     maxvals and the max of the formats, and promote them all to that.

     void pnm_promoteformat( xel** xels, int cols, int  rows,  xelval  maxval,
             -
     int format, xelval newmaxval, int newformat )

     Promote an entire anymap.

     XEL MANIPULATION

     xel pnm_whitexel( xelval maxval, int format )
     xel pnm_blackxel( xelval maxval, int format )

     Return a white or black xel for the given maxval and format.

     void pnm_invertxel( xel* x, xelval maxval, int format )
             -

     Invert an xel.

     xel pnm_backgroundxelrow( xel*  xelrow,  int  cols,  xelval  maxval,  int
            -
     format )

     Figure out an appropriate background xel based on this row.

     xel pnm_backgroundxel( xel** xels, int cols, int rows, xelval maxval, int
            -
     format )

     Figure out a background xel based on an entire anymap.   This  can  do  a
     slightly better job than pnm_backgroundxelrow().
                                 -

SEE ALSO
     pbm(3), pgm(3), ppm(3)

AUTHOR
     Copyright (C) 1989, 1991 by Tony Hansen and Jef Poskanzer.

















                                                                             3

