/* OFFto3DV.c  -  convert OFF format to 3DV */

/* Oscar Garcia <garciao@mof.govt.nz>, May 1992 */

/* uses getopt */
int getopt(int argc, char *argv[], char *options);
extern  int optind;
extern char *optarg;

#include <stdlib.h>
#include <stdio.h>

#define USAGE "usage: OFFto3DV [/cn] [infile] [outfile]\n\
\tIf file names are omitted, the standard i/o streams are used.\n\
\tOptions (with defaults):\n\
\t\t/c9  -  colour\n"

#define ERROR(msg) {fputs(msg,stderr),exit(1);}
#define PERROR(msg) {perror(msg),exit(1);}

void main(int argc, char* argv[])
{
	int npoints, npolygons, nedges, i, n, p, q, colour = 9;
	FILE *infile = stdin, *outfile = stdout;
	char line[82];
	char options[] = "c:";

	/* get options */
	while ((n = getopt(argc, argv, options)) != EOF)
	{	if (n == '?')
			ERROR(USAGE)
		else
			colour = atoi(optarg);
	}

	/* open files */
	if (optind < argc - 2)
		ERROR(USAGE);	/* too many */
	if (optind < argc)
	{	infile = fopen(argv[optind], "rt");
		if (infile == NULL)
			ERROR("Can't open input file");
		if (++optind < argc)
		{	outfile = fopen(argv[optind], "wt");
			if (outfile == NULL)
				ERROR("Can't open output file");
		}
	}

	/* first line (counts) */
	if (3 != fscanf(infile, "%d %d %d", &npoints, &npolygons, &nedges) ||
			NULL == fgets(line, 81, infile))
		ERROR("Error reading first line");
	fprintf(outfile, "%d\n", npoints);

	/* copy coordinates */
	for (i = 1; i <= npoints; i++)
	{	if (NULL == fgets(line, 81, infile))
		{	fprintf(stderr, "Error reading point #%d", i);
			exit(1);
		}
		fputs(line, outfile);
	}

	/* process polygons */
	fprintf(outfile, "%d\n", npolygons + nedges);
	for (i = 1; i <= npolygons; i++)
	{	if (2 != fscanf(infile, "%d %d", &n, &p))
			ERROR("Bad input: polygon not found");
		nedges -= n;	/* for checking */
		fprintf(outfile, "%d 0\n", p);	 /* move to polygon start */
		while (--n > 0)
		{	fscanf(infile, "%d", &q);
			fprintf(outfile, "%d %d\n", q, colour); /* draw */
		}
		fprintf(outfile, "%d %d\n", p, colour); /* close the polygon */
	}
	if (ferror(infile))
		PERROR("Error reading file");
	if (feof(infile))
		ERROR("Unexpected end of file on input");
	fclose(infile);
	if (ferror(outfile))
		PERROR("Error writing output");
	fclose(outfile);
	if (nedges != 0)
		ERROR("Number of edges does not match header");
}
