/* sw_zip.c - respondfiles for the pk(un)?zip commands.
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/sw_zip.c'v 0.9 90/09/09 21:44:23 tho Stable $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "swaplib.h"

/* Build a respondfile for the pk(un)?zip archive managers from ARGV.  */

int
_swap_build_zip_respond_file (char **argv, char **envv)
{
  int len = 0;
  int i = 0;
  FILE *respond_file = NULL;
  _swap_respond_file_name = swap_mktmpname ("zi");

  respond_file = fopen (_swap_respond_file_name, "w");
  if (!respond_file)
    {
      int last_errno = errno;
      fprintf (stderr, "can't open zip respond file: ");
      errno = last_errno;
      perror (_swap_respond_file_name);
      return -1;
    }

  argv++;

  while (**argv == '-')		/* leave options on the commandline */
    {
      int len = strlen (*argv);
      if (i + len > 126)
	{
	  strcpy (_swap_cmdline_buf, CMDLINE_TOO_LONG);
	  errno = E2BIG;
	  return -1;
	}
      strcpy (_swap_cmdline_buf + i, *argv);
      i += len;
      _swap_cmdline_buf[i++] = ' ';
      argv++;
    }

  if (*argv == NULL		/* missing zipfilename? */
      || i + strlen (*argv) + strlen (_swap_respond_file_name) > 124)
    {
      strcpy (_swap_cmdline_buf, CMDLINE_TOO_LONG);
      errno = E2BIG;
      return -1;
    }

  sprintf (_swap_cmdline_buf + i, "%s @%s", *argv++, _swap_respond_file_name);

  while (*argv)
    fprintf (respond_file, "%s\n", *argv++);

  fprintf (respond_file, "\n");
  fclose (respond_file);

  return _swap_format_msdos_environment (NULL, envv, NULL);
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
