/* swaplib.h - public declarations for swaplib
   Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

   This file is part of SWAPLIB (the library), a library for efficient
   execution of child processes under MS-DOS.

   The library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   The library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Header: e:/gnu/swaplib/RCS/swaplib.h'v 0.9 90/09/09 21:44:27 tho Stable $
 */

#ifndef _FILE_DEFINED
#include <stdio.h>
#endif

/* The main entry points, working just like spawn[lv]p?e? () from
   the standard MSC library.  */

extern int swap_spawnl (char *cmd, char *argv0, ...);
extern int swap_spawnle (char *cmd, char *argv0, ...);
extern int swap_spawnlp (char *cmd, char *argv0, ...);
extern int swap_spawnlpe (char *cmd, char *argv0, ...);

extern int swap_spawnv (char *cmd, char **argv);
extern int swap_spawnve (char *cmd, char **argv, char **envv);
extern int swap_spawnvp (char *cmd, char **argv);
extern int swap_spawnvpe (char *cmd, char **argv, char **envv);

extern int swap_system (char *command);
extern FILE *swap_popen (char *command, char *mode);
extern int swap_pclose (FILE *pipe);


/* Where to swap to. */

enum swap_swapping_mode
{
  none, disk, ems, xms
};

/* Be smart about passing arguments.  */

struct swap_respondfile_action
{
  char *prog;					/* The name we recognize */
  int (*action) (char **argv, char **envv);	/* The action we take.  */
};

/* You don't want to call this... */

int _swap_spawn_child (enum swap_swapping_mode mode, char *path,
		       char *cmdline, char *env, int len, char *swap_file);


/* Functions you might want to override.  */

extern enum swap_swapping_mode swap_set_swapping_mode (char *cmd, char **argv);
extern int swap_smart_p (char *name);
extern struct swap_respondfile_action *swap_set_respondfile_actions (void);
extern char *swap_invoke_shell (char *cmd, char ***argvp);

/* Dedicated handlers for specific commands.  */

extern int _swap_build_cl_environment (char **argv, char **envv);
extern int _swap_build_fl_environment (char **argv, char **envv);
extern int _swap_build_masm_environment (char **argv, char **envv);
extern int _swap_build_link_respond_file (char **argv, char **envv);
extern int _swap_build_lib_respond_file (char **argv, char **envv);
extern int _swap_build_zip_respond_file (char **argv, char **envv);

/* Generic handlers.  */

extern int _swap_format_msdos_environment (char **argv, char **envv, ...);
extern int _swap_build_msc_environment (char *prefix, char **argv,
					char **envv);

extern int _swap_build_cmdline (char **argv);


/* Path expansion, etc.  */

extern char *swap_expand_path (char *name, char *env,
			       char *(*select) (char *));
extern char *swap_executable_p (char *path);
extern char *swap_basename (char *path);
extern char *swap_back_slashify (char *path);
extern char *swap_mktmpname (char *prefix);


/* Should we really make these public?  */

extern char _swap_cmdline_buf[];
extern char *_swap_environ_buf;
extern char *_swap_respond_file_name;

#define PROGRAM "spawn"
#define CMDLINE_TOO_LONG "<" PROGRAM ":commandline-too-long>"


/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
