{Header, Footer, And Output Information - all one (long!) procedure}

PROCEDURE get_hfaoi; {eorf : CHAR}
(*****************************************************************************
Asks for header, footer and output information
argument: 'E' if file input with mini-editor, 'F' if input from ext file
******************************************************************************)
VAR
    c,scode : CHAR;
    ans : STRING[2];
    i,err,num_blk : INTEGER;
    all_defaults,found : BOOLEAN;
    yr,mon,dy,dow : WORD;
    yr_temp : STRING[4];
LABEL restart,default_loop,prt_loop,page_loop,disp_loop;
BEGIN
    TextBackground(Black);
    tot_pages:=TRUNC((tot_tty_lines/Max_Lines_Page)+0.98);
    If tot_pages <= 0 THEN BEGIN
        beep;
        WRITELN; TextColor(LightMagenta);
        WRITELN('No text in message.  Nothing to do!');
        TextColor(Yellow);
        WRITELN; WRITE('Strike any key to return to DOS ... ');
        c:=READKEY;
        WRITELN;
        halt
    END;
    Num_blk:=1;
    WRITELN;
    found:=FALSE;
    ASSIGN(io_file,bfn);                  {open sign block file}
    IF NOT open_fn(bfn) THEN BEGIN
        clrscr; TextColor(LightMagenta);
        WRITELN('Signature block file not found');
        WRITELN
    END ELSE BEGIN
        {first line of file has print positions:}
        READLN(io_file,hp_lm,hp_tm,hp_head,hp_no,hp_text,hp_sign,hp_cl);
        {reading signature block file:}
        WHILE NOT EOF(io_file) DO BEGIN   {read sign blocks}
            READLN(io_file,sig_blk[Num_blk].code);
            READLN(io_file,sig_blk[Num_blk].line1);
            READLN(io_file,sig_blk[Num_blk].line2);
            num_blk:=num_blk+1
        END;
        CLOSE(io_file)
    END;
    num_blk:=num_blk-1;

restart:
    TextBackGround(Black);
    IF num_blk<=0 THEN BEGIN
        TextColor(LightMagenta);
        WRITELN('No default signature blocks found');
        WRITELN
    END ELSE BEGIN                  {if any good sign blocks}
        CLRSCR; TextColor(LightGreen);
        WRITE('Code ',#26,' Signature Block');     {show 'em on screen}
        GOTOXY(39,1);
        WRITE('Code ',#26,' Signature Block');     {second column}
        TextColor(Cyan);
        FOR i:=1 TO num_blk DO
            IF INT(i/2)<>(i/2) THEN BEGIN
                GOTOXY(2,i+2);
                TextColor(LightRed); WRITE(sig_blk[i].code);
                TextColor(Cyan); WRITE(#26,sig_blk[i].line1);
                GOTOXY(4,i+3);
                WRITE(sig_blk[i].line2)
            END ELSE BEGIN
                GOTOXY(40,i+1);
                TextColor(LightRed); WRITE(sig_blk[i].code);
                TextColor(Cyan); WRITE(#26,sig_blk[i].line1);
                GOTOXY(42,i+2);
                WRITE(sig_blk[i].line2)
            END;
        {end}
        WRITELN;                             {sign block code entry}
        WRITELN;
        TextColor(LightCyan);   WRITE('     Options:    ');
        TextColor(LightRed);  WRITE('<enter> ');
        TextColor(Cyan); WRITELN(#26,' For manual entry of signature block');
        TextColor(LightRed);  WRITE('                  <esc>  ');
        TextColor(Cyan); WRITELN(#26,' To abort and exit TTYPRT to DOS');
        TextColor(LightRed);  WRITE('                    =    ');
        TextColor(Cyan); WRITELN(#26,' To review message text');
        TextColor(LightRed);  WRITE('                    !    ');
        TextColor(Cyan); WRITELN(#26,' Return to mini-editor for more text entry');
        TextColor(LightRed);  WRITE('                    ?    ');
        TextColor(Cyan); WRITELN(#26,' Help!  Explain this to me');
        TextColor(LightRed);  WRITE('                    _    ');
        TextColor(Cyan); WRITELN(#26,' Signature block code as above');
        WRITELN;
        TextColor(Yellow); WRITE('            Enter signature block code (or other option) ',#26,' ');
        TextColor(Cyan); c:=READKEY;
        c:=UpCase(c);
        WRITELN(c);
        CASE c OF
        '=' : BEGIN
                  disp_msg;
                  GOTO restart
              END;
        #27 : BEGIN
                  WRITELN; WRITELN; TextColor(Yellow);
                  WRITE('Do you wish to abort and exit TTYPRT? ');
                  c:=READKEY; TextColor(Cyan); WRITELN;
                  IF c IN ['Y','y'] THEN BEGIN
                      WRITELN('Aborting to DOS');
                      HALT
                  END;
                  GOTO restart
              END;
        '!' : BEGIN
                  IF eorf='E' THEN
                      mini_ed(TRUE)    {restart of mini_ed}
                  ELSE BEGIN
                      eorf:='E';
                      rfn:=ifn;
                      mini_ed(FALSE)   {first run of mini_ed}
                  END;
                  GOTO restart
              END;
        '?' : BEGIN
                  help_msg('signblk');
                  GOTO restart
              END
        END {case}
    END;

    i:=1;
    WHILE (c <> sig_blk[i].code) AND (i < num_blk) DO i:=i+1;
    IF c=sig_blk[i].code THEN BEGIN          {assign values from memory}
        sign1:=sig_blk[i].line1;
        sign2:=sig_blk[i].line2
    END ELSE BEGIN
        WRITELN; TextColor(Cyan);            {enter 'em manually}
        WRITELN('Manual entry of signature block');
        WRITELN('                    | maximum length of sign lines=35 |');
        TextBackGround(Black); TextColor(Yellow); WRITE(' Enter first line ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray); READLN(sign1);
        TextBackGround(Black); TextColor(Yellow); clreol; WRITE('Enter second line ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray); READLN(sign2);
        TextBackGround(Black); clreol;
    END;
    FOR i:=1 TO LENGTH(sign1) DO sign1[i]:=UpCase(sign1[i]); {force all}
    FOR i:=1 TO LENGTH(sign2) DO sign2[i]:=UpCase(sign2[i]); {uppercase}
    sign1:=COPY(sign1,1,Sign_Length);        {limit length}
    sign2:=COPY(sign2,1,Sign_Length);
    WRITELN;

default_loop:
    TextColor(Yellow);
    WRITE('Use all header default settings? (Y/N/?/<esc>) ',#26,' ');
    c:=READKEY; TextBackGround(Blue); TextColor(LightGray);
    CASE c OF
    'Y','y',#13 : BEGIN             {use all default settings?}
                 all_defaults:=true;
                 WRITE('Yes')
              END;
    'N','n' : BEGIN
                 all_defaults:=FALSE;
                 WRITE('No')
              END;
    '?'     : BEGIN
                 help_msg('prtdeflts');
                 clrscr;
                 GOTO default_loop
              END;
    #27     : BEGIN
                  TextColor(Yellow); TextBackGround(Black); WRITELN; WRITELN;
                  WRITE('Do you wish to abort and exit TTYPRT? ');
                  c:=READKEY; TextColor(Cyan); WRITELN;
                  IF c IN ['Y','y'] THEN BEGIN
                      WRITELN;
                      WRITELN('Aborting to DOS');
                      HALT
                  END;
                  GOTO default_loop
              END;
    ELSE      BEGIN
			      beep; WRITELN; WRITELN;
                  GOTO default_loop
              END
    END; {case}
    TextBackGround(Black);
    WRITELN;
    WRITELN;

    IF all_defaults THEN                     {classification}
        class:='UNCLASSIFIED'
    ELSE BEGIN
        TextColor(Yellow); WRITE('Enter classification (U,F,C,S,T), <enter> for "Unclass" ',#26,' ');
        c:=READKEY; TextBackGround(Blue); TextColor(LightGray);
        CASE c OF
               ^M  : class:='UNCLASSIFIED';
           'u','U' : class:='UNCLASSIFIED';
           'f','F' : class:='FOR OFFICIAL USE ONLY';
           's','S' : class:='SECRET';
           'c','C' : class:='CONFIDENTIAL';
           't','T' : class:='TOP SECRET';
              ELSE   class:='UNCLASSIFIED'
        END; {case}
        WRITE(class); TextBackGround(Black); WRITELN;
        IF (class[1]<>'U') AND (class[1]<>'F') THEN BEGIN
            TextColor(Yellow); WRITE('Enter "CLASSIFIED BY" ',#26,' ');
            TextBackGround(Blue); TextColor(LightGray);
            READLN(class_by); TextBackGround(Black); clreol;
            FOR i:=1 TO LENGTH(class_by) DO class_by[i]:=UpCase(class_by[i]);
            TextColor(Yellow); WRITE('Enter "DECLASSIFY ON" ',#26,' ');
            TextBackGround(Blue); TextColor(LightGray);
            READLN(declass); TextBackGround(Black); clreol;
            FOR i:=1 TO LENGTH(declass) DO declass[i]:=UpCase(declass[i]);
        END
    END;
    WRITELN;

    IF all_defaults THEN                     {action precedence}
        act_pred:='RR'
    ELSE BEGIN
        TextColor(Yellow); WRITE('Enter action addressees precedence, <enter> for "R" ',#26,' ');
        c:=READKEY; TextBackGround(Blue); TextColor(LightGray);
        IF c=^M THEN
            act_pred:='RR'
        ELSE
            act_pred:=UpCase(c)+UpCase(c);
        WRITE(act_pred);
        TextBackGround(Black); WRITELN;
    END;
    WRITELN;

    IF all_defaults THEN                     {info precedence}
        info_pred:='RR'
    ELSE BEGIN
        TextColor(Yellow); WRITE('Enter info addressees precedence, <enter> for "R" ',#26,' ');
        c:=READKEY; TextBackGround(Blue); TextColor(LightGray);
        IF c=^M THEN
            info_pred:='RR'
        ELSE
            info_pred:=UpCase(c)+UpCase(c);
        WRITE(info_pred);
        TextBackGround(Black); WRITELN;
    END;
    WRITELN;

    IF all_defaults THEN                     {day time group}
        dtg:='       '
    ELSE BEGIN
        TextColor(Yellow); WRITE('Optional: Enter Day Time Group, <enter> for blank ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray);
        READLN(dtg); TextBackGround(Black); clreol;
        IF LENGTH(dtg)>7 THEN dtg:=COPY(dtg,1,7);  {dtg is 7 chars only!}
        WHILE LENGTH(dtg)<7 DO dtg:=dtg+' '        {dtg -> ddhhmmZ}
    END;
    WRITELN;

page_loop:
    TextColor(cyan);
    WRITELN('Number of pages in message ',#26,' ',tot_pages:3);
    IF all_defaults THEN                     {starting page}
        start_page:=1
    ELSE BEGIN
        TextColor(Yellow); WRITE('Start at what page, <enter> for beginning ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray);
        READLN(ans);
        IF ans='' THEN BEGIN
            start_page:=1;
            WRITE('Beginning')
        END ELSE
            VAL(ans,start_page,err);
        TextBackGround(Black); clreol; WRITELN;
    END;
    IF (start_page<1) OR (start_page>tot_pages+1) THEN BEGIN
        beep; TextColor(LightMagenta);
        WRITELN('Cannot start printing at that page number!');
        goto page_loop
    END;
    WRITELN;

    IF all_defaults THEN                     {ending page}
        end_page:=99
    ELSE BEGIN
        TextColor(Yellow); WRITE('Stop after what page, <enter> for end ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray);
        READLN(ans);
        IF ans='' THEN BEGIN
            end_page:=99;
            WRITE('End')
        END ELSE
            VAL(ans,end_page,err);
        TextBackGround(Black); clreol; WRITELN;
    END;
    WRITELN;

    GetDate(yr,mon,dy,dow);                  {convert system date to}
    Str(yr:4,yr_temp);                       {something usable}
    yr_str:=Copy(yr_temp,3,2);
    CASE mon OF
       1 : mon_str:='JAN';
       2 : mon_str:='FEB';
       3 : mon_str:='MAR';
       4 : mon_str:='APR';
       5 : mon_str:='MAY';
       6 : mon_str:='JUN';
       7 : mon_str:='JUL';
       8 : mon_str:='AUG';
       9 : mon_str:='SEP';
      10 : mon_str:='OCT';
      11 : mon_str:='NOV';
      12 : mon_str:='DEC';
    END; {case}
disp_loop:
    TextBackGround(Black); clrscr;  {display header, footer & output info}
    TextColor(Cyan); WRITE('     Message Classification ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);WRITE(class);
    TextBackGround(Black); WRITELN;
    IF (class[1]<>'U') AND (class[1]<>'F') THEN BEGIN
        TextBackGround(Black); TextColor(Cyan); WRITE('              Classified By ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray);WRITE(class_by); WRITELN;
        TextBackGround(Black);TextColor(Cyan); WRITE('              Declassify On ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray);WRITE(declass); WRITELN;
    END;
    TextBackGround(Black);TextColor(Cyan); WRITE('                       Date ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);WRITE(mon_str,' ',yr_str); WRITELN;
    TextBackGround(Black);TextColor(Cyan); WRITE('    Action/Info Precedences ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);WRITE(act_pred,'/',info_pred); WRITELN;
    IF dtg<>'       ' THEN BEGIN
        TextBackGround(Black);TextColor(Cyan); WRITE('     Optional DayTime Group ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray);WRITE(dtg); WRITELN;
    END;
    WRITELN;
    TextBackGround(Black);TextColor(Cyan); WRITE('     Signature Block line 1 ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);WRITE(sign1); WRITELN;
    TextBackGround(Black);TextColor(Cyan); WRITE('     Signature Block line 2 ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);WRITE(sign2); WRITELN;
    WRITELN;
    TextBackGround(Black);TextColor(Cyan); WRITE('     Total lines in Message ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);WRITE(tot_tty_lines:3); WRITELN;
    TextBackGround(Black);TextColor(Cyan); WRITE('            Number of pages ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);WRITE(tot_pages:3); WRITELN;
    IF tot_mfr_lines>0 THEN BEGIN
        TextBackGround(Black);TextColor(Cyan); WRITE('        Number of MFR lines ',#26,' ');
        TextBackGround(Blue); TextColor(LightGray);WRITE(tot_mfr_lines:3); WRITELN;
    END;
    WRITELN;
    TextBackGround(Black);TextColor(Cyan); WRITE('     Print starting at page ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);
    IF start_page=1 THEN
        WRITE('Beginning')
    ELSE
        WRITE(start_page:3);
    WRITELN;
    TextBackGround(Black);TextColor(Cyan); WRITE('             Ending on page ',#26,' ');
    TextBackGround(Blue); TextColor(LightGray);
    IF end_page=99 THEN
        WRITE('End')
    ELSE
        WRITE(end_page:3);
    IF tot_mfr_lines>0 THEN WRITE(' + MFR');
    WRITELN;
prt_loop:
    TextBackGround(Black); TextColor(LightGreen);
    WRITELN;                                 {final prompt before printing}
    WRITELN('Please insert DD173/2 form and insure the printer is setup for OCR-A printing');
    WRITELN; TextColor(LightCyan);
    WRITE('Options:  ');
    TextColor(LightRed);  WRITE('<enter> ');
    TextColor(Cyan); WRITE(#26,' Start printing           ');
    TextColor(LightRed);  WRITE('R ');
    TextColor(Cyan); WRITELN(#26,' Re-enter header info');
    TextColor(LightRed);  WRITE('           <esc>  ');
    TextColor(Cyan); WRITE(#26,' Abort TTYPRT to DOS      ');
    TextColor(LightRed);  WRITE('= ');
    TextColor(Cyan); WRITELN(#26,' Review message text');
    TextColor(LightRed);  WRITE('             !    ');
    TextColor(Cyan); WRITE(#26,' Return to mini-editor    ');
    TextColor(LightRed);  WRITE('? ');
    TextColor(Cyan); WRITELN(#26,' Help!  Explain this to me');
    WRITELN;
    TextColor(Yellow); WRITE('Waiting '); TextColor(Cyan);
    c:=READKEY;
    WRITELN;
    CASE c OF
    '='     : BEGIN
                 disp_msg;
                 GOTO disp_loop
              END;
    '?'     : BEGIN
                 help_msg('prtready');
                 clrscr;
                 GOTO disp_loop
              END;
    '!'     : BEGIN
                  IF eorf='E' THEN
                      mini_ed(TRUE)    {restart of mini_ed}
                  ELSE BEGIN
                      eorf:='E';
                      rfn:=ifn;
                      mini_ed(FALSE)   {first run of mini_ed}
                  END;
                  GOTO disp_loop
              END;
    'R','r' : BEGIN
                 clrscr;
                 GOTO restart
              END;
    #27     : BEGIN
                  WRITELN; TextColor(Yellow);
                  WRITE('Do you wish to abort and exit TTYPRT? ');
                  c:=READKEY; TextColor(Cyan); WRITELN;
                  IF c IN ['Y','y'] THEN BEGIN
                      WRITELN('Aborting to DOS');
                      HALT
                  END;
                  GOTO prt_loop
              END;
    ^M      : ;   {no action, everything's ok}
    ELSE      BEGIN
                  beep;
                  GOTO prt_loop
              END
    END {case}
END; {PROCEDURE get_hfaoi}
