{These are support routines to the mini-editor}

PROCEDURE ed_ent;
(*****************************************************************************
process a <ret> or <ent>
******************************************************************************)
VAR i:INTEGER;
    keychr:CHAR;
BEGIN
    IF Ins_Mode THEN BEGIN                   {break lines}
        tmpstr:=COPY(ed_text[ln],cc,Max_Tty_Width-cc+1);  {what to move down}
        ed_text[ln]:=COPY(COPY(ed_text[ln],1,cc-1)+spaces,1,Max_Tty_Width);
                                                 {what is left}
        keychr:=ed_text[ln+1][1];                {last char of *next* line}
        IF (keychr=' ') OR (keychr='!') OR       {if next line is blank}
            ((keychr>'1') AND (keychr<'9')) THEN BEGIN {or starts a new para}
            IF ln<=last_ln THEN BEGIN            {bump everyline down one}
                FOR i:=last_ln DOWNTO ln DO
                    ed_text[i+1]:=ed_text[i];
                last_ln:=last_ln+1
            END;
            IF ln<Max_Ed_Lines THEN                 {eof check}
                ed_text[ln+1]:=COPY(tmpstr+spaces,1,Max_Tty_Width); {fill in}
        END ELSE BEGIN
            i:=LENGTH(tmpstr);
            ln:=ln+1;                            {point to next line}
            WHILE (tmpstr[i]=' ') AND (i>0) DO i:=i-1;   {del trailing spaces}
            tmpstr:=COPY(tmpstr,1,i)+' '+ed_text[ln];    {build next line}
            i:=wrapper;                          {wrap new line to eo para}
            ln:=ln-1;                            {pt back ot org line}
        END;
        dr_page
    END;
    IF ln+1-top_ln<Ln_Pg THEN                {scroll needed?}
        ln:=ln+1
    ELSE
        IF ln<Max_Ed_Lines THEN BEGIN           {scroll stuff}
            top_ln:=top_ln+1;
            ln:=ln+1;
            dr_page
        END;
    {end}
    cc:=1
END; {PROCEDURE ed_ent}

PROCEDURE ed_tab;
(*****************************************************************************
process a <tab>
******************************************************************************)
BEGIN
    IF cc<Tab_Col THEN BEGIN                 {if curr pos < tab column}
        IF Ins_Mode THEN BEGIN               {inset approp # of spaces}
            tmpstr:=COPY(ed_text[ln],1,cc-1)+COPY(spaces,1,Tab_Col-cc)+
                COPY(ed_text[ln],cc,Max_Tty_Width-cc);
            IF wrapper>0 THEN                {& wrap}
                dr_page                      {redraw whole page}
            ELSE BEGIN
                GOTOXY(2,3+ln-top_ln);       {redraw just this line}
                WRITE(ed_text[ln])
            END
        END
        {cc:=Tab_Col}
    END ELSE                                 {curr pos > tab column}
        IF ln-top_ln+1<Ln_Pg THEN BEGIN      {move to next line - scroll?}
            ln:=ln+1
        END ELSE
            IF ln<Max_Ed_Lines THEN BEGIN       {scroll stuff}
                top_ln:=top_ln+1;
                ln:=ln+1;
                dr_page
            END;
        {end}
    {end}
    cc:=Tab_Col                              {put cursor on tab column}
END; {PROCEDURE ed_tab}

PROCEDURE ed_recall;
(*****************************************************************************
recall deleted line from 'tmpstr'
******************************************************************************)
VAR i:INTEGER;
BEGIN
    FOR i:=last_ln DOWNTO ln DO         {bump every subsequent line down one}
        ed_text[i+1]:=ed_text[i];
    last_ln:=last_ln+1;                 {add one to count}
    ed_text[ln]:=delstr;                {insert the deleted buffer}
    dr_page
END; {PROCEDURE ed_recall}

PROCEDURE ed_delln;
(*****************************************************************************
delete line
******************************************************************************)
VAR i:INTEGER;
BEGIN
    delstr:=ed_text[ln];
    FOR i:=ln TO last_ln DO                  {pull everyline up one}
        ed_text[i]:=ed_text[i+1];
    IF ln<=last_ln THEN last_ln:=last_ln-1;  {delete one from count}
    cc:=1;                                   {return to col 1}
    dr_page
END; {PROCEDURE ed_delln}

PROCEDURE ed_insln;
(*****************************************************************************
insert line
******************************************************************************)
VAR i:INTEGER;
BEGIN
    FOR i:=last_ln DOWNTO ln DO    {bump every subsequent line down one}
        ed_text[i+1]:=ed_text[i];
    last_ln:=last_ln+1;
    ed_text[ln]:=spaces;
    cc:=1;
    dr_page
END; {PROCEDURE ed_insln}

PROCEDURE ed_deleol;
(*****************************************************************************
delete to end of line;
******************************************************************************)
BEGIN
    ed_text[ln]:=COPY(COPY(ed_text[ln],1,cc-1)+spaces,1,Max_Tty_Width);
    GOTOXY(2,3+ln-top_ln);       {redraw just this line}
    WRITE(ed_text[ln])
END; {PROCEDURE ed_deleol}

PROCEDURE ed_bs;
(*****************************************************************************
process a backspace
******************************************************************************)
VAR i,j:INTEGER;
BEGIN
    IF (cc<>1) AND (cc<>Max_Tty_Width+1) THEN BEGIN {eol or bol?}
        cc:=cc-1;                            {no}
        DELETE(ed_text[ln],cc,1);
        ed_text[ln]:=ed_text[ln]+' ';
        GOTOXY(2,3+ln-top_ln);               {redraw this line}
        WRITE(ed_text[ln])
    END ELSE BEGIN                           {yes, join lines}
        IF top_ln=ln THEN                    {adjust top line if neccessary}
            IF top_ln>1 THEN
                top_ln:=top_ln-1;
        IF ln>1 THEN BEGIN
            ln:=ln-1;
            i:=Max_Tty_Width;
            IF ed_text[ln][i]<>' ' THEN      {prev line does not end in sp}
                tmpstr:=ed_text[ln]+ed_text[ln+1]
            ELSE BEGIN
                WHILE (ed_text[ln][i]=' ') AND (i>0) DO i:=i-1;
                                              {strip trailing spaces prev line}
                IF i=0 THEN BEGIN             {and add wrapped line to ti}
                    tmpstr:=ed_text[ln+1];
                    cc:=1
                END ELSE BEGIN
                    tmpstr:=COPY(ed_text[ln],1,i)+' '+ed_text[ln+1];
                    cc:=i+2
                END
            END;

            FOR j:=ln+1 TO last_ln DO               {pull everyline up one}
                ed_text[j]:=ed_text[j+1];
            IF ln<last_ln THEN last_ln:=last_ln-1; {delete one from count}
            j:=wrapper                              {& wrap}
        END;
        dr_page                                     {redraw whole page}
    END
END; {PROCEDURE ed_bs}

PROCEDURE ed_del;
(*****************************************************************************
delete character
******************************************************************************)
BEGIN
    Delete(ed_text[ln],cc,1);            {delete char at cursor}
    ed_text[ln]:=ed_text[ln]+' ';        {tack a space on eol}
    GOTOXY(2,3+ln-top_ln);               {redraw just this line}
    WRITE(ed_text[ln])
END; {PROCEDURE ed_del}

PROCEDURE ed_zap;
(*****************************************************************************
clear all msg text
******************************************************************************)
VAR c:CHAR;
    i:INTEGER;
BEGIN
    GOTOXY(40,24); TextColor(Yellow); TextBackground(Black);
    WRITE('Zap (delete) all text? ',#26,' ');
    c:=READKEY;
    IF (c='Y') or (c='y') THEN BEGIN
        FOR i:=1 TO Max_Ed_Lines DO ed_text[i]:=spaces;
        ln:=1; cc:=1; top_ln:=1;
        dr_page
    END;
    TextBackground(Black); GOTOXY(40,24); CLREOL; TextBackground(Blue);
END; {PROCEDURE ed_zap}

PROCEDURE ed_ins;
(*****************************************************************************
toggle insert mode
******************************************************************************)
BEGIN                          {insert}
    GOTOXY(11,24);
    IF Ins_Mode THEN BEGIN
        Ins_Mode:=FALSE;
        WRITE('Overwrite')
    END ELSE BEGIN
        Ins_Mode:=TRUE;
        WRITE('Insert   ')
    END
END; {PROCEDURE ed_ins}

PROCEDURE ed_find;
(*****************************************************************************
find a char string
******************************************************************************)
VAR stng:STRING[20];
    i,p:INTEGER;
    found:BOOLEAN;
    c:CHAR;
BEGIN
    GOTOXY(40,24); TextColor(Yellow); TextBackground(Black);
    WRITE('Find String ',#26,'');
    READLN(stng);
    FOR i:=1 TO LENGTH(stng) DO stng[i]:=UPCASE(stng[i]);
    i:=ln;
    found:=FALSE;
    WHILE (i<last_ln) AND NOT found DO BEGIN
        p:=POS(stng,ed_text[i]);
        IF p=0 THEN
            i:=i+1
        ELSE BEGIN
            ln:=i;
            cc:=p;
            found:=TRUE;
            IF (ln<top_ln) OR (ln>top_ln+Ln_Pg-1) THEN BEGIN
                top_ln:=ln;
                dr_page
            END
        END
    END;
    IF NOT found THEN BEGIN
        GOTOXY(40,24);
        WRITE('Not Found, strike any key ...');
        c:=READKEY;
    END;
    TextBackground(Black); GOTOXY(40,24); ClrEol; TextBackground(Blue);
END; {PROCEDURE ed_find}


PROCEDURE ed_abort;
(*****************************************************************************
save editor file and abort?
******************************************************************************)
LABEL loop;
BEGIN
loop:
    TextColor(LightGreen); TextBackground(Black); clrscr;
    WRITELN('Program abort requested, do you want to save message text?');
    WRITELN; TextColor(LightCyan);
    WRITE('     Options:  ');
    TextColor(LightRed); WRITE('Y   ');
    TextColor(Cyan); WRITELN(#26,' Yes, save to a file and then abort to DOS');
    TextColor(LightRed); WRITE('               N   ');
    TextColor(Cyan); WRITELN(#26,' No, discard message text and abort to DOS');
    TextColor(LightRed); WRITE('             <esc> ');
    TextColor(Cyan); WRITELN(#26,' Do not abort and return to mini-editor');
    TextColor(LightRed); WRITE('               ?   ');
    TextColor(Cyan); WRITELN(#26,' Help!  Explain this to me');
    WRITELN;
    TextColor(Yellow); WRITE('Waiting '); TextColor(Cyan);
    c:=READKEY;
    WRITELN;
    CASE c OF
    '?'     : BEGIN
                  help_msg('edabort');
                  clrscr;
                  GOTO loop;
              END;
    'Y','y' : BEGIN
                  savefile;
                  WRITELN;
                  WRITELN('TTYPRT halted.');
                  HALT
              END;
    'N','n' : BEGIN
                  WRITELN;
                  WRITELN('TTYPRT halted.');
                  HALT
              END
    { ELSE      anything other than Y or N, return to editor}
    END {case}
END; {PROCEDURE ed_abort}

PROCEDURE ed_help;
(*****************************************************************************
displays an help screen for the mini editor
******************************************************************************)
BEGIN
    TextBackGround(Black); clrscr;
    TextColor(Yellow); WRITELN('             <F1>  TTY Print!  Mini-Editor Help screen');
    TextColor(Cyan); WRITELN;
    TextColor(LightRed); WRITE('      ',#24,', ',#27,', ',#25,', ',#26);
    TextColor(Cyan); WRITELN('   Arrow keys move one space in the appropriate direction');
    WRITELN;
    TextColor(LightRed); WRITE('     <PgUp>,<PgDn> ');
    TextColor(Cyan); WRITELN('Move one screen up or down');
    TextColor(LightRed); WRITE('     <Home>,<End>  ');
    TextColor(Cyan); WRITELN('Move to top or bottom of screen');
    TextColor(LightRed); WRITE('<Ctrl-Home>,<Ctrl-End>  ');
    TextColor(Cyan); WRITELN('Move to top or bottom of message');
    WRITELN;
    TextColor(LightRed); WRITE('            <F10>  ');
    TextColor(Cyan); WRITELN('To save entries and continue to header info input');
    TextColor(LightRed); WRITE('          <Alt-X>  ');
    TextColor(Cyan); WRITELN('Discard all input and exit program');
    TextColor(LightRed); WRITE('          <Alt-Z>  ');
    TextColor(Cyan); WRITELN('Zap (clear) all text (confirmation required)');
    WRITELN;
    TextColor(LightRed); WRITE('   <Ins> ');
    TextColor(Cyan); WRITE('Toggle insert/overwrite mode   ');
    TextColor(LightRed); WRITE('<F5>  ');
    TextColor(Cyan); WRITELN('Save entries in a file (also ^W)');
    TextColor(LightRed); WRITE('   <Del> ');
    TextColor(Cyan); WRITE('Delete character at cursor     ');
    TextColor(LightRed); WRITE('<F6>  ');
    TextColor(Cyan); WRITELN('Read (insert) text from a file');
    WRITELN;
    TextColor(LightRed); WRITE('         <F7>     ');
    TextColor(Cyan); WRITELN('Delete line, move all subsequent lines up');
    TextColor(LightRed); WRITE('         <F8>     ');
    TextColor(Cyan); WRITELN('Insert blank line at cursor, push subsequent lines down');
    TextColor(LightRed); WRITE('         <F9>     ');
    TextColor(Cyan); WRITELN('Recall last deleted line, insert at cursor location');
    WRITELN;
    TextColor(LightRed); WRITE('       <Enter>    ');
    TextColor(Cyan); WRITELN('Move to column 1 on next line, break lines if mode=Insert');
    TextColor(LightRed); WRITE('        <Tab>     ');
    TextColor(Cyan); WRITELN('Move to column 15 (where addresses should start)');
    TextColor(LightRed); WRITE('       <BckSp>    ');
    TextColor(Cyan); WRITELN('Destructive BackSpace (join lines if at column 1)');
    WRITELN;
    WRITELN('In addition, many WordStar Ctrl-keys may be used.  See documentation for list');
    TextColor(Yellow); WRITE('                  Strike a "?" for more help, or any other key to continue ...');
    c:=READKEY;
    IF c='?' THEN
        help_msg('edhelp');    {more help}
    dr_frame; dr_page          {draw screen}
END; {PROCEDURE ed_help}
