/*
 * ied.c -- take a string on the command line or on stdin, allow the
 *	    user to edit it, and put the result on stdout
 *
 * Released under the terms of the GNU General Public License.  No warranty
 * is expressed or implied.
 *
 * This version is for MS-DOS only, using MS C 5.1 and the CXL library v5.1.
 * Compile in the small model, and link against CXLMSS.LIB.
 *
 * A curses version for UNIX is in the works.
 *
 * Richard Reiner  rreiner@nexus.yorku.ca
 *
 * Ied leaves the screen undisturbed: it saves the screen on entry, and
 * restores the obscured area on exit.  The cursor, however, is likely
 * to be moved.
 *
 * Limits: the string to be edited, including the terminating
 * '\0', cannot exceed MAXSTRLEN characters.  If a longer string
 * is passed in, ied will abort with an error message and return
 * the string unchanged.
 *
 * Return values:   0 -- normal completion
 *		    1 -- input string too long to edit
 *
 * Revision history:
 *
 * 1.0	22 Aug 90	RjR	First version.
 *
 */

#include <stdio.h>
#include <string.h>

#include <cxl\cxldef.h>
#include <cxl\cxlvid.h>
#include <cxl\cxlwin.h>
#include <cxl\cxlstr.h>

#define MAXSTRLEN 77	/* maximum length of editable string including '\0' */
#define INBUFSIZE 512	/* size of input buffer */

int fsread(void);
void initcxl(void);
char *strrtrim(char *);

char str[INBUFSIZE];

main(int argc, char **argv)
{
    /* take arg from command line if there is one; otherwise read stdin */
    if (argc > 1)
	strcpy(str,argv[1]);
    else
	gets(str);

    if (strlen(str) > MAXSTRLEN) {
	fputs("\nied: error: string exceeds maximum editable length\n",stderr);
	fputs(str, stdout);
	exit(1);
    }
    else {
	initcxl();
	fsread();
	fputs(str, stdout);
	exit(0);
    }
}


/*---------------------------------------------------------------------------*/
/* fsread -- input a record in full-screen mode */
int fsread(void)
{
    WINDOW editwin;
    int editstat;
    char mask[MAXSTRLEN];

    /* set up the input mask */
    memset(mask,'*',MAXSTRLEN - 1);
    mask[MAXSTRLEN - 1] = '\0';

    editwin = wopen(10, 0, 14, 79, 1, LGREY | _BLACK, LGREY | _BLACK);
    wcenters(0, LMAGENTA | _BLACK, "Edit string; CR to accept, ESC to abort");

    winpbeg(LGREY | _BLACK, BLACK | _LGREY);
    winpdef(2, 1, str, mask, 0, 1, NULL, 0);
/*    winpdef(2, 1, str, "************************", 0, 1, NULL, 0); */
    editstat = winpread();

    wclose();

    /* kill all the trailing whitespace */
    strrtrim(str);

    return (editstat);
}


/*---------------------------------------------------------------------------*/
/* initialize CXL video and keyboard handling */
void initcxl(void)
{
    _vinfo.dvcheck = 0;
    /* don 't check for DESQview */
    videoinit();
    _vinfo.usebios = 0;
    wfillch('');
    /* background char for windows */
    wsetesc(1);
    /* set ESC checking on */
}



/*---------------------------------------------------------------------------*/
/* strrtrim -- kill trailing whitespace in a string */
char *strrtrim(char *s)
{
    char *p;

    p = s + strlen(s) - 1;		/* point at the last data char */

    while (*p == ' ' || *p == '\t' || *p == '\n' || *p == '\r')
	p--;

    *(++p) = '\0';

    return (s);
}
