/***********************************************************************/
/* EDIT.C - The body of the program.                                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 * 
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 * 
 * 
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed 
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "the.h"

/*#define TRACE*/
/*-------------------------- external data ----------------------------*/
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_file;         /* pointer to current file */
extern char number_of_views;                   /* number of open files */
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern WINDOW *foot,*error_window;
extern char error_on_screen;
extern unsigned char *rec;
extern unsigned short rec_len;
extern unsigned char *cmd_rec;
extern unsigned short cmd_rec_len;
extern unsigned char mode_insert;        /* defines insert mode toggle */
extern char file_disposition;
extern short file_start;
extern unsigned char *dirfilename;
/*---------------------- function definitions -------------------------*/
#ifdef PROTO
void show_heading(int);
void show_footing(void);
int function_key(int);
char case_translate(char);
#else
void show_heading();
void show_footing();
int function_key();
char case_translate();
#endif
/***********************************************************************/
#ifdef PROTO
void editor(void)
#else
void editor()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short key=0;
 char real_key;
 unsigned short x,y;
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("edit.c:    editor");
#endif
 show_page();
 show_heading(key);
 show_footing();
 if (CURRENT_VIEW->prefix_on)
    wnoutrefresh(CURRENT_WINDOW_PREFIX);
 if (strcmp(CURRENT_FILE->fname,dirfilename) == 0)
    wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,file_start-1);
 else
    wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,0);

 wnoutrefresh(CURRENT_WINDOW_MAIN);
 wmove(CURRENT_WINDOW_COMMAND,0,0);
 wnoutrefresh(CURRENT_WINDOW_COMMAND);
 if (file_disposition != FILE_NORMAL)
   {
    switch(file_disposition)
      {
       case FILE_NEW:
                          display_error(0,"New File...");
                          break;
       case FILE_READONLY:
                          display_error(0,"File is read-only...");
                          break;
       default:
                          break;
      }
    touchwin(error_window);
    wnoutrefresh(error_window);
    wrefresh(CURRENT_WINDOW);
   }
 doupdate();

 while (1)
  {
   key = my_getch(CURRENT_WINDOW);
   if (error_on_screen == YES)
      {
       error_on_screen = NO;
       touchwin(foot);
      }
   rc = function_key(key);
   if (rc == QUIT && number_of_views == 0)
       break;
   if (rc >= RAW_KEY)
     {
      if (rc > RAW_KEY)
        key = rc - (RAW_KEY*2);
      if (key < 256 && key >= 0)
        {
         real_key = case_translate((char)key);
         switch(CURRENT_VIEW->current_window)
           {
            case WINDOW_MAIN:
                 if (CURRENT_VIEW->focus_line == 0
                 ||  CURRENT_VIEW->focus_line == CURRENT_FILE->number_lines + 1)
                    break;
                 getyx(CURRENT_WINDOW,y,x);
                 if (mode_insert)
                   {
                    rec = (unsigned char *)meminschr((char *)rec,
                                    real_key,CURRENT_VIEW->verify_col-1+x,
                                    MAX_LINE_LENGTH,rec_len);
                    put_char(CURRENT_WINDOW,real_key,INSCHAR);
                   }
                 else
                   {
                    rec[CURRENT_VIEW->verify_col-1+x] = real_key;
                    if (x == CURRENT_SCREEN.cols-1)
                      {
                       put_char(CURRENT_WINDOW,real_key,INSCHAR);
                      }
                    else
                       put_char(CURRENT_WINDOW,real_key,ADDCHAR);
                   }
                 rc = memrevne(rec,' ',MAX_LINE_LENGTH);
                 if (rc == (-1))
                    rec_len = 0;
                 else
                    rec_len = rc+1;
                 /* this is done here so that the show_page() in */
                 /* Right_arrow() is executed AFTER we get the   */
                 /* new length of rec_len.                       */
                 if (mode_insert
                 || x == CURRENT_SCREEN.cols-1)
                    Right_arrow("");
                 break;
            case WINDOW_COMMAND:
                 getyx(CURRENT_WINDOW,y,x);
                 if (mode_insert)
                   {
                    cmd_rec = (unsigned char *)meminschr((char *)cmd_rec,
                                    real_key,x,
                                    COLS,cmd_rec_len);
                    put_char(CURRENT_WINDOW,real_key,INSCHAR);
                    Right_arrow("");
                   }
                 else
                   {
                    cmd_rec[x] = real_key;
                    put_char(CURRENT_WINDOW,real_key,ADDCHAR);
                   }
                 rc = memrevne(cmd_rec,' ',COLS);
                 if (rc == (-1))
                    cmd_rec_len = 0;
                 else
                    cmd_rec_len = rc+1;
                 break;
            case WINDOW_PREFIX:
                 wclrtoeol(CURRENT_WINDOW);
                 if (mode_insert)
                   {
                    put_char(CURRENT_WINDOW,real_key,INSCHAR);
                    Right_arrow("");
                   }
                 else
                    put_char(CURRENT_WINDOW,real_key,ADDCHAR);
                 break;
           }
        }
     }
   wnoutrefresh(CURRENT_WINDOW_MAIN);
   if (CURRENT_VIEW->prefix_on)
      wnoutrefresh(CURRENT_WINDOW_PREFIX);
   wnoutrefresh(CURRENT_WINDOW_COMMAND);
   show_heading(real_key);
   show_footing();

   wnoutrefresh(CURRENT_WINDOW);
   doupdate();
   if (error_on_screen == YES)
      {
       touchwin(error_window);
       wnoutrefresh(error_window);
       wrefresh(CURRENT_WINDOW);
      }
 }
#ifdef TRACE
 trace_return();
#endif
 return;
}
