/***********************************************************************/
/* DEFAULT.C - Default settings and profile processing                 */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>
#include <stdlib.h>

#include "the.h"

/*#define DEBUG 1*/

/*--------------------------- extern data -----------------------------*/
extern WINDOW *foot;
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char display_screens;                      /* number of screens */
extern bool horizontal;
extern char current_file;                   /* pointer to current file */
extern LINE *next_line,*curr_line;
extern unsigned char *rec;
extern unsigned char in_profile;    /* indicates if processing profile */
extern char number_of_views;                        /* number of files */
extern char number_of_files;                   /* number of open files */

/*--------------------------- global data -----------------------------*/
extern unsigned char *profilename;

 unsigned char CMD_LINEx;
 unsigned char ERROR_ROWx;
 unsigned char TAB_ROWx;
 unsigned char TAB_ONx;
 unsigned char SCALE_ROWx;
 unsigned char SCALE_ONx;
 unsigned char PRE_ONx;
 unsigned char PRE_LEFTx;
 unsigned char CURRENT_ROW_POSx;
 unsigned char STAYx;
 unsigned char CASE_Ex;
 unsigned char CASE_Lx;
 unsigned char CASE_Cx;
 unsigned char TABI_ONx;
 unsigned char TABI_Nx;
 unsigned char TABO_ONx;
 unsigned char TABO_Nx;
 unsigned char TABSx;
 unsigned char CMDARROWSTABx;
 unsigned char AUSx;
 unsigned char EOLx;
 unsigned short VER_STAx;
 unsigned short VER_ENDx;
 unsigned short VER_COLx;
 unsigned short ZON_STAx;
 unsigned short ZON_ENDx;

/***********************************************************************/
#ifdef PROTO
void set_defaults(void)
#else
void set_defaults()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_defaults");
#endif
 CMD_LINEx = 'B';
 ERROR_ROWx = 1;
 TAB_ROWx = 6;
 TAB_ONx = FALSE;
 SCALE_ROWx = 6;
 SCALE_ONx = FALSE;
 PRE_ONx = TRUE;
 PRE_LEFTx = TRUE;
 CURRENT_ROW_POSx = 0;
 STAYx = ON;
 CASE_Ex = CASE_MIXED;
 CASE_Lx = CASE_IGNORE;
 CASE_Cx = CASE_RESPECT;

 TABI_ONx = FALSE;
 TABI_Nx = 8;
 TABO_ONx = FALSE;
 TABO_Nx = 8;
 TABSx = 8;
 CMDARROWSTABx = FALSE;

 VER_STAx = 1;
 VER_ENDx = MAX_LINE_LENGTH;
 VER_COLx = 1;
 ZON_STAx = 1;
 ZON_ENDx = MAX_INT;

 AUSx = 0;
#ifdef UNIX
 EOLx = EOLOUT_LF;
#endif
#if defined(DOS) || defined(OS2)
 EOLx = EOLOUT_CRLF;
#endif
/*---------------------------------------------------------------------*/
/* Set up the first dummy key definition.                              */
/*---------------------------------------------------------------------*/
 add_define("","","");
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void set_default_colours(void)
#else
void set_default_colours()
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/

/*--------------------------- local data ------------------------------*/
 chtype dflt_colour[ATTR_MAX];
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_default_colours");
#endif
/*---------------------------------------------------------------------*/
/* Set up default colours.                                             */
/*---------------------------------------------------------------------*/
#ifdef COLOR_CURSES
 if (has_colors() == TRUE)
   {
    init_pair(1,COLOR_WHITE,COLOR_BLUE);
    init_pair(2,COLOR_WHITE,COLOR_BLUE);
    init_pair(3,COLOR_BLUE,COLOR_WHITE);
    init_pair(4,COLOR_RED,COLOR_WHITE);
    init_pair(5,COLOR_BLACK,COLOR_CYAN);
    init_pair(6,COLOR_BLUE,COLOR_WHITE);
    init_pair(7,COLOR_RED,COLOR_WHITE);
    init_pair(8,COLOR_BLACK,COLOR_CYAN);
    init_pair(9,COLOR_BLACK,COLOR_CYAN);
    init_pair(10,COLOR_RED,COLOR_WHITE);
    init_pair(11,COLOR_RED,COLOR_WHITE);
    init_pair(12,COLOR_WHITE,COLOR_BLUE);
    init_pair(13,COLOR_WHITE,COLOR_BLUE);
    init_pair(14,COLOR_RED,COLOR_WHITE);
    init_pair(15,COLOR_RED,COLOR_WHITE);
    init_pair(16,COLOR_BLUE,COLOR_WHITE);
    init_pair(17,COLOR_RED,COLOR_WHITE);
    for (i=0;i<ATTR_MAX;i++)
        dflt_colour[i] = COLOR_PAIR(i+1);
    dflt_colour[ATTR_CURLINE] |= A_BOLD;
    dflt_colour[ATTR_TOFEOF] |= A_BOLD;
    dflt_colour[ATTR_CTOFEOF] |= A_BOLD;
    for (i=0;i<ATTR_MAX;i++)
      if (colour[i])            /* a colour has been set up in profile */
         set_colour(i,save_fg[i],save_bg[i],save_mod[i]);
      else
         colour[i] = dflt_colour[i];
   }
 else
   {
    dflt_colour[ATTR_FILEAREA] = A_NORMAL;           /* main window text lines */
    dflt_colour[ATTR_CURLINE]  = A_BOLD;                       /* current line */
    dflt_colour[ATTR_BLOCK]    = A_REVERSE;           /* text in markded block */
    dflt_colour[ATTR_CBLOCK]   = A_BOLD | A_REVERSE;
                                       /* current line if in marked block */
    dflt_colour[ATTR_CMDLINE]  = A_BOLD;                       /* command line */
    dflt_colour[ATTR_IDLINE]   = A_REVERSE;                    /* id line (top)*/
    dflt_colour[ATTR_MSGLINE]  = A_BLINK;                      /* message line */
    dflt_colour[ATTR_ARROW]    = A_BOLD;                       /* arrow prompt */
    dflt_colour[ATTR_PREFIX]   = A_BOLD;                        /* prefix area */
    dflt_colour[ATTR_PENDING]  = A_BOLD;            /* pending prefix commands */
    dflt_colour[ATTR_SCALE]    = A_BOLD;                         /* scale line */
    dflt_colour[ATTR_TOFEOF]   = A_BOLD;                      /* tof eof lines */
    dflt_colour[ATTR_CTOFEOF]  = A_BOLD;     /* current line if on t/eof lines */
    dflt_colour[ATTR_TABLINE]  = A_BOLD;                           /* tab line */
    dflt_colour[ATTR_SHADOW]   = A_BOLD;                       /* shadow lines */
    dflt_colour[ATTR_STATAREA] = A_REVERSE;             /* status line (bottom)*/
    dflt_colour[ATTR_DIVIDER]  = A_BOLD;                            /* divider */
    for (i=0;i<ATTR_MAX;i++)
      if (colour[i])            /* a colour has been set up in profile */
         set_colour(i,save_fg[i],save_bg[i],save_mod[i]);
      else
         colour[i] = dflt_colour[i];
   }
#else
 dflt_colour[ATTR_FILEAREA] = A_NORMAL;           /* main window text lines */
 dflt_colour[ATTR_CURLINE]  = A_BOLD;                       /* current line */
 dflt_colour[ATTR_BLOCK]    = A_REVERSE;           /* text in markded block */
 dflt_colour[ATTR_CBLOCK]   = A_BOLD | A_REVERSE;
                                    /* current line if in marked block */
 dflt_colour[ATTR_CMDLINE]  = A_BOLD;                       /* command line */
 dflt_colour[ATTR_IDLINE]   = A_REVERSE;                    /* id line (top)*/
 dflt_colour[ATTR_MSGLINE]  = A_BLINK;                      /* message line */
 dflt_colour[ATTR_ARROW]    = A_BOLD;                       /* arrow prompt */
 dflt_colour[ATTR_PREFIX]   = A_BOLD;                        /* prefix area */
 dflt_colour[ATTR_PENDING]  = A_BOLD;            /* pending prefix commands */
 dflt_colour[ATTR_SCALE]    = A_BOLD;                         /* scale line */
 dflt_colour[ATTR_TOFEOF]   = A_BOLD;                      /* tof eof lines */
 dflt_colour[ATTR_CTOFEOF]  = A_BOLD;     /* current line if on t/eof lines */
 dflt_colour[ATTR_TABLINE]  = A_BOLD;                           /* tab line */
 dflt_colour[ATTR_SHADOW]   = A_BOLD;                       /* shadow lines */
 dflt_colour[ATTR_STATAREA] = A_REVERSE;             /* status line (bottom)*/
 dflt_colour[ATTR_DIVIDER]  = A_BOLD;                            /* divider */
 for (i=0;i<ATTR_MAX;i++)
      if (colour[i])            /* a colour has been set up in profile */
         set_colour(i,save_fg[i],save_bg[i],save_mod[i]);
      else
         colour[i] = dflt_colour[i];
#endif

#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
short get_profile(unsigned char *prf)
#else
short get_profile(prf)
unsigned char *prf;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
extern unsigned char profile_pathname[80];
/*--------------------------- local data ------------------------------*/
 FILE *fp;
 int ch;
 register int i;
/* unsigned char temp_profile[100];*/
 unsigned char *profile_ptr;
 short rc=OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: get_profile");
#endif
 if (strcmp(prf,"") == 0)
   {
    if ((profile_ptr = (unsigned char *)getenv("THE")) == NULL)
      {
       if (file_exists(profile_pathname))
          profile_ptr = profile_pathname;
       else
         {
#ifdef TRACE
          trace_return();
#endif
          return(rc);
         }
      }
   }
 else
    profile_ptr = prf;

 if ((fp = fopen(profile_ptr,"r")) == NULL)
   {
#ifdef TRACE
    trace_return();
#endif
    return(rc);
   }
 memset(rec,' ',MAX_LINE_LENGTH);
 i = 0;
 while(1)
  {
   ch = fgetc(fp);
   if (feof(fp))
      break;
   if (ch == '\n')
     {
      rec[i] = '\0';
      rc = command_line(rec);
      if (rc == QUIT && number_of_views == 0)
         break;
      i = 0;
      memset(rec,' ',MAX_LINE_LENGTH);
      continue;
     }
   if (ch == '\r')
     {
      rec[i] = ch;
      i++;
      ch = fgetc(fp);
      if (feof(fp))
         break;
      if (ch == '\n')
        {
         --i;
         rec[i] = '\0';
         rc = command_line(rec);
         if (rc == QUIT && number_of_views == 0)
            break;
         i = 0;
         memset(rec,' ',MAX_LINE_LENGTH);
         continue;
        }
     }
   rec[i] = ch;
   i++;
  }
 fclose(fp);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/***********************************************************************/
#ifdef PROTO
short defaults_for_first_file(void)
#else
short defaults_for_first_file()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: defaults_for_first_file");
#endif
/*---------------------------------------------------------------------*/
/* Add to view linked list.                                            */
/*---------------------------------------------------------------------*/
 if ((CURRENT_VIEW = vll_add(vd_first,vd_current,sizeof(VIEW_DETAILS)))
                   == (VIEW_DETAILS *)NULL)
   {
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
 if (vd_first == (VIEW_DETAILS *)NULL)
    vd_first = CURRENT_VIEW;

 CURRENT_VIEW->current_row = 6;
 CURRENT_VIEW->cmd_line = CMD_LINEx;
 CURRENT_VIEW->error_row = ERROR_ROWx;
 CURRENT_VIEW->tab_row = TAB_ROWx;
 CURRENT_VIEW->tab_on = TAB_ONx;
 CURRENT_VIEW->scale_row = SCALE_ROWx;
 CURRENT_VIEW->scale_on = SCALE_ONx;
 CURRENT_VIEW->focus_line = CURRENT_ROW_POSx;
 CURRENT_VIEW->current_line = CURRENT_ROW_POSx;
 CURRENT_VIEW->stay = STAYx;
 CURRENT_VIEW->tabs = TABSx;
 CURRENT_VIEW->case_enter = CASE_Ex;
 CURRENT_VIEW->case_locate = CASE_Lx;
 CURRENT_VIEW->case_change = CASE_Cx;
 CURRENT_VIEW->prefix_on = PRE_ONx;
 CURRENT_VIEW->prefix_left = PRE_LEFTx;
 CURRENT_VIEW->verify_start = VER_STAx;
 CURRENT_VIEW->verify_col = VER_COLx;
 CURRENT_VIEW->verify_end = VER_ENDx;
 CURRENT_VIEW->zone_start = ZON_STAx;
 CURRENT_VIEW->zone_end = ZON_ENDx;
 CURRENT_VIEW->mark_start_line = (-1L);
 CURRENT_VIEW->mark_end_line = (-1L);
 for (i=0;i<VIEW_WINDOWS;i++)
     CURRENT_VIEW->win[i] = (WINDOW *)NULL;

 CURRENT_FILE = (FILE_DETAILS *)NULL;

 CURRENT_SCREEN.screen_view = CURRENT_VIEW;

 number_of_views++;

#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/***********************************************************************/
#ifdef PROTO
short defaults_for_other_files(void)
#else
short defaults_for_other_files()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: defaults_for_other_files");
#endif
 if ((CURRENT_VIEW = vll_add(vd_first,vd_current,sizeof(VIEW_DETAILS)))
                   == (VIEW_DETAILS *)NULL)
   {
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
 if (vd_first == (VIEW_DETAILS *)NULL)
    vd_first = CURRENT_VIEW;

 CURRENT_VIEW->command_row =     PREVIOUS_VIEW->command_row;
 CURRENT_VIEW->cmd_line =        PREVIOUS_VIEW->cmd_line;
 CURRENT_VIEW->error_row =       PREVIOUS_VIEW->error_row;
 CURRENT_VIEW->tab_row =         PREVIOUS_VIEW->tab_row;
 CURRENT_VIEW->tab_on =          PREVIOUS_VIEW->tab_on;
 CURRENT_VIEW->scale_row =       PREVIOUS_VIEW->scale_row;
 CURRENT_VIEW->scale_on =        PREVIOUS_VIEW->scale_on;
 CURRENT_VIEW->current_row =     PREVIOUS_VIEW->current_row;
 CURRENT_VIEW->current_line =    CURRENT_ROW_POSx;
 CURRENT_VIEW->focus_line =      CURRENT_ROW_POSx;
 CURRENT_VIEW->tabs =            TABSx;
 CURRENT_VIEW->stay =            STAYx;
 CURRENT_VIEW->case_enter =      CASE_Ex;
 CURRENT_VIEW->case_locate =     CASE_Lx;
 CURRENT_VIEW->case_change =     CASE_Cx;
 CURRENT_VIEW->prefix_on =       PREVIOUS_VIEW->prefix_on;
 CURRENT_VIEW->prefix_left =     PREVIOUS_VIEW->prefix_left;
 CURRENT_VIEW->verify_start =    VER_STAx;
 CURRENT_VIEW->verify_col =      VER_COLx;
 CURRENT_VIEW->verify_end =      VER_ENDx;
 CURRENT_VIEW->zone_start =      ZON_STAx;
 CURRENT_VIEW->zone_end =        ZON_ENDx;
 CURRENT_VIEW->mark_start_line = (-1L);
 CURRENT_VIEW->mark_end_line =   (-1L);

 for (i=0;i<VIEW_WINDOWS;i++)
     CURRENT_VIEW->win[i] = (WINDOW *)NULL;

 CURRENT_FILE = (FILE_DETAILS *)NULL;

 CURRENT_SCREEN.screen_view = CURRENT_VIEW;

 number_of_views++;

#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/***********************************************************************/
#ifdef PROTO
short default_file_attributes(void)
#else
short default_file_attributes()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: default_file_attributes");
#endif

 CURRENT_FILE->fmode =           FMODE;
 CURRENT_FILE->file_views =      1;
 CURRENT_FILE->first_line  =     NULL;
 CURRENT_FILE->autosave_alt =    0;
 CURRENT_FILE->autosave =        AUSx;
 CURRENT_FILE->save_alt =        0;
 CURRENT_FILE->eolout =          EOLx;
 CURRENT_FILE->tabsout_on =      TABO_ONx;
 CURRENT_FILE->tabsout_num =     TABO_Nx;

 CURRENT_FILE->fname =           (unsigned char *)NULL;
 CURRENT_FILE->fpath =           (unsigned char *)NULL;

#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/***********************************************************************/
#ifdef PROTO
void set_screen_defaults(void)
#else
void set_screen_defaults()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_screen_defaults");
#endif

 CURRENT_SCREEN.origin_x =         0;
 CURRENT_SCREEN.origin_y =         0;
 if (horizontal)
   {
    CURRENT_SCREEN.screen_rows =   (LINES-1) / display_screens;
    CURRENT_SCREEN.screen_cols =   COLS;
   }
 else
   {
    CURRENT_SCREEN.screen_rows =   (LINES-1);
    CURRENT_SCREEN.screen_cols =   (COLS / display_screens)-((display_screens == 1) ? 0 : 1); /**/
   }
 if (display_screens == 1)
   {
    OTHER_SCREEN.origin_x =        0;
    OTHER_SCREEN.origin_y =        0;
    OTHER_SCREEN.screen_rows =     (LINES-1) / display_screens;
    OTHER_SCREEN.screen_cols =     COLS;
   }
 else
   {
    if (horizontal)
      {
       OTHER_SCREEN.origin_x =     0;
       OTHER_SCREEN.origin_y =     CURRENT_SCREEN.screen_rows;
       OTHER_SCREEN.screen_rows =  (LINES-1) - ((LINES-1) / display_screens);
       OTHER_SCREEN.screen_cols =  COLS;
      }
    else
      {
       OTHER_SCREEN.origin_x =     CURRENT_SCREEN.screen_cols+((display_screens == 1) ? 0 : 2); /**/
       OTHER_SCREEN.origin_y =     0;;
       OTHER_SCREEN.screen_rows =  (LINES-1);
       OTHER_SCREEN.screen_cols =  COLS - CURRENT_SCREEN.screen_cols-((display_screens == 1) ? 0 : 2);/**/
      }
   }

#ifdef TRACE
 trace_return();
#endif
 return;
}
