/***********************************************************************/
/* COMM5.C - Commands T-Z                                              */
/* This file contains all commands that can be assigned to function    */
/* keys or typed on the command line.                                  */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>
#include <stdlib.h>

#include "the.h"

/*#define DEBUG 1*/

/*-------------------------- external data ----------------------------*/
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char current_file;         /* pointer to current file */
extern WINDOW *foot,*error_window;
extern char error_on_screen;
extern unsigned char *rec;
extern unsigned short rec_len;
extern unsigned char mode_insert;        /* defines insert mode toggle */
extern unsigned char in_profile;    /* indicates if processing profile */
/*---------------------- function definitions -------------------------*/
#ifdef PROTO
void split_command(unsigned char *,unsigned char *,unsigned char *);
int param_split(unsigned char *,unsigned char *[],int );
long valid_target(unsigned char *);
int get_row_for_focus_line(int,long,long);
#else
void split_command();
int param_split();
long valid_target();
int get_row_for_focus_line();
#endif
/*man-start*********************************************************************
COMMAND
     tabcmd - switch windows (main/prefix command) for the current file

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The TABCMD command switches the focus of the editor from the
     main or prefix windows to the command line and vice versa, depending
     on which window is currently active.

COMPATIBILITY
     Compatible.

SEE ALSO
     tabpre

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Tabcmd(unsigned char *params)
#else
int Tabcmd(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned char last_win;
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Tabcmd");
#endif
 last_win = CURRENT_VIEW->previous_window;
 CURRENT_VIEW->previous_window =
              CURRENT_VIEW->current_window;
 if (CURRENT_VIEW->current_window != WINDOW_COMMAND)
    {
     post_process_line(CURRENT_VIEW->focus_line);
     CURRENT_VIEW->current_window = WINDOW_COMMAND;
     wmove(CURRENT_WINDOW,0,0);
    }
 else
    {
     pre_process_line(CURRENT_VIEW->focus_line);
     CURRENT_VIEW->current_window = last_win;
     getyx(CURRENT_WINDOW,y,x);
     y = get_row_for_focus_line(CURRENT_VIEW->current_row,
                                CURRENT_VIEW->focus_line,
                                CURRENT_VIEW->current_line);
     wmove(CURRENT_WINDOW,y,x);
    }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     tabkey - set characteristics of the tab key

SYNTAX
     TABKey Insert|Overstrike|Both Tab|Character

DESCRIPTION
     The TABKEY sets the action to be taken when the tab key is hit.
     Depending on the insert mode, the tab key will either display
     a raw tab character or will move to the next tab column.

COMPATIBILITY
     New function.

DEFAULT
     INSERT CHARACTER, OVERSTRIKE TAB

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Tabkey(unsigned char *params)
#else
int Tabkey(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- extern data -----------------------------*/
/*--------------------------- local data ------------------------------*/
#define TKY_PARAMS  2
 unsigned char *word[TKY_PARAMS+1];
 char parm[TKY_PARAMS];
 register int i;
 unsigned short num_params;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Tabkey");
#endif
 num_params = param_split(params,word,TKY_PARAMS);

 for (i=0;i<TKY_PARAMS;i++)
     parm[i] = UNDEFINED_OPERAND;
 if (equal("insert",word[0],1))
    parm[0] = 'I';
 if (equal("overwrite",word[0],1))
    parm[0] = 'O';
 if (equal("both",word[0],1))
    parm[0] = 'B';
 if (parm[0] == UNDEFINED_OPERAND)
   {
    display_error(1,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
 if (equal("tab",word[1],1))
    parm[1] = 'T';
 if (equal("character",word[1],1))
    parm[1] = 'C';
 if (parm[1] == UNDEFINED_OPERAND)
   {
    display_error(1,word[1]);
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
 switch(parm[0])
    {
     case 'B':
              tabkey_insert = parm[1];
              tabkey_overwrite = parm[1];
              break;
     case 'I':
              tabkey_insert = parm[1];
              break;
     case 'O':
              tabkey_overwrite = parm[1];
              break;
    }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     tabpre - switch windows (main prefix) for the current file

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The TABPRE command switches the focus of the editor from the
     main window to the prefix window and vice versa, depending
     on which window is currently active.

COMPATIBILITY
     Compatible.

SEE ALSO
     tabcmd

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Tabpre(unsigned char *params)
#else
int Tabpre(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned char last_win;
 unsigned short y,x;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Tabpre");
#endif
 if (CURRENT_VIEW->current_window == WINDOW_COMMAND)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }

 getyx(CURRENT_WINDOW,y,x);

 last_win = CURRENT_VIEW->previous_window;
 CURRENT_VIEW->previous_window =
              CURRENT_VIEW->current_window;
 if (CURRENT_VIEW->current_window == WINDOW_MAIN)
   {
    post_process_line(CURRENT_VIEW->focus_line);
    CURRENT_VIEW->current_window = WINDOW_PREFIX;
   }
 else
   {
    pre_process_line(CURRENT_VIEW->focus_line);
    CURRENT_VIEW->current_window = WINDOW_MAIN;
   }
 wmove(CURRENT_WINDOW,y,0);
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     tabs - set tab length for TAB key

SYNTAX
     TABS INCR n

DESCRIPTION
     The TABS command determines the position of tab columns when the
     TAB key is pressed.

COMPATIBILITY
     Does not support specification of actual tab columns.

SEE ALSO
     sos_tabf

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Tabs(unsigned char *params)
#else
int Tabs(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- extern data -----------------------------*/
extern unsigned char TABSx;
/*--------------------------- local data ------------------------------*/
#define TABS_PARAMS  2
 unsigned char *word[TABS_PARAMS+1];
 char parm[TABS_PARAMS];
 register int i;
 unsigned short num_params;
 unsigned short x,y;
 char pre_col;
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Tabs");
#endif
 num_params = param_split(params,word,TABS_PARAMS);
 for (i=0;i<TABS_PARAMS;i++)
     parm[0] = UNDEFINED_OPERAND;
 if (equal("incr",word[0],2))
    parm[0] = TRUE;
 if (parm[0] == UNDEFINED_OPERAND)
   {
    display_error(1,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (!valid_positive_integer(word[1]))
   {
    display_error(4,word[1]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 parm[1] = (char)atoi(word[1]);
 if (parm[1] < 1)
   {
    display_error(5,word[1]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (parm[1] > 32)
   {
    display_error(6,word[1]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (in_profile)
    TABSx = parm[1];
 else
    CURRENT_VIEW->tabs = parm[1];
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     tabsin - set tab processing on file input

SYNTAX
     TABSIn ON|OFF [n]

DESCRIPTION
     The TABSIN command determines if tabs read from a file are to be
     expanded to spaces and if so how many spaces.

COMPATIBILITY
     Does not support TABQUOTE option.

SEE ALSO
     tabsout

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Tabsin(unsigned char *params)
#else
int Tabsin(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*---------------------------------------------------------------------*/
/* The settings for TABSIN is a global value, despite it supposedly    */
/* being a file level value.                                           */
/*---------------------------------------------------------------------*/
/*--------------------------- extern data -----------------------------*/
extern unsigned char TABI_ONx;
extern unsigned char TABI_Nx;
/*--------------------------- local data ------------------------------*/
#define TABI_PARAMS  2
 unsigned char *word[TABI_PARAMS+1];
 char parm[TABI_PARAMS];
 register int i;
 unsigned short num_params;
 unsigned short x,y;
 char pre_col;
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Tabsin");
#endif
 num_params = param_split(params,word,TABI_PARAMS);
 for (i=0;i<TABI_PARAMS;i++)
     parm[0] = UNDEFINED_OPERAND;
 if (equal("on",word[0],2))
    parm[0] = TRUE;
 if (equal("off",word[0],3))
    parm[0] = FALSE;
 if (parm[0] == UNDEFINED_OPERAND)
   {
    display_error(1,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 switch(parm[0])
    {
     case TRUE:
         if (!valid_positive_integer(word[1]))
           {
            display_error(4,word[1]);
#ifdef TRACE
            trace_return();
#endif
            return(OK);
           }
         parm[1] = (char)atoi(word[1]);
         break;
     case FALSE:
         if (strcmp(word[1],"") != 0)
           {
            display_error(1,word[1]);
#ifdef TRACE
            trace_return();
#endif
            return(OK);
           }
         break;
    }
 if (parm[0])
   {
    if (parm[1] < 1)
      {
       display_error(5,word[1]);
#ifdef TRACE
       trace_return();
#endif
       return(OK);
      }
    if (parm[1] > 32)
      {
       display_error(6,word[1]);
#ifdef TRACE
       trace_return();
#endif
       return(OK);
      }
   }
 TABI_ONx = parm[0];
 TABI_Nx = parm[1];

#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     tabsout - set tab processing on file output

SYNTAX
     TABSOut ON|OFF [n]

DESCRIPTION
     The TABSOUT command determines if spaces written to a file are to be
     compressed to tabs and if so how many spaces.

COMPATIBILITY
     Compatible.

SEE ALSO
     tabsin

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Tabsout(unsigned char *params)
#else
int Tabsout(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- extern data -----------------------------*/
extern unsigned char TABO_ONx;
extern unsigned char TABO_Nx;
/*--------------------------- local data ------------------------------*/
#define TABO_PARAMS  2
 unsigned char *word[TABO_PARAMS+1];
 char parm[TABO_PARAMS];
 register int i;
 unsigned short num_params;
 unsigned short x,y;
 char pre_col;
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Tabsout");
#endif
 num_params = param_split(params,word,TABO_PARAMS);
 for (i=0;i<TABO_PARAMS;i++)
     parm[0] = UNDEFINED_OPERAND;
 if (equal("on",word[0],2))
    parm[0] = TRUE;
 if (equal("off",word[0],3))
    parm[0] = FALSE;
 if (parm[0] == UNDEFINED_OPERAND)
   {
    display_error(1,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 switch(parm[0])
    {
     case TRUE:
         if (!valid_positive_integer(word[1]))
           {
            display_error(4,word[1]);
#ifdef TRACE
            trace_return();
#endif
            return(OK);
           }
         parm[1] = (char)atoi(word[1]);
         break;
     case FALSE:
         if (strcmp(word[1],"") != 0)
            {
             display_error(1,word[1]);
#ifdef TRACE
            trace_return();
#endif
             return(OK);
            }
         break;
    }
 if (parm[0])
   {
    if (parm[1] < 1)
      {
       display_error(5,word[1]);
#ifdef TRACE
       trace_return();
#endif
       return(OK);
      }
    if (parm[1] > 32)
      {
       display_error(6,word[1]);
#ifdef TRACE
       trace_return();
#endif
       return(OK);
      }
   }
 if (in_profile)
   {
    TABO_ONx = parm[0];
    TABO_Nx = parm[1];
   }
 else
   {
    CURRENT_FILE->tabsout_on = parm[0];
    CURRENT_FILE->tabsout_num = parm[1];
   }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     top - move to the top of the file

SYNTAX
     TOP

DESCRIPTION
     The TOP command moves to the very start of the current file.
     The "Top-of-file" line is set to the current_line.

     "TOP" is equivalent to "BACKWARD *".

COMPATIBILITY
     Compatible.

SEE ALSO
     backward,bottom

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Top(unsigned char *params)
#else
int Top(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Top");
#endif
 rc = Backward("*");
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     up - move backward in the file a number of lines

SYNTAX
     Up [target]

DESCRIPTION
     The UP command moves the current_line backwards the number of
     lines specified by the target. Negative targets move forwards
     through the file.

COMPATIBILITY
     Compatible.

SEE ALSO
     Next

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Up(unsigned char *params)
#else
int Up(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
#define UP_PARAMS  1
 unsigned char *word[UP_PARAMS+1];
 unsigned short num_params;
 long num_lines;
 unsigned short y,x;
 unsigned char cmd_line[10];
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Up");
#endif
 num_params = param_split(params,word,UP_PARAMS);
 if (num_params == 0)
   {
    num_params = 1;
    word[0] = (unsigned char *)"1";
   }
 if (num_params != 1)
   {
    display_error(1,word[1]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if ((num_lines = valid_target(word[0])) == TARGET_ERROR)
   {
    display_error(4,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }

 sprintf(cmd_line,"%-ld",num_lines*(-1));
 Next(cmd_line);
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     up_arrow - move the cursor up one line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The up_arrow command moves the cursor up one line in the main
     window. Scrolling of the window occurs if the cursor is on the first
     line of the window.

     When on the command line, this command moves backward through the
     list of previous command line commands or tabs to the last line of
     the main window depending on the value set by the function
     cmdarrows. (default is the former)

COMPATIBILITY
     Compatible.

SEE ALSO
     Down_arrow

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Up_arrow(unsigned char *params)
#else
int Up_arrow(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
extern unsigned char CMDARROWSTABx;
/*--------------------------- local data ------------------------------*/
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Up_arrow");
#endif
 switch(CURRENT_VIEW->current_window)
  {
   case WINDOW_MAIN:
   case WINDOW_PREFIX:
        getyx(CURRENT_WINDOW,y,x);
/*---------------------------------------------------------------------*/
/* If the cursor is on the first line of the file...                   */
/* ... and the first line of the file is on the current row, stay there.*/
/*---------------------------------------------------------------------*/
        if (CURRENT_VIEW->current_line == 0
        && y == CURRENT_VIEW->current_row)
           break;
/*---------------------------------------------------------------------*/
/* If the cursor is on the first line of the file...                   */
/* ... and the first line of the file is above the current row,        */
/* scroll the window down one line.                                    */
/*---------------------------------------------------------------------*/
        if (CURRENT_VIEW->current_line+y
            == CURRENT_VIEW->current_row)
           {
            CURRENT_VIEW->current_line--;
            show_page();
            wmove(CURRENT_WINDOW,y+1,x);
            break;
           }
/*---------------------------------------------------------------------*/
/* If on the top line of the window, scroll the window down 1 line.    */
/*---------------------------------------------------------------------*/
        if (y == 0)
           {
            CURRENT_VIEW->current_line--;
            post_process_line(CURRENT_VIEW->focus_line);
            CURRENT_VIEW->focus_line--;
            pre_process_line(CURRENT_VIEW->focus_line);
            show_page();
            wmove(CURRENT_WINDOW,y,x);
            break;
           }
/*---------------------------------------------------------------------*/
/* We are in the middle of the window, so just move the cursor up      */
/* 1 line.                                                             */
/*---------------------------------------------------------------------*/
        wmove(CURRENT_WINDOW,y-1,x);
        post_process_line(CURRENT_VIEW->focus_line);
        CURRENT_VIEW->focus_line--;
        pre_process_line(CURRENT_VIEW->focus_line);
        break;
   case WINDOW_COMMAND:
/*---------------------------------------------------------------------*/
/* Cycle backward through the command list or tab to last line.        */
/*---------------------------------------------------------------------*/
        if (CMDARROWSTABx)
          {
           getyx(CURRENT_WINDOW,y,x);
           if (CURRENT_VIEW->prefix_on != TRUE
           ||  CURRENT_VIEW->prefix_left != TRUE)
              x += 6;
           if (CURRENT_FILE->number_lines >= CURRENT_SCREEN.rows -
                                           CURRENT_VIEW->current_row +
                                           CURRENT_VIEW->current_line - 1)
             {
              CURRENT_VIEW->focus_line = CURRENT_SCREEN.rows -
                                        CURRENT_VIEW->current_row +
                                        CURRENT_VIEW->current_line - 1;
              y = CURRENT_SCREEN.rows -1;
             }
           else
             {
              CURRENT_VIEW->focus_line = CURRENT_FILE->number_lines + 1;
              y = get_row_for_focus_line(CURRENT_VIEW->current_row,
                                         CURRENT_VIEW->focus_line,
                                         CURRENT_VIEW->current_line);
             }
           pre_process_line(CURRENT_VIEW->focus_line);
           CURRENT_VIEW->current_window = WINDOW_MAIN;
           wmove(CURRENT_WINDOW,y,x);
          }
        else
           Retrieve("");
        break;
   default:
        display_error(2,"");
        break;
  }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     verify - set column display limits

SYNTAX
     Verify first [last]

DESCRIPTION
     The VERIFY command sets the column limits for the display of the
     current file. 'first' specifies the first column to be displayed
     and 'last' specifies the last column to be displayed.

     If no 'last' option is specified '*' is assumed.

COMPATIBILITY
     Does not implement HEX display nor multiple column pairs.

SEE ALSO
     Zone

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Verify(unsigned char *params)
#else
int Verify(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- extern data -----------------------------*/
 unsigned short VER_STAx;
 unsigned short VER_COLx;
 unsigned short VER_ENDx;
/*--------------------------- local data ------------------------------*/
#define VER_PARAMS  2
 unsigned char *word[VER_PARAMS+1];
 unsigned short num_params;
 long col1,col2;
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Verify");
#endif
/*---------------------------------------------------------------------*/
/* Validate the parameters that have been supplied. One or two         */
/* parameters can be supplied. The first parameter MUST be a positive  */
/* integer. The second can be a positive integer or '*'. If no second  */
/* parameter is supplied, '*' is assumed. The second parameter MUST be */
/* >= first parameter. '*' is regarded as the biggest number and is    */
/* literally MAX_LINE_LENGTH.                                          */
/*---------------------------------------------------------------------*/
 num_params = param_split(params,word,VER_PARAMS);
 if (num_params == 0)
   {
    display_error(3,"");
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (num_params > 2)
   {
    display_error(2,"");
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (valid_positive_integer(word[0]) == TARGET_ERROR)
   {
    display_error(4,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 col1 = atol(word[0]);
 if (num_params == 1)
     col2 = MAX_LINE_LENGTH;
 else
     if (strcmp(word[1],"*") == 0)
        col2 = MAX_LINE_LENGTH;
     else
        if (valid_positive_integer(word[1]) == TARGET_ERROR)
          {
           display_error(4,word[1]);
#ifdef TRACE
           trace_return();
#endif
           return(OK);
          }
        else
           col2 = atol(word[1]);

 if (col2 > MAX_LINE_LENGTH)
    col2 = MAX_LINE_LENGTH;
 if (col1 > col2)
   {
    display_error(6,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (in_profile)
   {
    VER_STAx = col1;
    VER_COLx = col1;
    VER_ENDx = col2;
   }
 else
   {
    CURRENT_VIEW->verify_start = col1;
    CURRENT_VIEW->verify_col = col1;
    CURRENT_VIEW->verify_end   = col2;
    getyx(CURRENT_WINDOW,y,x);
    show_page();
    if (CURRENT_VIEW->current_window != WINDOW_COMMAND)
       wmove(CURRENT_WINDOW,y,x);
   }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     zone - set column limits for editting

SYNTAX
     Zone first [last]

DESCRIPTION
     The ZONE command sets the column limits for various other editor
     commands, such as 'locate' and 'change'. It effectively restricts
     the editable (?) portion of the file to the specified columns.

     If no 'last' option is specified '*' is assumed.

COMPATIBILITY
     Compatible.

SEE ALSO
     Verify

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Zone(unsigned char *params)
#else
int Zone(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- extern data -----------------------------*/
 extern unsigned short ZON_STAx;
 extern unsigned short ZON_ENDx;
 extern unsigned char file_read; /* indicates if we have read the file */
/*--------------------------- local data ------------------------------*/
#define ZON_PARAMS  2
 unsigned char *word[ZON_PARAMS+1];
 unsigned short num_params;
 long col1,col2;
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Zone");
#endif
/*---------------------------------------------------------------------*/
/* Validate the parameters that have been supplied. One only           */
/* parameter MUST be supplied. The first parameter MUST be a positive  */
/* integer. The second can be a positive integer or '*'. If no second  */
/* parameter is supplied, ERROR.          The second parameter MUST be */
/* >= first parameter. '*' is regarded as the biggest number and is    */
/* literally MAX_LINE_LENGTH.                                          */
/*---------------------------------------------------------------------*/
 num_params = param_split(params,word,ZON_PARAMS);
 if (num_params < 2)
   {
    display_error(3,"");
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (num_params > 2)
   {
    display_error(2,"");
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (valid_positive_integer(word[0]) == TARGET_ERROR)
   {
    display_error(4,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 col1 = atol(word[0]);
 if (strcmp(word[1],"*") == 0)
    col2 = MAX_LINE_LENGTH;
 else
    if (valid_positive_integer(word[1]) == TARGET_ERROR)
      {
       display_error(4,word[1]);
#ifdef TRACE
       trace_return();
#endif
       return(OK);
      }
    else
       col2 = atol(word[1]);

 if (col2 > MAX_LINE_LENGTH)
    col2 = MAX_LINE_LENGTH;
 if (col1 > col2)
   {
    display_error(6,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (file_read)
   {
    CURRENT_VIEW->zone_start = col1;
    CURRENT_VIEW->zone_end   = col2;
   }
 else
   {
    ZON_STAx = col1;
    ZON_ENDx = col2;
   }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
