/***********************************************************************/
/* ERROR.C - Function to display error messages.                       */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 * 
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 * 
 * 
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed 
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>
#include <stdlib.h>

#include "the.h"

/*#define TRACE*/
/*-------------------------- external data ----------------------------*/
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_file;                   /* pointer to current file */
extern WINDOW *foot,*error_window;
extern char error_on_screen;
extern unsigned char in_profile;    /* indicates if processing profile */
/***********************************************************************/
#ifdef PROTO
void display_error(unsigned short err_num,unsigned char *mess)
#else
void display_error(err_num,mess)
unsigned short err_num;
unsigned char *mess;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/

static char error_message[][80] =
{
 "",
 "Error 0001: Invalid operand: ",
 "Error 0002: Too many operands",
 "Error 0003: Too few operands",
 "Error 0004: Invalid number: ",
 "Error 0005: Numeric operand too small",
 "Error 0006: Numeric operand too large",
 "Error 0007: ",
 "Error 0008: Invalid or protected file",
 "Error 0009: File not found",
 "Error 0010: Path not found",
 "Error 0011: ",
 "Error 0012: ",
 "Error 0013: Invalid key name:",
 "Error 0014: ",
 "Error 0015: ",
 "Error 0016: ",
 "Error 0017: Target not found",
 "Error 0018: ",
 "Error 0019: ",
 "Error 0020: ",
 "Error 0021: Invalid command: ",
 "Error 0022: File has been changed - use QQUIT to really quit",
 "Error 0023: Help file not found",
 "Error 0024: ",
 "Error 0025: Invalid profile command: ",
 "Error 0026: ",
 "Error 0027: ",
 "Error 0028: ",
 "Error 0029: Cannot edit - non-text file:",
 "Error 0030: Memory shortage",
 "Error 0031: File already exists - use FFILE/SSAVE",
 "Error 0032: ",
 "Error 0033: ",
 "Error 0034: ",
 "Error 0035: ",
 "Error 0036: No lines changed",
 "Error 0037: Length of command and parameters exceeds 80",
 "Error 0038: Improper cursor position",
 "Error 0039: No remembered operand available",
 "Error 0040: ",
 "Error 0041: ",
 "Error 0042: ",
 "Error 0043: ",
 "Error 0044: No marked block",
 "Error 0045: ",
 "Error 0046: ",
 "Error 0047: ",
 "Error 0048: ",
 "Error 0049: ",
 "Error 0050: ",
 "Error 0051: ",
 "Error 0052: ",
 "Error 0053: ",
 "Error 0054: ",
 "Error 0055: ",
 "Error 0056: ",
 "Error 0057: ",
 "Error 0058: ",
 "Error 0059: ",
 "Error 0060: ",
 "Error 0061: ",
 "Error 0062: ",
 "Error 0063: ",
 "Error 0064: ",
 "Error 0065: ",
 "Error 0066: Invalid match position",
 "Error 0067: Invalid match character",
 "Error 0068: Matching character not found",
 "Error 0069: Invalid character",
 "Error 0070: ",
 "Error 0071: ",
 "Error 0072: ",
 "Error 0073: ",
 "Error 0074: ",
 "Error 0075: ",
 "Error 0076: ",
 "Error 0077: ",
 "Error 0078: ",
 "Error 0079: ",
 "Error 0080: ",
 "Error 0081: ",
 "Error 0082: ",
 "Error 0083: ",
 "Error 0084: ",
 "Error 0085: Too many files in the ring"
};
unsigned char save_line[80];
unsigned short error_location;
register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("error.c:   display_error");
#endif
 if (in_profile)
   {
    fprintf(stderr,"%s %s\n",error_message[err_num],mess);
#ifdef TRACE
    trace_return();
#endif
    return;
   }

 for (i=0;i<COLS;i++)
    mvwaddch(error_window,0,i,' ');
 wmove(error_window,0,0);
 wprintw(error_window,"%s %s",error_message[err_num],mess);
 wnoutrefresh(error_window);
 error_on_screen = YES;
#ifdef TRACE
 trace_return();
#endif
 return;
}
