/***********************************************************************/
/* SHOW.C - Functions involving displaying the data.                   */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "the.h"

/*#define TRACEE*/
/*-------------------------- external data ----------------------------*/
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first,*vd_mark;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char current_file;         /* pointer to current file */
extern char number_of_views;                        /* number of views */
extern char number_of_files;                   /* number of open files */
extern char display_screens;                      /* number of screens */
extern bool horizontal;
extern WINDOW *foot,*error_window;
extern char error_on_screen;
extern unsigned char *rec;
extern unsigned short rec_len;
extern unsigned char *cmd_rec;
extern unsigned short cmd_rec_len;
extern unsigned char mode_insert;        /* defines insert mode toggle */
extern unsigned char in_profile;    /* indicates if processing profile */
extern char file_disposition;
/*-------------------------- function definitions ---------------------*/
#ifdef PROTO
static LINE *show_line(unsigned short,LINE *,short,short);
void show_one_row(unsigned char *,unsigned short,unsigned short,LINE *);
void highlight_line(unsigned char,long);
void show_highlighted_lines(void);
#else
static LINE *show_line();
void show_one_row();
void highlight_line();
void show_highlighted_lines();
#endif
/***********************************************************************/
#ifdef PROTO
void show_heading(int key)
#else
void show_heading(key)
int key;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short y,x,fpath_len,fname_len,max_name;
 char buffer[60];
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_heading");
#endif
 for (i=0;i<CURRENT_SCREEN.screen_cols-1;i++)
     mvwaddch(CURRENT_WINDOW_IDLINE,0,i,' ');
 getyx(CURRENT_WINDOW,y,x);
 if (CURRENT_VIEW->current_window == WINDOW_COMMAND)
    y = (short)CURRENT_VIEW->current_line;
 else
    y = (short)CURRENT_VIEW->focus_line;
 if (display_screens != 1 && !horizontal)
   {
    sprintf(buffer,"L=%-.1d C=%-.1d S=%-.1d A=%d,%d",
                    y,x+1+CURRENT_VIEW->verify_col-1,
                    CURRENT_FILE->number_lines,
                    CURRENT_FILE->autosave_alt,
                    CURRENT_FILE->save_alt);
    max_name = (CURRENT_SCREEN.screen_cols-1) - strlen(buffer);
   }
 else
    max_name = (CURRENT_SCREEN.screen_cols-48);
 fpath_len = strlen(CURRENT_FILE->fpath);
 fname_len = strlen(CURRENT_FILE->fname);
 if (fpath_len + fname_len > max_name)
   {
    fpath_len = (fpath_len + fname_len + 3) - max_name;
    wmove(CURRENT_WINDOW_IDLINE,0,0);
    wprintw(CURRENT_WINDOW_IDLINE,"...%s%s",(CURRENT_FILE->fpath+fpath_len),CURRENT_FILE->fname);
   }
 else
  {
   wmove(CURRENT_WINDOW_IDLINE,0,0);
   wprintw(CURRENT_WINDOW_IDLINE,"%s%s",CURRENT_FILE->fpath,CURRENT_FILE->fname);
  }
 if (display_screens != 1 && !horizontal)
   {
    wmove(CURRENT_WINDOW_IDLINE,0,max_name+1);
    wprintw(CURRENT_WINDOW_IDLINE,"%-s",buffer);
   }
 else
   {
    wmove(CURRENT_WINDOW_IDLINE,0,34);
    wprintw(CURRENT_WINDOW_IDLINE,"Line=%-6.1d Col=%-5.1d",y,x+1+CURRENT_VIEW->verify_col-1);
    wmove(CURRENT_WINDOW_IDLINE,0,54);
    wprintw(CURRENT_WINDOW_IDLINE,"Size=%-6.1d",CURRENT_FILE->number_lines);
    wmove(CURRENT_WINDOW_IDLINE,0,66);
    wprintw(CURRENT_WINDOW_IDLINE,"Alt=          ");
    wmove(CURRENT_WINDOW_IDLINE,0,70);
    wprintw(CURRENT_WINDOW_IDLINE,"%d,%d",CURRENT_FILE->autosave_alt,
                             CURRENT_FILE->save_alt);
   }
 wnoutrefresh(CURRENT_WINDOW_IDLINE);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void show_footing(void)
#else
void show_footing()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short y,x;
int key;
WINDOW *w;
time_t timer;
struct tm *tblock;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_footing");
#endif
 w = CURRENT_WINDOW;

 if (CURRENT_VIEW->current_window == WINDOW_MAIN)
   {
    getyx(CURRENT_WINDOW,y,x);
    key = *(rec+CURRENT_VIEW->verify_col-1+x);
   }
 else
    key = (int)(winch(w) & A_CHARTEXT);

 wmove(foot,0,62);
 if (key == '\0')
    wprintw(foot,"' '=00/000 ");
 else
    wprintw(foot,"'%1.1c'=%2.2X/%3.3d ",key,key,key);

 wmove(foot,0,76);
 if (mode_insert)
    wprintw(foot,"Ins");
 else
    wprintw(foot,"   ");

 wmove(foot,0,74);
#ifdef COLOR_CURSES
 if (has_colors() == TRUE)
    wprintw(foot,"C");
 else
    wprintw(foot,"m");
#else
 wprintw(foot,"M");
#endif

 wmove(foot,0,11);
 wprintw(foot,"Files=%d ",number_of_files);
/*#define TRACEE*/
#ifdef TRACEE
 wmove(foot,0,20);
 wprintw(foot,"            ");
 wmove(foot,0,20);
 wprintw(foot,"C<%ld>F<%ld>",CURRENT_VIEW->current_line,CURRENT_VIEW->focus_line);
#endif
/*---------------------------------------------------------------------*/
/* Get the current time, and display it.                               */
/*---------------------------------------------------------------------*/
 timer = time(NULL);
 tblock = localtime(&timer);
 wmove(foot,0,54);

 wprintw(foot,"%2d:%02.2d%s",
        (tblock->tm_hour > 12) ? (tblock->tm_hour-12) : (tblock->tm_hour),
         tblock->tm_min,
        (tblock->tm_hour >= 12) ? ("pm") : ("am"));

 wnoutrefresh(foot);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void show_page(void)
#else
void show_page()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i,row;
 LINE *curr,*save_curr;
 short cline,crow;
 unsigned short x,y;
 crow = CURRENT_VIEW->current_row;
 cline = CURRENT_VIEW->current_line;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_page");
#endif
 if (in_profile)
   {
#ifdef TRACE
    trace_return();
#endif
    return;
   }

 save_curr = curr = ll_find(CURRENT_FILE->first_line,(long)cline);
 getyx(CURRENT_WINDOW_MAIN,y,x);
/*---------------------------------------------------------------------*/
/* Display the file contents from the current line to the bottom of the*/
/* window.                                                             */
/*---------------------------------------------------------------------*/
 for (i=0,row=crow;row<CURRENT_SCREEN.rows;row++,i++)
      curr = show_line(YES,curr,row,i);
/*---------------------------------------------------------------------*/
/* Display the file contents from the current line to the top of the   */
/* window.                                                             */
/*---------------------------------------------------------------------*/
 curr = save_curr->prev;
 for (i=(-1),row=crow-1;row>-1;row--,i--)
      curr = show_line(NO,curr,row,i);

/*---------------------------------------------------------------------*/
/* Display any highlighted lines if there are any to display.          */
/*---------------------------------------------------------------------*/
 if (MARK_VIEW != (VIEW_DETAILS *)NULL)
    show_highlighted_lines();
/*---------------------------------------------------------------------*/
/* Highlight the current line. If the current line is inside the marked*/
/* block, use a different colour. If the current line is the top or    */
/* bottom lines, use another colour again.                             */
/*---------------------------------------------------------------------*/
 if (MARK_VIEW == CURRENT_VIEW
 &&  CURRENT_VIEW->current_line >= CURRENT_VIEW->mark_start_line
 &&  CURRENT_VIEW->current_line <= CURRENT_VIEW->mark_end_line)
     highlight_line(CURRENT_VIEW->current_row,colour[ATTR_CBLOCK]);
 else
     if (CURRENT_VIEW->current_line == 0L
     ||  CURRENT_VIEW->current_line == CURRENT_FILE->number_lines + 1L)
        highlight_line(CURRENT_VIEW->current_row,colour[ATTR_CTOFEOF]);
     else
        highlight_line(CURRENT_VIEW->current_row,colour[ATTR_CURLINE]);

 wrefresh(CURRENT_WINDOW_MAIN);
 if (CURRENT_VIEW->prefix_on)
     wrefresh(CURRENT_WINDOW_PREFIX);

 wmove(CURRENT_WINDOW_MAIN,y,x);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
static LINE *show_line(unsigned short going_down,LINE *curr_line,
                         short row,short i)
#else
static LINE *show_line(going_down,curr_line,row,i)
unsigned short going_down;
LINE *curr_line;
short row;
short i;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short cline,y;
 LINE *curr;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_line");
#endif
 curr = curr_line;
 cline = CURRENT_VIEW->current_line;

 if (curr == NULL)
    {
     wmove(CURRENT_WINDOW_MAIN,row,0);
     wclrtoeol(CURRENT_WINDOW_MAIN);
     if (CURRENT_VIEW->prefix_on) /* display prefix if on */
       {
        wmove(CURRENT_WINDOW_PREFIX,row,0);
        wclrtoeol(CURRENT_WINDOW_PREFIX);
       }
    }
 else
    {
/*---------------------------------------------------------------------*/
/* Determine the row that is the focus line.                           */
/*---------------------------------------------------------------------*/
     y = get_row_for_focus_line(CURRENT_VIEW->current_row,
                               CURRENT_VIEW->focus_line,
                               CURRENT_VIEW->current_line);
/*---------------------------------------------------------------------*/
/* If the current row to be displayed is the focus line, display       */
/* the working area, rec and rec_len instead of the entry in the LL.   */
/*---------------------------------------------------------------------*/
     if (row == y)
        show_one_row(rec,rec_len,row,curr);
     else
        show_one_row(curr->line,curr->length,row,curr);
/*---------------------------------------------------------------------*/
/* If the prefix area is ON display it.                                */
/*---------------------------------------------------------------------*/
     if (CURRENT_VIEW->prefix_on)
       {
        wmove(CURRENT_WINDOW_PREFIX,row,0);
        wprintw(CURRENT_WINDOW_PREFIX,"%6.6d",cline+i);
       }
     if (going_down)
        curr = curr->next;
     else
        curr = curr->prev;
    }
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef PROTO
void show_one_row(unsigned char *line,unsigned short length,
                  unsigned short row,LINE *curr)
#else
void show_one_row(line,length,row,curr)
unsigned char *line;
unsigned short length,row;
LINE *curr;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short col1,col2;
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_one_row");
#endif
 col1 = CURRENT_VIEW->verify_col - 1;
 col2 = min(length-1,CURRENT_VIEW->verify_end-1);
/*---------------------------------------------------------------------*/
/* If we are displaying the top or bottom line marker, then force the  */
/* function to display the beginning of the line and to display the    */
/* whole line when VERIFY is in effect.                                */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL || curr->next == NULL)
   {
    col1 = 0;
    col2 = curr->length-1;
    wattrset(CURRENT_WINDOW_MAIN,colour[ATTR_TOFEOF]);
   }
/*---------------------------------------------------------------------*/
/* If the first column to be displayed is after the length of the line */
/* then just clear to end of line and exit.                            */
/*---------------------------------------------------------------------*/
 if (col1 >= length)
   {
     wmove(CURRENT_WINDOW_MAIN,row,0);
     wclrtoeol(CURRENT_WINDOW_MAIN);
     wattrset(CURRENT_WINDOW_MAIN,colour[ATTR_FILEAREA]);
#ifdef TRACE
     trace_return();
#endif
     return;
   }
 for (i=0;i<CURRENT_SCREEN.cols;i++)
     {
      if (i+col1 > col2)
        {
         wmove(CURRENT_WINDOW_MAIN,row,i);
         wclrtoeol(CURRENT_WINDOW_MAIN);
         break;
        }
      else
        {
         wmove(CURRENT_WINDOW_MAIN,row,i);
         put_char(CURRENT_WINDOW_MAIN,*(line+i+col1),ADDCHAR);
        }
     }
 wattrset(CURRENT_WINDOW_MAIN,colour[ATTR_FILEAREA]);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void highlight_line(unsigned char line,long attrib)
#else
void highlight_line(line,attrib)
unsigned char line;
long attrib;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
 unsigned char ch;
 WINDOW *w;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    highlight_line");
#endif
 wmove(CURRENT_WINDOW_MAIN,line,0);
 wattrset(CURRENT_WINDOW_MAIN,attrib);
 for (i=0;i<CURRENT_SCREEN.cols;i++)
    {
     w = CURRENT_WINDOW_MAIN;
     ch = (unsigned char)winch(w) & A_CHARTEXT;
     wmove(CURRENT_WINDOW_MAIN,line,i);
     put_char(CURRENT_WINDOW_MAIN,ch,ADDCHAR);
    }
 wattrset(CURRENT_WINDOW_MAIN,colour[ATTR_FILEAREA]);
/* touchline(CURRENT_WINDOW_MAIN,line,1);*/
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void show_highlighted_lines(void)
#else
void show_highlighted_lines()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
 short num_rows,top_row;
 long top_line,bottom_line;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    show_highlighted_lines");
#endif
 top_line = max(CURRENT_VIEW->mark_start_line,
                CURRENT_VIEW->current_line-(long)CURRENT_VIEW->current_row);
 bottom_line = min(CURRENT_VIEW->mark_end_line,
                   CURRENT_VIEW->current_line-(long)CURRENT_VIEW->current_row+(long)CURRENT_SCREEN.rows);
 top_row = get_row_for_focus_line(CURRENT_VIEW->current_row,
                                  top_line,
                                  CURRENT_VIEW->current_line);
 num_rows = (short)(bottom_line - top_line + 1);
 for (i=0;i<num_rows;i++)
    if (MARK_VIEW == CURRENT_VIEW)
       highlight_line((unsigned char)(i+top_row),colour[ATTR_BLOCK]);
    else
       highlight_line((unsigned char)(i+top_row),colour[ATTR_FILEAREA]);
 if (MARK_VIEW != CURRENT_VIEW)
   {
    CURRENT_VIEW->mark_start_line = CURRENT_VIEW->mark_end_line = (-1L);
    touchline(CURRENT_WINDOW_MAIN,top_row,num_rows);
   }
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void redraw_window(WINDOW *win)
#else
void redraw_window(win)
WINDOW *win;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i,j;
 int key;
 short y,x;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    redraw_window");
#endif
 getyx(win,y,x);
 for (i=0;i<getmaxx(win);i++)
     for (j=0;j<getmaxy(win);j++)
        {
         wmove(win,j,i);
         key = (int)(winch(win) & A_CHARTEXT);
         waddch(win,key);
        }
 wmove(win,y,x);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void repaint_screen(void)
#else
void repaint_screen()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short y,x;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("show.c:    repaint_screen");
#endif

 getyx(CURRENT_WINDOW,y,x);
 y = get_row_for_focus_line(CURRENT_VIEW->current_row,
                            CURRENT_VIEW->focus_line,
                            CURRENT_VIEW->current_line);
 if (x > CURRENT_SCREEN.cols)
    x = 0;
 pre_process_line(CURRENT_VIEW->focus_line);
 show_page();
 cleanup_command_line();
 show_heading((int)0);
 wmove(CURRENT_WINDOW,y,x);

#ifdef TRACE
 trace_return();
#endif
 return;
}
