/***********************************************************************/
/* NONANSI.C -                                                         */
/* This file contains all calls to non-ansi conforming routines.       */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>
#include <stdlib.h>

#include "the.h"

#ifdef UNIX
#include <pwd.h>
#endif

/*#define DEBUG 1*/

#ifdef DOS
#include <dos.h>
#include <bios.h>
union REGS regs;
#endif

/*-------------------------- external data ----------------------------*/
extern unsigned char curr_path[MAX_FILE_NAME+1] ;
extern unsigned char sp_path[MAX_FILE_NAME+1] ;
extern unsigned char sp_fname[MAX_FILE_NAME+1] ;
extern unsigned char dir_path[MAX_FILE_NAME+1] ;   /* for dir and ls commands */
extern char file_disposition;
extern struct stat stat_buf;
/*---------------------- function definitions -------------------------*/
#ifdef DOS
char get_mode(void);
#endif
/***********************************************************************/
#ifdef PROTO
int file_readable(char *filename)
#else
int file_readable(filename)
char *filename;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("nonansi.c :file_readable");
#endif
 if (!file_exists(filename))
   {
#ifdef TRACE
    trace_return();
#endif
    return(YES);
   }
 if (access(filename,R_OK) == (-1))
   {
#ifdef TRACE
    trace_return();
#endif
    return(NO);
   }
#ifdef TRACE
    trace_return();
#endif
 return(YES);
}
/***********************************************************************/
#ifdef PROTO
int file_writable(char *filename)
#else
int file_writable(filename)
char *filename;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("nonansi.c :file_writable");
#endif
 if (!file_exists(filename))
   {
#ifdef TRACE
    trace_return();
#endif
    return(YES);
   }
 if (access(filename,W_OK) == (-1))
   {
#ifdef TRACE
    trace_return();
#endif
    return(NO);
   }
#ifdef TRACE
 trace_return();
#endif
 return(YES);
}
/***********************************************************************/
#ifdef PROTO
int file_exists(char *filename)
#else
int file_exists(filename)
char *filename;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("nonansi.c :file_exists");
#endif
 if (access(filename,F_OK) == (-1))
   {
#ifdef TRACE
    trace_return();
#endif
    return(NO);
   }
#ifdef TRACE
 trace_return();
#endif
 return(YES);
}
/***********************************************************************/
#ifdef PROTO
int remove_file(char *filename)
#else
int remove_file(filename)
char *filename;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("nonansi.c :remove_file");
#endif
#ifdef VMS
 if (delete(filename) == (-1))
#else
 if (unlink(filename) == (-1))
#endif
   {
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/***********************************************************************/
#ifdef PROTO
short splitpath(unsigned char *filename)
#else
short splitpath(filename)
unsigned char *filename;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short len;
 char work_filename[MAX_FILE_NAME+1] ;
#if defined(DOS) || defined(OS2)
 int new_dos_disk=0,current_dos_disk=0;        /* 1 - A,2 - B... */
 int temp_disk=0;
#ifdef OS2
 ULONG logical_os2_drives=0L;
#endif
#endif
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("nonansi.c :splitpath");
#endif
 strcpy(sp_path,"");
 strcpy(sp_fname,"");
 strcpy(work_filename,filename);
/*---------------------------------------------------------------------*/
/* If the supplied filename is empty, set the path = cwd and filename  */
/* equal to blank.                                                     */
/*---------------------------------------------------------------------*/
 if (strcmp(filename,"") == 0)
   {
    getcwd(sp_path,MAX_FILE_NAME);
    strcpy(sp_fname,"");
   }
/*---------------------------------------------------------------------*/
/* For DOS, get current drive and determine if the filename contains a */
/* disk drive specification.                                           */
/*---------------------------------------------------------------------*/
#ifdef DOS
 new_dos_disk = 0;       /* by default, no drive specified in filename */
#ifdef TC
 current_dos_disk = getdisk() + 1;
#else
 _dos_getdrive(&current_dos_disk);
#endif
#endif

#ifdef OS2
 new_dos_disk = 0;       /* by default, no drive specified in filename */
 DosQCurDisk(&current_dos_disk,&logical_os2_drives);
#endif

#if defined(DOS) || defined(OS2)
 if (*(filename+1) == ':')/* we assume this means a drive secification */
   {
    new_dos_disk = (toupper(*(filename)) - 'A') + 1;
    strcpy(work_filename,(filename+2));
   }
#endif

/*---------------------------------------------------------------------*/
/* Check if the first character is tilde; translate HOME env variable  */
/* if there is one. Obviously only applicable to UNIX.                 */
/*---------------------------------------------------------------------*/
#ifdef UNIX
 if (*(work_filename) == '~')
   {
    if (*(work_filename+1) == SLASH)
      {
       strcpy(work_filename,(unsigned char *)getenv("HOME"));
       strcat(work_filename,(filename+1));
      }
    else
      {
       struct passwd *pwd;

       strcpy(sp_path,filename+1);
       if ((len = strzeq(sp_path,SLASH)) != (-1))
          sp_path[len] = '\0';
       if ((pwd = getpwnam(sp_path)) == NULL)
          return(ERROR);
       strcpy(work_filename,pwd->pw_dir);
       if (len != (-1))
          strcat(work_filename,(filename+1+len));
      }
   }
#endif
/*---------------------------------------------------------------------*/
/* For DOS, check if the a disk was specified, and if so change to the */
/* specified drive.                                                    */
/*---------------------------------------------------------------------*/
#if defined(DOS) || defined(OS2)
 if (new_dos_disk != 0
 &&  new_dos_disk != current_dos_disk)
   {
#ifdef DOS
#ifdef TC
    setdisk((int)(new_dos_disk-1));
    temp_disk = getdisk()+1;
#else
    _dos_setdrive(new_dos_disk,&temp_disk);
    _dos_getdrive(&temp_disk);
#endif
#endif

#ifdef OS2
    DosSelectDisk(new_dos_disk);
    DosQCurDisk(&temp_disk,&logical_os2_drives);
#endif
    if (temp_disk != new_dos_disk)  /* invalid drive */
      {
#ifdef TRACE
       trace_return();
#endif
       return (ERROR);
      }
   }
#endif
/*---------------------------------------------------------------------*/
/* First determine if the supplied filename is a directory.            */
/*---------------------------------------------------------------------*/
 if ((stat(work_filename,&stat_buf) == 0)
 &&  (stat_buf.st_mode & S_IFMT) == S_IFDIR)
   {
    strcpy(sp_path,work_filename);
    strcpy(sp_fname,"");
   }
 else          /* here if the file doesn't exist or is not a directory */
   {
    len = strzreveq(work_filename,SLASH);
    switch(len)
      {
       case (-1):
            getcwd(sp_path,MAX_FILE_NAME);
            strcpy(sp_fname,work_filename);
            break;
       case 0:
            strcpy(sp_path,work_filename);
            sp_path[1] = '\0';
            strcpy(sp_fname,work_filename+1+len);
            break;
      default:
            strcpy(sp_path,work_filename);
            sp_path[len] = '\0';
            strcpy(sp_fname,work_filename+1+len);
            break;
     }
   }
/*---------------------------------------------------------------------*/
/* Remove any trailing slash from the path, except if it root dir      */
/* or for DOS and OS/2 looks like C:\                                  */
/*---------------------------------------------------------------------*/
#ifndef VMS
#if defined(DOS) || defined(OS2)
 len = strlen(sp_path);
 if (sp_path[len-1] == SLASH)
   {
    if ((strcmp(STR_SLASH,sp_path) == 0)
    ||  (sp_path[1] == ':' && sp_path[2] == SLASH && len == 3))
       ;
    else
       sp_path[len-1] = '\0';
   }
#else
 len = strlen(sp_path);
 if (strcmp(STR_SLASH,sp_path) != 0)
    if (sp_path[len-1] == SLASH)
       sp_path[len-1] = '\0';
#endif
#endif
/*---------------------------------------------------------------------*/
/* For DOS or OS/2 save the current directory of the new disk.         */
/*---------------------------------------------------------------------*/
#if defined(DOS) || defined(OS2)
 if (new_dos_disk != 0
 &&  new_dos_disk != current_dos_disk)
    getcwd(work_filename,MAX_FILE_NAME);
#endif
/*---------------------------------------------------------------------*/
/* Change directory to the supplied path, if possible and store the    */
/* expanded path.                                                      */
/*---------------------------------------------------------------------*/
 if (chdir(sp_path) != 0)
   {
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
 getcwd(sp_path,MAX_FILE_NAME);
/*---------------------------------------------------------------------*/
/* For DOS or OS/2, change back to the current directory of the now    */
/* current disk and then change back to the current disk.              */
/*---------------------------------------------------------------------*/
#if defined(DOS) || defined(OS2)
 if (new_dos_disk != 0
 &&  new_dos_disk != current_dos_disk)
   {
    if (chdir(work_filename) != 0)
      {
#ifdef TRACE
       trace_return();
#endif
       return(ERROR);
      }
#ifdef DOS
#ifdef TC
    setdisk((int)(current_dos_disk-1));
#else
    _dos_setdrive(current_dos_disk,&temp_disk);
#endif
#endif
#ifdef OS2
    DosSelectDisk(current_dos_disk);
#endif
   }
#endif

 chdir(curr_path);
/*---------------------------------------------------------------------*/
/* Append the OS directory character to the path if it doesn't already */
/* end in the character.                                               */
/*---------------------------------------------------------------------*/
#ifndef VMS
 len = strlen(sp_path);
 if (len > 0)
    if (sp_path[len-1] != SLASH)
       strcat(sp_path,(unsigned char *)STR_SLASH);
#endif
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
#ifdef NO_RENAME
/***********************************************************************/
int rename(path1,path2)
char *path1;
char *path2;
/***********************************************************************/
/* Function  : Emulate missing rename() function from SystemV          */
/* Parameters: path1    - old filename                                 */
/*             path2    - new_filename                                 */
/* Return    : 0 on success, -1 on error                               */
/***********************************************************************/
{
#ifdef TRACE
 trace_function("nonansi.c :rename");
#endif
  if (link(path1,path2) != 0)
    {
#ifdef TRACE
     trace_return();
#endif
     return(-1);
    }
  if (unlink(path1) != 0)
    {
#ifdef TRACE
     trace_return();
#endif
     return(-1);
    }
#ifdef TRACE
 trace_return();
#endif
 return(0);
}
#endif
#ifdef DOS
/***********************************************************************/
void csr_size(start,end)
/***********************************************************************/
/* Function  : BIOS call to set size of cursor                         */
/* Parameters: start    - starting row                                 */
/*             end      - ending row                                   */
/* Return    : void                                                    */
/***********************************************************************/
register int  start;
register int  end;
{
#ifdef TRACE
 trace_function("nonansi.c :csr_size");
#endif
  regs.h.ah = 1;
  regs.h.ch = start;
  regs.h.cl = end;
  int86(0x10,&regs,&regs);
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
char get_mode(void)
/***********************************************************************/
/* Function  : BIOS call to get current video mode.                    */
/* Parameters: n/a                                                     */
/* Return    : mode number                                             */
/***********************************************************************/
{
#ifdef TRACE
 trace_function("nonansi.c :get_mode");
#endif
 regs.h.ah = 15;
 int86(0x10,&regs,&regs);
 regs.h.ah = 0;
#ifdef TRACE
 trace_return();
#endif
 return(regs.h.al);
}
#endif
#ifdef OS2
/***********************************************************************/
#ifdef PROTO
bool FATFileSystem(char *fname)
#else
bool FATFileSystem(fname)
char *fname;
#endif
/***********************************************************************/
{
typedef struct _FSNAME {
        USHORT cbName;
        UCHAR  szName[1];
} FSNAME;
typedef struct _FSQINFO {
        USHORT iType;
        FSNAME Name;
        UCHAR  rgFSAData[59];
} FSQINFO;
typedef FSQINFO FAR *PFSQINFO;
/*--------------------------- local data ------------------------------*/
 USHORT nDrive,cbData;
 ULONG lMap;
 FSQINFO bData;
 BYTE bName[3];
 FSNAME *pFSName;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("file.c:    FATFileSystem");
#endif
/*---------------------------------------------------------------------*/
/* This determines if the file system for the current path is FAT or   */
/* not (usually HPFS).                                                 */
/*---------------------------------------------------------------------*/
 if ((strlen(fname) > 0) && fname[1] == ':')
    bName[0] = fname[0];
 else
   {
    DosQCurDisk(&nDrive, &lMap);
    bName[0] = (char)(nDrive + '@');
   }
 bName[1] = ':';
 bName[2] = 0;
 cbData = sizeof(bData);
 DosQFSAttach((PSZ)bName,0,1,(PBYTE)&bData,&cbData,0L);
 pFSName = &bData.Name;
 (char *)pFSName += pFSName->cbName + sizeof(pFSName->cbName)+1;
 return(strcmp((char *)&(pFSName->szName[0]),"FAT") == 0);
}
#endif
