/***********************************************************************/
/* DIRECTRY.C - Directory routines                                     */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#ifdef __OS2__
#   define INCL_DOS
#endif
#include "the.h"
#include "directry.h"
#include "fnmatch.h"

#ifdef PROTO
char *make_full(char *path, char *file)
#else
char *make_full(path, file)
char *path, *file;
#endif
{
 static char filebuf[BUFSIZ];

 if (strlen(path)+1+strlen(file)+1 > BUFSIZ)
    return(NULL);
 if (!strcmp(path, "") || !strcmp(path, "."))
   {
    (void) strcpy(filebuf, file);
    return(filebuf);
   }
 (void) strcpy(filebuf, path);
 if (path[strlen(path) - 1] != SLASH && *file != SLASH)
    (void) strcat(filebuf, STR_SLASH);
 (void) strcat(filebuf, file);
 return(filebuf);
}
/*********************************************************************/
#ifdef UNIX
#ifdef PROTO
int getfiles(char *path,char *files,struct dirfile **dpfirst,
                                    struct dirfile **dplast)
#else
int getfiles(path,files,dpfirst,dplast)
char *path;
char *files;
struct dirfile **dpfirst;
struct dirfile **dplast;
#endif
{
 DIR *dirp;
 struct stat sp;
 struct dirent *direntp;
 struct dirfile *dp;
 char *full_name;
 int entries = 10;

 dirp = opendir(path);
 if (dirp == NULL)
    return(10);

 dp = *dpfirst = (struct dirfile *)calloc(entries, sizeof (struct dirfile));
 if (dp == NULL)
    return(30);
 *dplast = *dpfirst + entries;

 for (direntp = readdir(dirp);direntp != NULL;direntp = readdir(dirp))
    {
     if (fnmatch(files,direntp->d_name,0) == 0)
       {
        if ((full_name = make_full(path,direntp->d_name)) == NULL)
           return(30);
        if (stat(full_name,&sp) != 0)
           continue;
        if ((dp->fname = (char *)calloc(strlen(direntp->d_name)+1,sizeof(char))) == NULL)
           return(30);
        strcpy(dp->fname,direntp->d_name);
        dp->fattr = sp.st_mode;
        dp->ftime = sp.st_mtime;
        dp->fsize = sp.st_size;
	dp->fdate = 0;
        dp++;
        if (dp == *dplast)
          {
           *dpfirst = (struct dirfile *)realloc((char *)*dpfirst,
                      2 * entries * sizeof (struct dirfile));
           if (*dpfirst == NULL)
              return(30);
           dp = *dpfirst + entries;
           *dplast = dp + entries;
           entries *= 2;
          }
       }
    }
 closedir(dirp);
 *dplast = dp;
 return(0);
}
#else
/*********************************************************************/
#ifdef PROTO
int getfiles(char *path,char *files,struct dirfile **dpfirst,
                                    struct dirfile **dplast)
#else
int getfiles(path,files,dpfirst,dplast)
char *path;
char *files;
struct dirfile **dpfirst;
struct dirfile **dplast;
#endif
{
 struct dirfile *dp;
#ifdef OS2
 USHORT matches=1;
 ULONG rsvrd=0;
 HDIR hdir=HDIR_SYSTEM;
#endif
 FSTR_TYPE ffblk;
 ATTR_TYPE attrs = F_RO | F_HI | F_SY | F_DI | F_AR;
 DONE_TYPE done;
 char *full_path;
 char str_attr[11];
 char str_date[10];
 char str_time[6];
 int entries = 10;

 if ((full_path = make_full(path,"*.*")) == NULL)
	   return(1);

#if defined(DOS) && defined(TC)
 done = findfirst(full_path,&ffblk,attrs);
#endif
#if defined (DOS) && defined(MSC)
 done = _dos_findfirst(full_path,attrs,&ffblk);
#endif
#ifdef OS2
 done = DosFindFirst((PSZ) full_path, (PHDIR)&hdir, (USHORT)attrs,
		     (PFILEFINDBUF)&ffblk, (USHORT)sizeof(ffblk), (PUSHORT)&matches,
		     (ULONG)rsvrd);
#endif
 if (done != 0)
    return(1);

 dp = *dpfirst = (struct dirfile *)calloc(entries, sizeof (struct dirfile));
 *dplast = *dpfirst + entries;


 while(!done)
    {
     if (fnmatch(files,ffblk.NAME_NAME,FNM_IGNORECASE) == 0)
       {
	if ((dp->fname = (char *)calloc(strlen(ffblk.NAME_NAME)+1,sizeof(char))) == NULL)
	   return(1);
	strcpy(dp->fname,ffblk.NAME_NAME);
	dp->fattr = ffblk.ATTR_NAME;
	dp->ftime = ffblk.TIME_NAME;
	dp->fsize = ffblk.SIZE_NAME;
	dp->fdate = ffblk.DATE_NAME;
	dp++;
	if (dp == *dplast)
	  {
           *dpfirst = (struct dirfile *)realloc((char *)*dpfirst,
                      2 * entries * sizeof (struct dirfile));
           if (*dpfirst == NULL)
              return(1);
           dp = *dpfirst + entries;
           *dplast = dp + entries;
           entries *= 2;
          }
       }
#if defined(DOS) && defined(TC)
     done = findnext(&ffblk);
#endif
#if defined(DOS) && defined(MSC)
     done = _dos_findnext(&ffblk);
#endif
#ifdef OS2
     done = DosFindNext((HDIR)hdir, (PFILEFINDBUF)&ffblk, (USHORT)sizeof(ffblk),
            (PUSHORT)&matches);
#endif
    }
 *dplast = dp;
 return(0);
}
#endif
/*********************************************************************/
#ifdef PROTO
int fcomp(struct dirfile *first,struct dirfile* next)
#else
int fcomp(first,next)
struct dirfile *first;
struct dirfile* next;
#endif
{
 return(strcmp(first->fname,next->fname));
}
/*********************************************************************/
#ifdef PROTO
char *file_date(D_TYPE date,char *str_date)
#else
char *file_date(date,str_date)
D_TYPE date;
char *str_date;
#endif
{
 static char mon[12][4] = {
 "Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
 sprintf(str_date,"%2d-%3.3s-%2.2d",DAYS_MASK,MONT_MASK,YEAR_MASK);
 return(str_date);
}
/*********************************************************************/
#ifdef PROTO
char *file_time(T_TYPE time,char *str_time)
#else
char *file_time(time,str_time)
T_TYPE time;
char *str_time;
#endif
{
 sprintf(str_time,"%2d:%2.2d",HOUR_MASK,MINU_MASK);
 return(str_time);
}
/*********************************************************************/
#ifdef PROTO
char *file_attrs(ATTR_TYPE attrs,char *str_attr)
#else
char *file_attrs(attrs,str_attr)
ATTR_TYPE attrs;
char *str_attr;
#endif
{
#ifdef UNIX
 ATTR_TYPE ftype=(attrs & S_IFMT);

 str_attr[10] = '\0';
 switch(ftype)
   {
    case S_IFDIR:  str_attr[0] = 'd'; break;
    case S_IFCHR:  str_attr[0] = 'c'; break;
    case S_IFSOCK: str_attr[0] = 's'; break;
    case S_IFIFO:  str_attr[0] = 'p'; break;
    case S_IFLNK:  str_attr[0] = 'l'; break;
    default:       str_attr[0] = '-'; break;
   }
 str_attr[1] = (attrs & S_IRUSR) ? 'r' : '-';
 str_attr[2] = (attrs & S_IWUSR) ? 'w' : '-';
 str_attr[3] = (attrs & S_IXUSR) ? 'x' : '-';
 str_attr[4] = (attrs & S_IRGRP) ? 'r' : '-';
 str_attr[5] = (attrs & S_IWGRP) ? 'w' : '-';
 str_attr[6] = (attrs & S_IXGRP) ? 'x' : '-';
 str_attr[7] = (attrs & S_IROTH) ? 'r' : '-';
 str_attr[8] = (attrs & S_IWOTH) ? 'w' : '-';
 str_attr[9] = (attrs & S_IXOTH) ? 'x' : '-';
#else
 strcpy(str_attr,".... ");
 if ((attrs & F_RO) == F_RO)
   str_attr[0] = 'r';
 if ((attrs & F_AR) == F_AR)
   str_attr[1] = 'a';
 if ((attrs & F_SY) == F_SY)
   str_attr[2] = 's';
 if ((attrs & F_HI) == F_HI)
   str_attr[3] = 'h';
 str_attr[4] = '\0';
 if ((attrs & F_DI) == F_DI)
   strcat(str_attr,"(dir) ");
 else
   strcat(str_attr,"      ");
#endif
 return(str_attr);
}
