/***********************************************************************/
/* COMMSOS.C - sos commands.                                           */
/* This file contains all commands that can be assigned to function    */
/* keys or typed on the command line.                                  */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
#include <stdio.h>
#include <stdlib.h>

#include "the.h"

/*#define DEBUG 1*/

/*-------------------------- external data ----------------------------*/
extern LINE *first_command,*current_command,*last_command;
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char current_file;         /* pointer to current file */
extern WINDOW *foot,*error_window;
extern char error_on_screen;
extern unsigned char *rec;
extern unsigned short rec_len;
extern unsigned char *cmd_rec;
extern unsigned short cmd_rec_len;
extern unsigned char mode_insert;        /* defines insert mode toggle */
extern unsigned char in_profile;    /* indicates if processing profile */
extern unsigned char *tempfilename;
extern unsigned short file_start;

extern unsigned char temp_cmd[150];
extern unsigned char dir_filename[80];
extern unsigned char dir_pathname[80];
extern unsigned char sp_path[MAX_FILE_NAME+1] ;
extern unsigned char sp_fname[MAX_FILE_NAME+1] ;
extern unsigned char dir_path[MAX_FILE_NAME+1] ;    /* for dir and ls commands */
/*---------------------- function definitions -------------------------*/
#ifdef PROTO
void split_command(unsigned char *,unsigned char *,unsigned char *);
int param_split(unsigned char *,unsigned char *[],int );
long valid_target(unsigned char *);
int get_row_for_focus_line(int,long,long);
unsigned char *get_key_definition(unsigned short key);
void print_line(char,long,short,unsigned char *,unsigned char *);
bool valid_set_command(char *);
#else
void split_command();
int param_split();
long valid_target();
int get_row_for_focus_line();
unsigned char *get_key_definition();
void print_line();
bool valid_set_command();
#endif
/*man-start*********************************************************************
COMMAND
     sos_addline - add blank line after focus line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_addline command inserts a blank line in the file following
     the focus line. The cursor is placed in the column under the first
     non-blank in the focus line.

COMPATIBILITY
     Reasonable.

SEE ALSO
     sos_delline

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_addline(unsigned char *params)
#else
int Sos_addline(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_addline");
#endif
 rc = Add("1");
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     sos_delback - delete the character to the left of the cursor

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_delback command moves the cursor one character to the left
     and deletes the character now under the cursor.

COMPATIBILITY
     Compatible.

SEE ALSO
     sos_delchar

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_delback(unsigned char *params)
#else
int Sos_delback(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_delback");
#endif
 getyx(CURRENT_WINDOW,y,x);
 switch (CURRENT_VIEW->current_window)
   {
    case WINDOW_MAIN:
         if ((CURRENT_VIEW->focus_line == CURRENT_FILE->number_lines+1L
         || CURRENT_VIEW->focus_line== 0L))
           {
            display_error(38,"");
#ifdef TRACE
            trace_return();
#endif
            return(OK);
           }
         break;
    case WINDOW_COMMAND:
         if (x == 0)
            return(OK);
         mvwdelch(CURRENT_WINDOW,y,x-1);
         cmd_rec = (unsigned char *)memdelchr((char *)cmd_rec,
                                               x-1,cmd_rec_len,1);
         cmd_rec_len--;
#ifdef TRACE
         trace_return();
#endif
         return(OK);
         break;
    case WINDOW_PREFIX:
         if (x == 0)
            return(OK);
         mvwdelch(CURRENT_WINDOW,y,x-1);
#ifdef TRACE
         trace_return();
#endif
         return(OK);
         break;
    default:
         break;
   }
/*---------------------------------------------------------------------*/
/* Remainder of processing is only for WINDOW_MAIN.                    */
/*---------------------------------------------------------------------*/
 if (x == 0 && CURRENT_VIEW->verify_start == CURRENT_VIEW->verify_col)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 Left_arrow("");
/*---------------------------------------------------------------------*/
/* If we are after the last character of the line, exit.               */
/*---------------------------------------------------------------------*/
 if (x+CURRENT_VIEW->verify_col-1 > rec_len)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }

 getyx(CURRENT_WINDOW,y,x);
 mvwdelch(CURRENT_WINDOW,y,x);

 rec = (unsigned char *)memdelchr((char *)rec,CURRENT_VIEW->verify_col-1+x,rec_len,1);
 rec_len--;
/*---------------------------------------------------------------------*/
/* If there is a character off the right edge of the screen, display it*/
/* in the last character of the main window.                           */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1 < rec_len)
   {
    wmove(CURRENT_WINDOW,y,CURRENT_SCREEN.cols-1);
    put_char(CURRENT_WINDOW,
             rec[CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1],ADDCHAR);
    wmove(CURRENT_WINDOW,y,x);
   }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     sos_delchar - delete character under cursor

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_delchar command deletes the character under the cursor.
     Text to the right is shifted to the left.

COMPATIBILITY
     Complete

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_delchar(unsigned char *params)
#else
int Sos_delchar(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_delchar");
#endif
/*---------------------------------------------------------------------*/
/* Do not allow this command on the top or bottom of file lines.       */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->current_window == WINDOW_MAIN
 && ((CURRENT_VIEW->focus_line == CURRENT_FILE->number_lines+1L
     || CURRENT_VIEW->focus_line== 0L)))
      {
       display_error(38,"");
#ifdef TRACE
       trace_return();
#endif
       return(OK);
      }
 getyx(CURRENT_WINDOW,y,x);
 wdelch(CURRENT_WINDOW);
 switch (CURRENT_VIEW->current_window)
   {
    case WINDOW_COMMAND:
         if (x < cmd_rec_len)
           {
            cmd_rec = (unsigned char *)memdelchr((char *)cmd_rec,
                                               x,cmd_rec_len,1);
            cmd_rec_len--;
           }
#ifdef TRACE
         trace_return();
#endif
         return(OK);
         break;
    case WINDOW_PREFIX:
#ifdef TRACE
         trace_return();
#endif
         return(OK);
         break;
    default:
         break;
   }

/*---------------------------------------------------------------------*/
/* If we are after the last character of the line, exit.               */
/*---------------------------------------------------------------------*/
 if (x+CURRENT_VIEW->verify_col-1 > rec_len)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }

 rec = (unsigned char *)memdelchr((char *)rec,CURRENT_VIEW->verify_col-1+x,rec_len,1);
 rec_len--;
/*---------------------------------------------------------------------*/
/* If there is a character off the right edge of the screen, display it*/
/* in the last character of the main window.                           */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1 < rec_len)
   {
    wmove(CURRENT_WINDOW,y,CURRENT_SCREEN.cols-1);
    put_char(CURRENT_WINDOW,
             rec[CURRENT_VIEW->verify_col-1+CURRENT_SCREEN.cols-1],ADDCHAR);
    wmove(CURRENT_WINDOW,y,x);
   }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     sos_delend - delete to end of line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_delend command deletes all characters from the current
     column to the end of line.

COMPATIBILITY
     Complete

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_delend(unsigned char *params)
#else
int Sos_delend(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register short i;
 unsigned short col,x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_delend");
#endif
 getyx(CURRENT_WINDOW,y,x);
 switch (CURRENT_VIEW->current_window)
   {
    case WINDOW_MAIN:
         if (CURRENT_VIEW->focus_line == CURRENT_FILE->number_lines+1L
         || CURRENT_VIEW->focus_line== 0L)
           {
            display_error(38,"");
#ifdef TRACE
            trace_return();
#endif
            return(OK);
           }
         col = x + CURRENT_VIEW->verify_col - 1;
         for (i=col;i<MAX_LINE_LENGTH;i++)
             rec[i] = ' ';
         if (rec_len > col)
            rec_len = col;
         break;
    case WINDOW_COMMAND:
         for (i=x;i<COLS;i++)
             cmd_rec[i] = ' ';
         if (cmd_rec_len > x)
            cmd_rec_len = x;
         break;
    case WINDOW_PREFIX:
         break;
    default:
         break;
   }
 wclrtoeol(CURRENT_WINDOW);
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     sos_delline - delete focus line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_delline command deletes the focus line.

COMPATIBILITY
     Complete

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Sos_delline(unsigned char *params)
#else
int Sos_delline(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_delline");
#endif
 rc = Delete_line("1");
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     sos_edit - edit a file from directory list

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_edit command allows the user to edit a file, chosen from
     a directory list.(the file DIR.DIR).

COMPATIBILITY
     Compatible.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_edit(unsigned char *params)
#else
int Sos_edit(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register short i,j;
 unsigned short col,x,y;
 LINE *curr;
 unsigned char edit_fname[MAX_FILE_NAME];
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_edit");
#endif
/*---------------------------------------------------------------------*/
/* This command is only valid from within the special DIR.DIR file;    */
/* not from the command line and not on the top or bottom lines.       */
/* Ignore the command if attempted execution from the above.           */
/*---------------------------------------------------------------------*/
 if (strcmp(CURRENT_FILE->fname,dir_filename) != 0
 ||  CURRENT_VIEW->current_window == WINDOW_COMMAND)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 getyx(CURRENT_WINDOW,y,x);
 if (CURRENT_VIEW->focus_line == 0
 ||  CURRENT_VIEW->focus_line == CURRENT_FILE->number_lines+1)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
/*---------------------------------------------------------------------*/
/* Find the current LINE pointer for the focus_line.                   */
/*---------------------------------------------------------------------*/
 curr = ll_find(CURRENT_FILE->first_line,CURRENT_VIEW->focus_line);
/*---------------------------------------------------------------------*/
 post_process_line(CURRENT_VIEW->focus_line);
/*---------------------------------------------------------------------*/
/* Validate that the supplied file is valid.                           */
/*---------------------------------------------------------------------*/
 strcpy(edit_fname,dir_path);
 strcat(edit_fname,curr->line+file_start);
 if (splitpath(edit_fname) == ERROR)
   {
    display_error(10,temp_cmd);
#ifdef TRACE
    trace_return();
#endif
    return(ERROR);
   }
/*---------------------------------------------------------------------*/
/* Edit the file.                                                      */
/*---------------------------------------------------------------------*/
 strcpy(edit_fname,sp_path);
 strcat(edit_fname,sp_fname);
 rc = Edit(edit_fname);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     sos_endchar - move cursor to end/start of focus line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_endchar command moves the cursor to the first character
     displayed in the current window, if the cursor is after the last
     character displayed in the current window, or to the position after
     the last character displayed in the current window, if the cursor is
     anywhere else.

COMPATIBILITY
     The possible combinations of VERIFY etc. make mimicing *EDIT very
     difficult. The command is, on the surface, compatible.

STATUS
     incomplete-problem determining exactly where the cursor should go
     when a verify end is in place and we are going to the end of line
**man-end**********************************************************************/
#ifdef PROTO
int Sos_endchar(unsigned char *params)
#else
int Sos_endchar(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register short i;
 unsigned short col,x,y,line_col;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_endchar");
#endif
 getyx(CURRENT_WINDOW,y,x);
 switch(CURRENT_VIEW->current_window)
   {
    case WINDOW_PREFIX:
#ifdef TRACE
         trace_return();
#endif
         return(OK);
         break;
    case WINDOW_COMMAND:
         if (x >= cmd_rec_len)
            wmove(CURRENT_WINDOW,y,0);
         else
            wmove(CURRENT_WINDOW,y,cmd_rec_len);
#ifdef TRACE
         trace_return();
#endif
         return(OK);
         break;
    default:
         break;
   }
/*---------------------------------------------------------------------*/
/* Processing from here is for main window only.                       */
/*---------------------------------------------------------------------*/
 line_col = x + CURRENT_VIEW->verify_col;
 if (line_col > min(rec_len,CURRENT_VIEW->verify_end))
   {
    CURRENT_VIEW->verify_col = max(CURRENT_VIEW->verify_start,1);
    show_page();
    wmove(CURRENT_WINDOW,y,0);
   }
 else
   {
    if (rec_len < CURRENT_SCREEN.cols)
      {
       x = min(rec_len-(CURRENT_VIEW->verify_col-1),CURRENT_VIEW->verify_end);
       wmove(CURRENT_WINDOW,y,x);
      }
    else
      {
       x = CURRENT_SCREEN.cols / 2;
       CURRENT_VIEW->verify_col = rec_len-x+1;
       show_page();
       wmove(CURRENT_WINDOW,y,x);
      }
   }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     sos_tabf - move cursor to next tab stop

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_tabf command causes the cursor to move to the next tab column
     as set by the TABS command. (The default is 8).
     If the resulting column is beyond the right hand edge of the main
     window, the window will scroll half a window.

COMPATIBILITY
     Does not line tab to next line if after the right hand tab column.

SEE ALSO
     tabs

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_tabf(unsigned char *params)
#else
int Sos_tabf(params)
unsigned char *params;
#endif
/***********************************************************************/
{
extern char tabkey_insert,tabkey_overwrite;
/*--------------------------- local data ------------------------------*/
 unsigned short x,y,num_cols,next_tab_col;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_tabf");
#endif
/*---------------------------------------------------------------------*/
/* If the actual tab character is to be display then exit so that      */
/* edit() can process it as a raw key.                                 */
/*---------------------------------------------------------------------*/
 if (mode_insert && tabkey_insert == 'C')
   {
#ifdef TRACE
    trace_return();
#endif
    return(RAW_KEY);
   }
 if (!mode_insert && tabkey_overwrite == 'C')
   {
#ifdef TRACE
    trace_return();
#endif
    return(RAW_KEY);
   }

 getyx(CURRENT_WINDOW,y,x);
/*---------------------------------------------------------------------*/
/* First determine the number of characters to move to the right from  */
/* the current column.                                                 */
/*---------------------------------------------------------------------*/
 num_cols = (CURRENT_VIEW->tabs) -
            ((x + CURRENT_VIEW->verify_col) % CURRENT_VIEW->tabs);
 next_tab_col = x + CURRENT_VIEW->verify_col + num_cols;
/*---------------------------------------------------------------------*/
/* Check for going past end of line - MAX_LINE_LENGTH                  */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->verify_col+x+num_cols > MAX_LINE_LENGTH)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
/*---------------------------------------------------------------------*/
/* For all windows, if the new cursor position does not exceed the     */
/* right edge, move there.                                             */
/*---------------------------------------------------------------------*/
 if (x+num_cols <= CURRENT_SCREEN.cols-1)
   {
    wmove(CURRENT_WINDOW,y,x+num_cols);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
/*---------------------------------------------------------------------*/
/* For MAIN window, if the new cursor position exceeds the right edge  */
/* scroll the window half the width of the main window.                */
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->current_window == WINDOW_MAIN)
    if (x+num_cols > CURRENT_SCREEN.cols-1)
      {
       x = CURRENT_SCREEN.cols / 2;
       CURRENT_VIEW->verify_col += x;
       show_page();
       wmove(CURRENT_WINDOW,y,(next_tab_col-CURRENT_VIEW->verify_col));
/*       wmove(CURRENT_WINDOW,y,(x+num_cols)-1);*/
      }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     sos_tabwordb - move cursor to beginning of previous word

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_tabwordb command causes the cursor to move to the first character
     of the word to the left or to the start of the line if no more
     words precede.
     If the resulting column is beyond the left hand edge of the main
     window, the window will scroll half a window.

COMPATIBILITY
     Compatible.

SEE ALSO
     sos_tabwordf

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_tabwordb(unsigned char *params)
#else
int Sos_tabwordb(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short x,y,temp_rec_len;
 short start_word_col;
 unsigned short word_break;
 unsigned char *temp_rec;
 register short i;
 short num_cols,col_pos,col,rec_pos,left_col;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_tabwordb");
#endif
/*---------------------------------------------------------------------*/
/* This function is not applicable to the PREFIX window.               */
/*---------------------------------------------------------------------*/
 getyx(CURRENT_WINDOW,y,x);
 switch(CURRENT_VIEW->current_window)
   {
    case WINDOW_PREFIX:
         display_error(38,"");
#ifdef TRACE
         trace_return();
#endif
         return(OK);
         break;
    case WINDOW_MAIN:
         temp_rec = rec;
         temp_rec_len = rec_len;
         left_col = CURRENT_VIEW->verify_col-1;
         break;
    case WINDOW_COMMAND:
         temp_rec = cmd_rec;
         temp_rec_len = cmd_rec_len;
         left_col = 0;
         break;
   }
/*---------------------------------------------------------------------*/
/* Determine the start of the prior word, or go to the start of the    */
/* line if already at or before beginning of prior word.               */
/*---------------------------------------------------------------------*/
 word_break = 0;
 start_word_col = (-1);
 for (i=left_col+x;i>0;i--)
   {
    switch(word_break)
      {
       case 0:  /* still in current word */
            if (*(temp_rec+i) == ' ')
               word_break++;
            break;
       case 1:  /* in first blank space */
            if (*(temp_rec+i) != ' ')
               word_break++;
            break;
       case 2:  /* in previous word */
            if (*(temp_rec+i) == ' ')
              {
               start_word_col = i+1;
               word_break++;
              }
            break;
       default: /* should not get here */
            break;
      }
    if (word_break == 3)
       break;
   }
 if (start_word_col == (-1))
    start_word_col = 0;
 num_cols = (x + left_col) - start_word_col;
/*---------------------------------------------------------------------*/
/* For all windows, if the new cursor position is not less than the    */
/* left edge,  move there.                                             */
/* If in command window, this should always be true.                   */
/*---------------------------------------------------------------------*/
 col_pos = x;
 if (col_pos-num_cols >= 0)
   {
    wmove(CURRENT_WINDOW,y,x-num_cols);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
/*---------------------------------------------------------------------*/
/* For MAIN window, if the new cursor position exceeds the right edge  */
/* scroll the window half the width of the main window.                */
/*---------------------------------------------------------------------*/
 rec_pos = CURRENT_VIEW->verify_col + x - num_cols + 1;

 x = CURRENT_SCREEN.cols / 2;
 col = max((short)CURRENT_VIEW->verify_start,
                 (short)(CURRENT_VIEW->verify_col-1) - (short)x);
 CURRENT_VIEW->verify_col = col;
 show_page();
 wmove(CURRENT_WINDOW,y,rec_pos-CURRENT_VIEW->verify_col-1);
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     sos_tabwordf - move cursor to start of next word

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_tabwordf command causes the cursor to move to the first character
     of the next word to the right or to the end of the line if no more
     words follow.
     If the resulting column is beyond the right hand edge of the main
     window, the window will scroll half a window.

COMPATIBILITY
     Compatible.

SEE ALSO
     sos_tabwordb

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_tabwordf(unsigned char *params)
#else
int Sos_tabwordf(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short x,y,temp_rec_len,num_cols;
 short start_word_col,left_col;
 bool word_break;
 unsigned char *temp_rec;
 register short i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_tabwordf");
#endif
/*---------------------------------------------------------------------*/
/* This function is not applicable to the PREFIX window.               */
/*---------------------------------------------------------------------*/
 getyx(CURRENT_WINDOW,y,x);
 switch(CURRENT_VIEW->current_window)
   {
    case WINDOW_PREFIX:
         display_error(38,"");
#ifdef TRACE
         trace_return();
#endif
         return(OK);
         break;
    case WINDOW_MAIN:
         temp_rec = rec;
         temp_rec_len = rec_len;
         left_col = CURRENT_VIEW->verify_col-1;
         break;
    case WINDOW_COMMAND:
         temp_rec = cmd_rec;
         temp_rec_len = cmd_rec_len;
         left_col = 0;
         break;
   }
/*---------------------------------------------------------------------*/
/* If we are after the last column of the line, then just ignore the   */
/* command and leave the cursor where it is.                           */
/*---------------------------------------------------------------------*/
 if ((x + left_col) > temp_rec_len)
   {
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
/*---------------------------------------------------------------------*/
/* Determine the start of the next word, or go to the end of the line  */
/* if already at or past beginning of last word.                       */
/*---------------------------------------------------------------------*/
 word_break = FALSE;
 start_word_col = (-1);
 for (i=left_col+x;i<temp_rec_len;i++)
   {
    if (*(temp_rec+i) == ' ')
       word_break = TRUE;
    else
      {
       if (word_break)
         {
          start_word_col = i;
          break;
         }
      }
   }
 if (start_word_col == (-1))
    start_word_col = temp_rec_len;
 num_cols =  start_word_col - (x + CURRENT_VIEW->verify_col -1);
/*---------------------------------------------------------------------*/
/* For all windows, if the new cursor position does not exceed the     */
/* right edge, move there.                                             */
/* If in command window, this should always be true.                   */
/*---------------------------------------------------------------------*/
 if (x+num_cols <= CURRENT_SCREEN.cols-1
 || CURRENT_VIEW->current_window == WINDOW_COMMAND)
   {
    wmove(CURRENT_WINDOW,y,x+num_cols);
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
/*---------------------------------------------------------------------*/
/* For MAIN window, if the new cursor position exceeds the right edge  */
/* scroll the window half the width of the main window.                */
/*---------------------------------------------------------------------*/
 if (x+num_cols > CURRENT_SCREEN.cols-1)
   {
    x = CURRENT_SCREEN.cols / 2;
    CURRENT_VIEW->verify_col += x;
    show_page();
    wmove(CURRENT_WINDOW,y,(start_word_col-CURRENT_VIEW->verify_col+1));
   }
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
/*man-start*********************************************************************
COMMAND
     sos_undo - undo changes to the current line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The sos_undo command causes the contents of the focus line (or the
     command line) to be reset to the contents before the cursor was
     positioned there.

COMPATIBILITY
     Basically compatible. Doesn't restore the cursor to the original
     column position.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Sos_undo(unsigned char *params)
#else
int Sos_undo(params)
unsigned char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 unsigned short x,y,temp_rec_len,num_cols;
 short start_word_col;
 bool word_break;
 unsigned char *temp_rec;
 register short i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("commsos.c: Sos_undo");
#endif
 if (CURRENT_VIEW->current_window == WINDOW_PREFIX)
   {
    display_error(38,"...at the moment.");
#ifdef TRACE
    trace_return();
#endif
    return(OK);
   }
 if (CURRENT_VIEW->current_window == WINDOW_MAIN)
    pre_process_line(CURRENT_VIEW->focus_line);
 else
   {
    wmove(CURRENT_WINDOW_COMMAND,0,0);
    wclrtoeol(CURRENT_WINDOW_COMMAND);
   }
  show_page();
#ifdef TRACE
 trace_return();
#endif
 return(OK);
}
