/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991,1992 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@itc.gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 7877
 * QLD 4121
 * Australia
 */
struct commands
{
 unsigned char *text;
 unsigned short min_len;
 unsigned int funkey;
#ifdef PROTO
 int (*function)(unsigned char *);
#else
 int (*function)();
#endif
 bool valid_profile_command;
 bool set_command;
 unsigned char *params;
};
typedef struct commands COMMAND;

struct defines
{
 unsigned int def_funkey;
 unsigned char *def_params;
 short def_command;
 struct defines *def_next;
};
typedef struct defines DEFINE;

DEFINE *first_define=NULL;

#ifdef PROTO
int Add(unsigned char *);
int All(unsigned char *);
int Autosave(unsigned char *);
int Backward(unsigned char *);
int Bottom(unsigned char *);
int Cancel(unsigned char *);
int Case(unsigned char *);
int Ccancel(unsigned char *);
int Change(unsigned char *);
int Cmatch(unsigned char *);
int Cmdarrows(unsigned char *);
int Colour(unsigned char *);
int Control_char(unsigned char *);
int Copy(unsigned char *);
int Define(unsigned char *);
int Delete_line(unsigned char *);
int Directory(unsigned char *);
int Down_arrow(unsigned char *);
int Edit(unsigned char *);
int Enter(unsigned char *);
int Eolout(unsigned char *);
int Ffile(unsigned char *);
int File(unsigned char *);
int Forward(unsigned char *);
int Get(unsigned char *);
int Help(unsigned char *);
int Input(unsigned char *);
int Insertmode(unsigned char *);
int Left_arrow(unsigned char *);
int Locate(unsigned char *);
int Mark(unsigned char *);
int Move(unsigned char *);
int Next(unsigned char *);
int Nextwindow(unsigned char *);
int Os_cmd(unsigned char *);
int Prefix(unsigned char *);
int Print(unsigned char *);
int Printer(unsigned char *);
int Put(unsigned char *);
int Putd(unsigned char *);
int Qquit(unsigned char *);
int Quit(unsigned char *);
int Recover(unsigned char *);
int Refresh(unsigned char *);
int Reset(unsigned char *);
int Retrieve(unsigned char *);
int Right_arrow(unsigned char *);
int Save(unsigned char *);
int Set(unsigned char *);
int Schange(unsigned char *);
int Screen(unsigned char *);
int ShowKey(unsigned char *);
int Sos_addline(unsigned char *);
int Sos_delback(unsigned char *);
int Sos_delchar(unsigned char *);
int Sos_delend(unsigned char *);
int Sos_delline(unsigned char *);
int Sos_edit(unsigned char *);
int Sos_endchar(unsigned char *);
int Sos_tabf(unsigned char *);
int Sos_tabwordb(unsigned char *);
int Sos_tabwordf(unsigned char *);
int Sos_undo(unsigned char *);
int Spltjoin(unsigned char *);
int Ssave(unsigned char *);
int Stay(unsigned char *);
int Tabcmd(unsigned char *);
int Tabkey(unsigned char *);
int Tabpre(unsigned char *);
int Tabs(unsigned char *);
int Tabsin(unsigned char *);
int Tabsout(unsigned char *);
int Top(unsigned char *);
int Up(unsigned char *);
int Up_arrow(unsigned char *);
int Verify(unsigned char *);
int Zone(unsigned char *);
#else
int Add();
int All();
int Autosave();
int Backward();
int Bottom();
int Cancel();
int Case();
int Ccancel();
int Change();
int Cmatch();
int Cmdarrows();
int Colour();
int Control_char();
int Copy();
int Define();
int Delete_line();
int Directory();
int Down_arrow();
int Edit();
int Enter();
int Eolout();
int Ffile();
int File();
int Forward();
int Get();
int Help();
int Input();
int Insertmode();
int Locate();
int Left_arrow();
int Mark();
int Move();
int Next();
int Nextwindow();
int Os_cmd();
int Prefix();
int Print();
int Printer();
int Put();
int Putd();
int Qquit();
int Quit();
int Recover();
int Refresh();
int Reset();
int Retrieve();
int Right_arrow();
int Save();
int Schange();
int Screen();
int Set();
int ShowKey();
int Sos_addline();
int Sos_delback();
int Sos_delchar();
int Sos_delend();
int Sos_delline();
int Sos_edit();
int Sos_endchar();
int Sos_tabf();
int Sos_tabwordb();
int Sos_tabwordf();
int Sos_undo();
int Spltjoin();
int Ssave();
int Stay();
int Tabcmd();
int Tabkey();
int Tabpre();
int Tabs();
int Tabsin();
int Tabsout();
int Top();
int Up();
int Up_arrow();
int Verify();
int Zone();
#endif

/*---------------------- *** IMPORTANT *** ----------------------------*/
/* Make sure that there is no chance two or more commands can be       */
/* matched based on number of significant charcters.                   */
/*---------------------- *** IMPORTANT *** ----------------------------*/
#if defined(DOS) || defined(OS2)
#define MAX_COMMANDS 86
#else
#define MAX_COMMANDS 95
#endif
COMMAND command[MAX_COMMANDS] =
{
 {(unsigned char *)"add",         3,  0,               Add,         TRUE, FALSE, (unsigned char *)"1"}, /* comm1.c */
 {(unsigned char *)"all",         3,  0,               All,         TRUE, FALSE, (unsigned char *)""}, /* comm1.c */
 {(unsigned char *)"autosave",    2,  0,               Autosave,    TRUE, TRUE,  (unsigned char *)"1"}, /* comm1.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"backward",    2,  KEY_PGUP,        Backward,    FALSE,FALSE, (unsigned char *)"1"}, /* comm1.c */
 {(unsigned char *)"bottom",      3,  KEY_C_PGDN,      Bottom,      TRUE, FALSE, (unsigned char *)""},  /* comm1.c */
#else
 {(unsigned char *)"backward",    2,  KEY_PPAGE,       Backward,    FALSE,FALSE, (unsigned char *)"1"}, /* comm1.c */
 {(unsigned char *)"backward",    2,  KEY_PrevScrn,    Backward,    FALSE,FALSE, (unsigned char *)"1"}, /* comm1.c */
 {(unsigned char *)"bottom",      3,  0,               Bottom,      TRUE, FALSE, (unsigned char *)""},  /* comm1.c */
#endif
 {(unsigned char *)"cancel",      3,  0,               Cancel,      TRUE, FALSE, (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"case",        4,  0,               Case,        TRUE, TRUE,  (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"ccancel",     2,  0,               Ccancel,     TRUE, FALSE, (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"change",      1,  0,               Change,      TRUE, FALSE, (unsigned char *)""},  /* comm1.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"cmatch",      0,  KEY_F7,          Cmatch,      FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
#else
 {(unsigned char *)"cmatch",      0,  KEY_F(7),        Cmatch,      FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
#endif
 {(unsigned char *)"cmdarrows",   4,  0,               Cmdarrows,   TRUE, TRUE,  (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"colour",      6,  0,               Colour,      TRUE, TRUE,  (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"color",       5,  0,               Colour,      TRUE, TRUE,  (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"copy",        4,  0,               Copy,        FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"control_char",0,  KEY_F12,         Control_char,FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"copy",        0,  KEY_A_c,         Copy,        FALSE,FALSE, (unsigned char *)"block"},  /* comm1.c */
#else
 {(unsigned char *)"control_char",0,  KEY_F(6),        Control_char,FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"copy",        0,  ControlC,        Copy,        FALSE,FALSE, (unsigned char *)"block"},  /* comm1.c */
#endif
 {(unsigned char *)"define",      3,  0,               Define,      TRUE, TRUE,  (unsigned char *)"1"}, /* comm1.c */
 {(unsigned char *)"delete",      3,  0,               Delete_line, TRUE, FALSE, (unsigned char *)"1"}, /* comm1.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"delete",      0,  KEY_A_g,         Delete_line, FALSE,FALSE, (unsigned char *)"block"}, /* comm1.c */
#else
 {(unsigned char *)"delete",      0,  ControlG,        Delete_line, FALSE,FALSE, (unsigned char *)"block"}, /* comm1.c */
#endif
 {(unsigned char *)"directory",   3,  0,               Directory,   FALSE,FALSE, (unsigned char *)"1"}, /* comm1.c */
 {(unsigned char *)"ls",          2,  0,               Directory,   FALSE,FALSE, (unsigned char *)"1"}, /* comm1.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"down_arrow",  0,  KEY_CURD,        Down_arrow,  FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
#else
 {(unsigned char *)"down_arrow",  0,  KEY_DOWN,        Down_arrow,  FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"enter",       0,  ControlM,        Enter,       FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
#endif
 {(unsigned char *)"edit",        1,  0,               Edit,        FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"xedit",       1,  0,               Edit,        FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"the",         3,  0,               Edit,        FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"enter",       0,  KEY_ENTER,       Enter,       FALSE,FALSE, (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"eolout",      4,  0,               Eolout,      TRUE, TRUE,  (unsigned char *)""},  /* comm1.c */
 {(unsigned char *)"ffile",       2,  0,               Ffile,       TRUE, FALSE, (unsigned char *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"file",        4,  KEY_F3,          File,        TRUE, FALSE, (unsigned char *)""},  /* comm2.c */
#else
 {(unsigned char *)"file",        4,  KEY_F(3),        File,        TRUE, FALSE, (unsigned char *)""},  /* comm2.c */
 {(unsigned char *)"file",        0,  KEY_PF3,         File,        TRUE, FALSE, (unsigned char *)""},  /* comm2.c */
#endif
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"forward",     2,  KEY_PGDN,        Forward,     FALSE,FALSE, (unsigned char *)"1"}, /* comm2.c */
#else
 {(unsigned char *)"forward",     2,  KEY_NPAGE,       Forward,     FALSE,FALSE, (unsigned char *)"1"}, /* comm2.c */
 {(unsigned char *)"forward",     2,  KEY_NextScrn,    Forward,     FALSE,FALSE, (unsigned char *)"1"}, /* comm2.c */
#endif
 {(unsigned char *)"get",         3,  0,               Get,         TRUE, FALSE, (unsigned char *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"help",        4,  KEY_F1,          Help,        FALSE,FALSE, (unsigned char *)""},  /* comm2.c */
#else
 {(unsigned char *)"help",        4,  KEY_F(1),        Help,        FALSE,FALSE, (unsigned char *)""},  /* comm2.c */
 {(unsigned char *)"help",        0,  KEY_PF1,         Help,        FALSE,FALSE, (unsigned char *)""},  /* comm2.c */
#endif
 {(unsigned char *)"input",       1,  0,               Input,       TRUE, FALSE, (unsigned char *)""},  /* comm2.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"insertmode",  7,  KEY_INS,         Insertmode,  TRUE, TRUE,  (unsigned char *)""},  /* comm2.c */
 {(unsigned char *)"left_arrow",  0,  KEY_CURL,        Left_arrow,  FALSE,FALSE, (unsigned char *)""},  /* comm3.c */
 {(unsigned char *)"locate",      1,  KEY_S_F1,        Locate,      TRUE, FALSE, (unsigned char *)""},  /* comm3.c */
#else
 {(unsigned char *)"insertmode",  7,  KEY_IC,          Insertmode,  TRUE, TRUE,  (unsigned char *)""},  /* comm2.c */
 {(unsigned char *)"left_arrow",  0,  KEY_LEFT,        Left_arrow,  FALSE,FALSE, (unsigned char *)""},  /* comm3.c */
 {(unsigned char *)"locate",      1,  KEY_F(11),       Locate,      TRUE, FALSE, (unsigned char *)""},  /* comm3.c */
#endif
 {(unsigned char *)"mark",        4,  0,               Mark,        FALSE,FALSE, (unsigned char *)""},  /* comm3.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"mark",        0,  KEY_A_l,         Mark,        FALSE,FALSE, (unsigned char *)"line"},  /* comm3.c */
 {(unsigned char *)"move",        4,  KEY_A_m,         Move,        FALSE,FALSE, (unsigned char *)"block"},  /* comm3.c */
 {(unsigned char *)"nextwindow",  5,  KEY_F2,          Nextwindow,  FALSE,FALSE, (unsigned char *)""}, /* comm3.c */
#else
 {(unsigned char *)"mark",        0,  ControlL,        Mark,        FALSE,FALSE, (unsigned char *)"line"},  /* comm3.c */
 {(unsigned char *)"move",        4,  ControlV,        Move,        FALSE,FALSE, (unsigned char *)"block"},  /* comm3.c */
 {(unsigned char *)"nextwindow",  5,  KEY_F(2),        Nextwindow,  FALSE,FALSE, (unsigned char *)""}, /* comm3.c */
 {(unsigned char *)"nextwindow",  5,  KEY_PF2,         Nextwindow,  FALSE,FALSE, (unsigned char *)""}, /* comm3.c */
#endif
 {(unsigned char *)"next",        1,  0,               Next,        TRUE, FALSE, (unsigned char *)"1"}, /* comm3.c */
 {(unsigned char *)"dos",         3,  0,               Os_cmd,      FALSE,FALSE, (unsigned char *)""},  /* comm3.c */
 {(unsigned char *)"!",           1,  0,               Os_cmd,      FALSE,FALSE, (unsigned char *)""},  /* comm3.c */
 {(unsigned char *)"prefix",      3,  0,               Prefix,      TRUE, TRUE,  (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"printer",     7,  0,               Printer,     TRUE, TRUE,  (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"print",       2,  0,               Print,       TRUE, FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"put",         3,  0,               Put,         TRUE, FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"putd",        4,  0,               Putd,        TRUE, FALSE, (unsigned char *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"qquit",       2,  KEY_S_F3,        Qquit,       TRUE, FALSE, (unsigned char *)""},  /* comm4.c */
#else
 {(unsigned char *)"qquit",       2,  KEY_F(13),       Qquit,       TRUE, FALSE, (unsigned char *)""},  /* comm4.c */
#endif
 {(unsigned char *)"quit",        4,  0,               Quit,        TRUE, FALSE, (unsigned char *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"right_arrow", 0,  KEY_CURR,        Right_arrow, FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"recover",     3,  KEY_F8,          Recover,     FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"refresh",     3,  KEY_C_r,         Refresh,     FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
#else
 {(unsigned char *)"right_arrow", 0,  KEY_RIGHT,       Right_arrow, FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"recover",     3,  KEY_F(8),        Recover,     FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"refresh",     3,  ControlR,        Refresh,     FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
#endif
 {(unsigned char *)"reset",       3,  0,               Reset,       FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"reset",       0,  KEY_A_u,         Reset,       FALSE,FALSE, (unsigned char *)"block"},  /* comm4.c */
#else
 {(unsigned char *)"reset",       0,  ControlU,        Reset,       FALSE,FALSE, (unsigned char *)"block"},  /* comm4.c */
#endif
 {(unsigned char *)"?",           1,  0,               Retrieve,    FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"save",        4,  0,               Save,        TRUE, FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"schange",     3,  0,               Schange,     FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"screen",      3,  0,               Screen,      FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"set",         3,  0,               Set,         TRUE, FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"showkey",     4,  0,               ShowKey,     FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"sos_addline", 0,  KEY_F4,          Sos_addline, FALSE,FALSE, (unsigned char *)"1"}, /* commsos.c */
 {(unsigned char *)"sos_delback", 0,  KEY_BKSP,        Sos_delback, FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_delchar", 0,  KEY_DEL,         Sos_delchar, FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_delend",  0,  KEY_C_END,       Sos_delend,  FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_delline", 0,  KEY_F9,          Sos_delline, FALSE,FALSE, (unsigned char *)"1"}, /* commsos.c */
 {(unsigned char *)"sos_edit",    0,  KEY_A_x,         Sos_edit,    FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_endchar", 0,  KEY_END,         Sos_endchar, FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_tabf",    0,  KEY_TAB,         Sos_tabf,    FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_tabwordb",0,  KEY_C_CURL,      Sos_tabwordb,FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_tabwordf",0,  KEY_C_CURR,      Sos_tabwordf,FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_undo",    0,  KEY_ESC,         Sos_undo,    FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"spltjoin",    8,  KEY_F10,         Spltjoin,    FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
#else
 {(unsigned char *)"sos_addline", 0,  KEY_F(4),        Sos_addline, FALSE,FALSE, (unsigned char *)"1"}, /* commsos.c */
 {(unsigned char *)"sos_addline", 0,  KEY_PF4,         Sos_addline, FALSE,FALSE, (unsigned char *)"1"}, /* commsos.c */
 {(unsigned char *)"sos_delback", 0,  127,             Sos_delback, FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_delchar", 0,  8,               Sos_delchar, FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_delchar", 0,  KEY_DC,          Sos_delchar, FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_delend",  0,  ControlE,        Sos_delend,  FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_delline", 0,  KEY_F(9),        Sos_delline, FALSE,FALSE, (unsigned char *)"1"}, /* commsos.c */
 {(unsigned char *)"sos_edit",    0,  ControlX,        Sos_edit,    FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_endchar", 0,  KEY_F(20),       Sos_endchar, FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_tabf",    0,  Tab,             Sos_tabf,    FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_tabwordb",0,  ControlJ,        Sos_tabwordb,FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_tabwordf",0,  ControlK,        Sos_tabwordf,FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"sos_undo",    0,  ControlZ,        Sos_undo,    FALSE,FALSE, (unsigned char *)""},  /* commsos.c */
 {(unsigned char *)"spltjoin",    8,  KEY_F(10),       Spltjoin,    FALSE,FALSE, (unsigned char *)""},  /* comm4.c */
#endif
 {(unsigned char *)"ssave",       2,  0,               Ssave,       TRUE, FALSE, (unsigned char *)""},  /* comm4.c */
 {(unsigned char *)"stay",        4,  0,               Stay,        TRUE, TRUE,  (unsigned char *)""},  /* comm4.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"tabcmd",      4,  KEY_HOME,        Tabcmd,      FALSE,FALSE, (unsigned char *)""},  /* comm5.c */
#else
 {(unsigned char *)"tabcmd",      4,  KEY_HOME,        Tabcmd,      FALSE,FALSE, (unsigned char *)""},  /* comm5.c */
 {(unsigned char *)"tabcmd",      4,  KEY_Do,          Tabcmd,      FALSE,FALSE, (unsigned char *)""},  /* comm5.c */
#endif
 {(unsigned char *)"tabkey",      4,  0,               Tabkey,      TRUE, TRUE,  (unsigned char *)""},  /* comm5.c */
 {(unsigned char *)"tabpre",      4,  0,               Tabpre,      FALSE,FALSE, (unsigned char *)""},  /* comm5.c */
 {(unsigned char *)"tabs",        4,  0,               Tabs,        TRUE, TRUE,  (unsigned char *)""},  /* comm5.c */
 {(unsigned char *)"tabsin",      5,  0,               Tabsin,      TRUE, TRUE,  (unsigned char *)""},  /* comm5.c */
 {(unsigned char *)"tabsout",     5,  0,               Tabsout,     TRUE, TRUE,  (unsigned char *)""},  /* comm5.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"top",         3,  KEY_C_PGUP,      Top,         TRUE, FALSE, (unsigned char *)""},  /* comm5.c */
#else
 {(unsigned char *)"top",         3,  0,               Top,         TRUE, FALSE, (unsigned char *)""},  /* comm5.c */
#endif
 {(unsigned char *)"up",          2,  0,               Up,          TRUE, FALSE, (unsigned char *)"1"}, /* comm5.c */
#if defined(DOS) || defined(OS2)
 {(unsigned char *)"up_arrow",    0,  KEY_CURU,        Up_arrow,    FALSE,FALSE, (unsigned char *)""},  /* comm5.c */
#else
 {(unsigned char *)"up_arrow",    0,  KEY_UP,          Up_arrow,    FALSE,FALSE, (unsigned char *)""},  /* comm5.c */
#endif
 {(unsigned char *)"verify",      1,  0,               Verify,      FALSE,TRUE,  (unsigned char *)""},  /* comm5.c */
 {(unsigned char *)"zone",        1,  0,               Zone,        TRUE, TRUE,  (unsigned char *)""}   /* comm5.c */
};
