/* Copyright (C) Stephen Chung, 1991-1993.  All rights reserved. */

#include "jwp.h"

#include "idm.h"


static char StatusText[MAXLINELEN];



static int ClosestUnit (int x, int units)
{
    return ((x + (units / 2)) / units);
}



void Triangles (FILEOPTIONS *f)
{
    RECT rect;

    if (!(f->type & FN_NORMAL) || f->hwnd == NULL || RULER(f).hwnd == NULL) return;

    if (RULER(f).startx == f->startx &&
        RULER(f).left == CURPARA(f)->leftindent &&
        RULER(f).right == CURPARA(f)->rightindent &&
        RULER(f).first == CURPARA(f)->firstindent)
        return;

    GetClientRect(RULER(f).hwnd, &rect);

    if (RULER(f).startx == f->startx) {
        rect.top = RULER(f).upperrow + 1;
        rect.bottom = RULERHEIGHT - 1;
        rect.left = 0;

        InvalidateRect(RULER(f).hwnd, &rect, TRUE);
    } else {
        InvalidateRect(RULER(f).hwnd, NULL, TRUE);
    }
    UpdateWindow(RULER(f).hwnd);
}


static int DrawTriangle (HDC hdc, FILEOPTIONS *f, int pos, int which)
{
    POINT   pts[3];
    BOOL    absolute = FALSE;


    if (which < 0) {
        which = -which;
        absolute = TRUE;
    }


    switch (which) {

    case 1:
        if (absolute) {
            pts[1].x = pts[0].x = pos;
        } else {
            pts[1].x = pts[0].x = POS2PIXEL(f->linelen - pos);
        }
        pts[0].y = RULERHEIGHT - 2;
        pts[1].y = RULER(f).upperrow + 1;
        pts[2].y = RULER(f).middlerow;
        pts[2].x = pts[0].x - RULER(f).pointer;
		Polygon(hdc, pts, 3);
        return (pts[0].x);

    case 2:
        if (absolute) {
            pts[1].x = pts[0].x = pos;
        } else {
            pts[0].x = pts[1].x = POS2PIXEL(pos);
        }
        pts[0].y = RULER(f).middlerow - 1;
        pts[1].y = RULER(f).upperrow + 1;
        pts[2].x = pts[0].x + RULER(f).pointer;
        pts[2].y = RULER(f).middlerow - 1;
        Polygon(hdc, pts, 3);
        return (pts[0].x);

    case 3:
        if (absolute) {
            pts[1].x = pts[0].x = pos;
        } else {
            pts[0].x = pts[1].x = POS2PIXEL(pos);
        }
        pts[0].y = RULER(f).middlerow + 1;
        pts[1].y = RULER(f).lowerrow - 1;
        pts[2].x = pts[0].x + RULER(f).pointer;
        pts[2].y = RULER(f).middlerow + 1;
        Polygon(hdc, pts, 3);
		return (pts[0].x);

	default:
		return (0);
	}
}



LONG FAR PASCAL RulerProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	HDC         hdc;
	PAINTSTRUCT ps;
	RECT        rect;
	FILEOPTIONS *f;
	POSITION	p;
    PARAGRAPH   far *pp;
    HBRUSH      hbrush;
    HPEN        hpen;
	int         i, j, k, new;
	static int  buttondown = 0;
	static int  tripos;


    for (f = fileoptions; f != NULL; f = f->next) if (f->ruler.hwnd == hwnd) break;

    if (f == NULL) f = curfile;

    
    switch (message) {

    case WM_LBUTTONDOWN:
		if (!buttondown) {
            i = LOWORD(lParam);
            j = HIWORD(lParam);

            /* Within the triangles? */

			k = POS2PIXEL(f->linelen - CURPARA(f)->rightindent) - i;

            if (k <= RULER(f).pointer && k >= 0 &&
                j >= RULER(f).upperrow && j <= RULER(f).lowerrow) {

				buttondown = 1;         /* Right triangle */
                tripos = RULER(f).rightpos;
				goto Out1;
			}

            k = POS2PIXEL(CURPARA(f)->firstindent) - i;

            if (k <= 0 && k >= -(RULER(f).pointer) &&
				j >= RULER(f).upperrow && j < RULER(f).middlerow) {

                buttondown = 2;         /* Left upper triangle */
                tripos = RULER(f).firstpos;
				goto Out1;
			}

            k = POS2PIXEL(CURPARA(f)->leftindent) - i;

            if (k <= 0 && k >= -(RULER(f).pointer) &&
                j > RULER(f).middlerow && j <= RULER(f).lowerrow) {

                buttondown = 3;         /* Left lower triangle */
				tripos = RULER(f).leftpos;

                if (RULER(f).left == RULER(f).first) buttondown = 4;

				goto Out1;
			}

            return (0);

Out1:       SetCapture(hwnd);
        }
        return (0);

	case WM_MOUSEMOVE:
        if (!buttondown) return (0);

        i = LOWORD(lParam);
        j = HIWORD(lParam);

        if (i < BORDERSPACE) i = BORDERSPACE;
        if (i >= f->width) i = f->width - 1;

        new = i;

        if (buttondown == 1) {
            if (RULER(f).first > RULER(f).left)
				k = RULER(f).firstpos + 2 * RULER(f).pointer;
            else
                k = RULER(f).leftpos + 2 * RULER(f).pointer;

            if (new <= k) new = k + 1;
		} else {
            k = RULER(f).rightpos - 2 * RULER(f).pointer;
            if (new >= k) new = k - 1;
        }

        if (new != tripos) {
            hdc = GetDC(hwnd);

            hbrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
            hpen = CreatePen(PS_SOLID, 1, GetSysColor(COLOR_WINDOW));

            SelectObject(hdc, hbrush);
            SelectObject(hdc, hpen);
            if (buttondown == 4) {
                DrawTriangle(hdc, f, tripos, -2);
                DrawTriangle(hdc, f, tripos, -3);
            } else {
				DrawTriangle(hdc, f, tripos, -buttondown);
            }

            SelectObject(hdc, GetStockObject(BLACK_BRUSH));
            SelectObject(hdc, GetStockObject(BLACK_PEN));
            DeleteObject(hbrush);
            DeleteObject(hpen);

            if (buttondown == 4) {
                DrawTriangle(hdc, f, new, -2);
				DrawTriangle(hdc, f, new, -3);
            } else {
                DrawTriangle(hdc, f, new, -buttondown);
            }
            tripos = new;

            ReleaseDC(hwnd, hdc);
        }

        return (0);

    case WM_LBUTTONUP:
        if (!buttondown) return (0);

        hdc = GetDC(hwnd);

        hbrush = CreateSolidBrush(GetSysColor(COLOR_WINDOW));
        hpen = CreatePen(PS_SOLID, 1, GetSysColor(COLOR_WINDOW));

        SelectObject(hdc, hbrush);
        SelectObject(hdc, hpen);

        if (buttondown == 4) {
			DrawTriangle(hdc, f, tripos, -2);
            DrawTriangle(hdc, f, tripos, -3);
        } else {
            DrawTriangle(hdc, f, tripos, -buttondown);
        }

        SelectObject(hdc, GetStockObject(BLACK_BRUSH));
        SelectObject(hdc, GetStockObject(BLACK_PEN));

        DeleteObject(hbrush);
        DeleteObject(hpen);

		switch (buttondown) {
			case 1:
				new = ClosestUnit(tripos - BORDERSPACE + f->startx,
									f->basefont->width + f->leading);
				if (new <= RULER(f).first) new = RULER(f).first + 1;
				else if (new <= RULER(f).left) new = RULER(f).left + 1;
				new = f->linelen - new;

				if (CURPARA(f)->rightindent != new) f->changed = TRUE;
				RULER(f).rightpos = DrawTriangle(hdc, f, new, 1);
				RULER(f).right = new;

				if (SELPARA1(f) == NULL) {
                    UndoAddFormatParagraph(f, f->current, f->current);
					CURPARA(f)->rightindent = new;
				} else {
                    UndoAddFormatParagraph(f, SEL1(f), SEL2(f));
                    for (pp = SELPARA1(f); pp != SELPARA2(f)->next; pp = pp->next)
                        pp->rightindent = new;
				}
				break;
			case 2:
            case 4:
                new = ClosestUnit(tripos - BORDERSPACE + f->startx,
                                        f->basefont->width + f->leading);
                if (new >= f->linelen - RULER(f).right)
					new = RULER(f).right - 1;

				if (CURPARA(f)->firstindent != new) f->changed = TRUE;
                RULER(f).firstpos = DrawTriangle(hdc, f, new, 2);
                RULER(f).first = new;

                if (SELPARA1(f) == NULL) {
                    UndoAddFormatParagraph(f, f->current, f->current);
                    CURPARA(f)->firstindent = new;
				} else {
                    UndoAddFormatParagraph(f, SEL1(f), SEL2(f));
                    for (pp = SELPARA1(f); pp != SELPARA2(f)->next; pp = pp->next)
                        pp->firstindent = new;
                }
                if (buttondown == 2) break;

                /* Falls through... */
			case 3:
                new = ClosestUnit(tripos - BORDERSPACE + f->startx,
                                        f->basefont->width + f->leading);
                if (new >= f->linelen - RULER(f).right)
                    new = RULER(f).right - 1;

				if (CURPARA(f)->leftindent != new) f->changed = TRUE;
				RULER(f).leftpos = DrawTriangle(hdc, f, new, 3);
                RULER(f).left = new;

                if (SELPARA1(f) == NULL) {
                    if (buttondown == 3) UndoAddFormatParagraph(f, f->current, f->current);
					CURPARA(f)->leftindent = new;
                } else {
                    if (buttondown == 3) UndoAddFormatParagraph(f, SEL1(f), SEL2(f));
                    for (pp = SELPARA1(f); pp != SELPARA2(f)->next; pp = pp->next)
                        pp->leftindent = new;
                }
				break;
		}

		buttondown = 0;
        ReleaseDC(hwnd, hdc);
		ReleaseCapture();

		if (SELPARA1(f) != NULL) {
			PARAOF(p) = SELPARA1(f);
			LINEOF(p) = PARAOF(p)->lines;
			POSOF(p) = 0;

			ReformatParagraph(f, p, SELPARA2(f)->next, OP_UPDATE | OP_MOVETOEND);
		} else {
			PARAOF(p) = CURPARA(f);
			LINEOF(p) = PARAOF(p)->lines;
			POSOF(p) = 0;

			if (!f->caret) {
				MoveIntoWindow(f);
				InvalidateRect(f->hwnd, NULL, TRUE);
			}

			ReformatParagraph(f, p, PARAOF(p)->next, OP_UPDATE | OP_MOVETOEND);
		}
		f->changed = TRUE;
		f->pseudo = f->cursor;

		return (0);

	case WM_PAINT:
		GetClientRect(hwnd, &rect);

        hdc = BeginPaint(hwnd, &ps);

        SetBkMode(hdc, TRANSPARENT);

        SetTextColor(hdc, GetSysColor(COLOR_WINDOWTEXT));
        SetBkColor(hdc, GetSysColor(COLOR_WINDOW));
        hbrush = SelectObject(hdc, CreateSolidBrush(GetSysColor(COLOR_WINDOW)));
        hpen = SelectObject(hdc, CreatePen(PS_SOLID, 1, GetSysColor(COLOR_WINDOWFRAME)));

        /* Horizontal line of the ruler */

        MoveTo(hdc, BORDERSPACE, RULER(f).upperrow);
        LineTo(hdc, rect.right, RULER(f).upperrow);

        /* Base line of the ruler window */

        MoveTo(hdc, 0, RULERHEIGHT - 1);
        LineTo(hdc, rect.right, RULERHEIGHT - 1);

        /* Left vertical line of the ruler */

        MoveTo(hdc, BORDERSPACE, RULER(f).upperrow);
        LineTo(hdc, BORDERSPACE, -1);


        for (k = (f->startx) / BASEWIDTH(f), i = BORDERSPACE;
             i <= rect.right;
             k++, i += f->basefont->width + f->leading) {

            /* Tick marks */

            MoveTo(hdc, i, RULER(f).upperrow);
            LineTo(hdc, i, RULER(f).upperrow -
                    ((k % 5) ? RULER(f).smallticks : RULER(f).bigticks));

            if (k % 10 == 0) {
                char buf[10];

                sprintf(buf, "%d", k);
                TextOut(hdc, i + 1, RULER(f).upperrow - global.textmetric.tmAscent - 1,
                            buf, strlen(buf));
            }
		}

		/* Draw the triangles */

		if (f->hwnd != NULL) {
            DeleteObject(SelectObject(hdc, GetStockObject(BLACK_BRUSH)));
            DeleteObject(SelectObject(hdc, GetStockObject(BLACK_PEN)));

            RULER(f).rightpos =
				DrawTriangle(hdc, f, CURPARA(f)->rightindent, 1);
            RULER(f).firstpos =
				DrawTriangle(hdc, f, CURPARA(f)->firstindent, 2);
            RULER(f).leftpos =
                DrawTriangle(hdc, f, CURPARA(f)->leftindent, 3);

            RULER(f).left = CURPARA(f)->leftindent;
            RULER(f).right = CURPARA(f)->rightindent;
            RULER(f).first = CURPARA(f)->firstindent;
			RULER(f).startx = f->startx;
        } else {
            DeleteObject(SelectObject(hdc, hbrush));
            DeleteObject(SelectObject(hdc, hpen));
        }

        EndPaint(hwnd, &ps);
        return (0);
    }

	return (DefWindowProc(hwnd, message, wParam, lParam));
}



void DisplayRuler (FILEOPTIONS *f, BOOL on)
{
	RECT rect;

	GetClientRect(f->parent, &rect);

	if (!on) {
		if (RULER(f).hwnd != NULL) {
			DestroyWindow(RULER(f).hwnd);

			if (f->hwnd != NULL) {
				MoveWindow(f->hwnd, BORDERSPACE, BORDERSPACE,
						   rect.right - BORDERSPACE, rect.bottom - BORDERSPACE, TRUE);
            }
            RULER(f).hwnd = NULL;
		}
		return;
	}

	RULER(f).hwnd = CreateWindow ("JWP Ruler", NULL, WS_CHILDWINDOW | WS_VISIBLE,
								  0, 0, rect.right, RULERHEIGHT, f->parent, 1, hInstance, NULL);

	if (f->hwnd != NULL) {
		MoveWindow(f->hwnd, BORDERSPACE, BORDERSPACE + RULERHEIGHT,
					rect.right - BORDERSPACE, rect.bottom - BORDERSPACE - RULERHEIGHT, TRUE);
	}
}



void StatusMessage (char *mesg)
{
    RECT rect;

    if (global.statushwnd == NULL) return;

    if (!strcmp(mesg, StatusText)) return;

    strcpy(StatusText, mesg);

    GetClientRect(global.statushwnd, &rect);

    rect.left = BORDERSPACE;
    rect.right -= BORDERSPACE;
    rect.top = 0.1 * AVGHEIGHT;
    rect.bottom = rect.top + AVGHEIGHT + 1;

    InvalidateRect(global.statushwnd, &rect, FALSE);
    UpdateWindow(global.statushwnd);
}



LONG FAR PASCAL StatusProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
    HDC         hdc;
    PAINTSTRUCT ps;
    RECT        rect;

    switch (message) {

    case WM_PAINT:
        hdc = BeginPaint(hwnd, &ps);

        SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
        SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));

        GetClientRect(hwnd, &rect);
        rect.left--;    rect.right++;   rect.top--;     rect.bottom++;

		Create3DEffect(hdc, &rect, 1, 0);

        SelectObject (hdc, GetStockObject(SYSTEM_FONT));
        SetBkMode (hdc, TRANSPARENT);

        if (StatusText != NULL)
            TextOut(hdc, BORDERSPACE, 0.1 * AVGHEIGHT, StatusText, strlen(StatusText));

        EndPaint(hwnd, &ps);
        return (0);
    }

    return (DefWindowProc(hwnd, message, wParam, lParam));
}
