/*
 *  Copyright (c) 1992 John E. Davis  (davis@amy.tch.harvard.edu)
 *  All Rights Reserved.
 */
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <bios.h>
#include <dos.h>
#include <mem.h>
#include "sysdep.h"
#include "display.h"

int Scroll_r1 = 0, Scroll_r2 = 25, Cursor_Row = 1, Cursor_Col = 1;
unsigned char *Video_Base;
int Attribute_Byte = 0;	       /* Color for screen-- blue back */

int Cheap_Video = 0;
int Video_Status_Port;
int Msdos_Insert_Mode = 0;

#define SNOW_CHECK\
   if (Cheap_Video)\
     { while ((inp(0x3DA) & 0x08)); while (!(inp(0x3DA) & 0x08)); }

struct SREGS SegRegs;

void set_scroll_region(int r1, int r2)
{
    Scroll_r1 = r1 - 1;
    Scroll_r2 = r2 - 1;
}

void reset_scroll_region(void)
{
    Scroll_r1 = 0;
    Scroll_r2 = Screen_Height;
}

void goto_rc(int r, int c)
{
   union REGS in, out;

   if (r > Screen_Height) r = Screen_Height;
   if (c > Screen_Width) c = Screen_Width;
   Cursor_Row = r;
   Cursor_Col = c;
   in.h.ah = 0x2;
   in.h.dh = Cursor_Row + Scroll_r1 - 1;
   in.h.dl = Cursor_Col - 1;
   in.h.bh = 0;
   int86x(0x10, &in, &out, &SegRegs);
}

void wherexy(void)
{
    union REGS in, out;

    in.h.ah = 0x3;
    in.h.bh = 0;
    int86x(0x10, &in, &out, &SegRegs);
    Cursor_Row = out.h.dh + 1;
    Cursor_Col = out.h.dl + 1;
}
/*
void curs_bol(void)
{
    goto_rc(Cursor_Row, 1);
}

void cursor_forward(int n)
{
    wherexy();
    if (n) goto_rc(Cursor_Row, Cursor_Col + 1);
}

void cursor_backward(int n)
{
    wherexy();
    if (n) goto_rc(Cursor_Row, Cursor_Col - n);
}

void cursor_up(int n)
{
    wherexy();
    if (n) goto_rc(Cursor_Row - n, Cursor_Col);
}

void cursor_down(int n)
{
    wherexy();
    if (n) goto_rc(Cursor_Row + n, Cursor_Col);
}
*/
void begin_insert(void)
{
    unsigned short *p, *p_min;

    Msdos_Insert_Mode = 1;
    wherexy();

    /* move the stuff over 1 column */
    p_min = (unsigned short *) (Video_Base +  (160 * (Cursor_Row - 1) + 2 * (Cursor_Col - 1)));
    p = (unsigned short *) (Video_Base + ((160 * (Cursor_Row - 1) 
					   + 2 * (Screen_Width - 1))));
    SNOW_CHECK;

    /* memmove((void *) p, (void *) s, n); */
    while(p-- > p_min) *(p + 1)= *p;
}

void end_insert(void)
{
    Msdos_Insert_Mode = 0;
}

void tt_delete_char()
{
    unsigned short *p, *p_max;

    wherexy();
    /* move the stuff over 1 column */
    p = (unsigned short *) (Video_Base +  
			    (160 * (Cursor_Row - 1) + 2 * (Cursor_Col - 1)));
    p_max = (unsigned short *) (Video_Base +  
				(160 * (Cursor_Row - 1) + 2 * (Screen_Width - 1)));
    SNOW_CHECK;
    while(p < p_max)
      {
	  *p = *(p + 1);
	  p++;
      }
}

void tt_erase_line(void)
{
    unsigned short *p, *pmax, word;

    p = (unsigned short *) (Video_Base + 160 * (Cursor_Row - 1));
    pmax = p + Screen_Width;
    word = (Attribute_Byte << 8) + (unsigned short) ' ';
    SNOW_CHECK;
    while(p < pmax)
      {
	  *p++ = word;
      }
}

void tt_delete_nlines(int n)
{
    /* This has the effect of pulling all lines below it up */
    union REGS in, out;
    in.h.ah = 0x6;
    in.h.al = n;
    in.h.ch = Scroll_r1;
    in.h.cl = 0;
    in.h.dh = Scroll_r2;
    in.h.dl = (Screen_Width - 1);
    in.h.bh = Attribute_Byte;   /* white forground on black back */
    int86x(0x10, &in, &out, &SegRegs);
}


void reverse_index(int n)
{
    union REGS in, out;
    in.h.ah = 0x7;
    in.h.al = n;
    in.h.ch = Scroll_r1;
    in.h.cl = 0;
    in.h.dh = Scroll_r2;
    in.h.dl = (Screen_Width - 1);
    in.h.bh = Attribute_Byte;   /* white forground on black back */
    int86x(0x10, &in, &out, &SegRegs);
}

int beep(void)
{
    /* clear the keyboard buffer since this is an error */
    sound(1500);
    delay(100);
    nosound();
    while(bioskey(1))
      {
	  if (!getch()) getch();
      }
    return(0);
}

void tt_del_eol(void)
{
    unsigned short *p, *pmax, word;

    p = (unsigned short *) (Video_Base +  (160 * (Cursor_Row - 1) + 2 * (Cursor_Col - 1)));
    pmax = (unsigned short *) (Video_Base +  (160 * (Cursor_Row - 1) + 2 * Screen_Width));
    word = (Attribute_Byte << 8) + (unsigned short) ' ';
    SNOW_CHECK;
    while(p < pmax)
      {
	  *p++ = word;
      }
}

/* open line at current place and push rest down */
/*
void tt_open_line(int n)
{
    int s;

    s = Scroll_r1;
    Scroll_r2 = Cursor_Row - 1;
    reverse_index(n);
    Scroll_r1 = s;
}
*/
void tt_reverse_video(void)
{
   unsigned char fg, bg;

   fg = (Attribute_Byte & 0x07) << 4;
   bg = (Attribute_Byte & 0x70) >> 4;
   Attribute_Byte = fg | bg;
}

void tt_normal_video(void)
{
   tt_reverse_video();
}

void smart_puts(char *new, char *dummy, int row)
{
    unsigned short *p, *p_max, *s;
    unsigned short buf[180];
    unsigned int n;
   
   (void) dummy;
    Cursor_Row = row;
    Cursor_Col = 1;
    if (Msdos_Insert_Mode) begin_insert();
    new[Screen_Width] = 0;
    p = (unsigned short *) (Video_Base +  (160 * (Cursor_Row - 1)));
    p_max = (unsigned short *) (Video_Base +  
				(160 * (Cursor_Row - 1) + 2 * Screen_Width));

    /* fill the buffer to be output */

    s = (unsigned short *) buf;

    while (*new != 0)
      {
	 /* *old++ = *new++;
	  *old++ = Attribute_Byte; */
	  *s++ = (Attribute_Byte << 8) + (unsigned) *new++;
      }

    s = (unsigned short *) buf;

    n = 2 * (unsigned int) (p_max - p);
    SNOW_CHECK;
    memmove((void *) p, (void *) s, n);
}

void reset_video(void)
{
}

void init_video(void)
{
    unsigned char *p;
    union REGS in, out;


   Cursor_Row = Cursor_Col = 1;
   p = (unsigned char far *) 0x00400049L;

   Video_Status_Port = 0x3DA;
   
   if (*p == 7)
     {
	Video_Status_Port = 0x3BA;
	Video_Base = (unsigned char *) MK_FP(0xb000,0000);
     }
   else Video_Base = (unsigned char *) MK_FP(0xb800,0000);

   /* test for video adapter type.  Of primary interest is whether there is
      snow or not.  Assume snow if the card is color and not EGA or greater.
   */

   /* Use Ralf Brown test for EGA or greater */
   Cheap_Video = 0;
   in.h.ah = 0x12;
   in.h.bl = 0x10;
   in.h.bh = 0xFF;
   int86x(0x10, &in, &out, &SegRegs);
   if (out.h.bh != 0xFF)
     {
	if (!Attribute_Byte) Attribute_Byte = 0x17;
	return;   /* EGA or greater will change this */
     }
   
   if (!Attribute_Byte) Attribute_Byte = 0x7;
   in.h.ah = 0x0F;
   int86x(0x10, &in, &out, &SegRegs);
   if (out.h.al != 0x07) Cheap_Video = 1;
   return;
}

void wide_width(void)
{
}

void narrow_width(void)
{
}

void cls(void)
{
    union REGS in, out;

    in.h.ah = 0x7;
    in.h.bh = Attribute_Byte & 0xFF;   /* white forground on black back */
    in.h.al = 0; /* Screen_Height; */
    in.h.ch = 0;
    in.h.cl = 0;
    in.h.dh = Screen_Height - 1; 
    in.h.dl = Screen_Width - 1;
    int86x(0x10, &in, &out, &SegRegs);
}
